/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.tx;

import java.util.Random;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.tx.Tx;
import org.jboss.aspects.tx.TxSupport;
import org.jboss.logging.Logger;
import org.jboss.util.deadlock.ApplicationDeadlockException;

public class TxInterceptor
implements Interceptor {
    public static int MAX_RETRIES = 5;
    public static Random random = new Random();
    protected Logger log = Logger.getLogger(this.getClass());
    private TransactionManager tm;
    static /* synthetic */ Class class$org$jboss$aspects$tx$Tx;

    public TxInterceptor(TransactionManager tm) {
        this.tm = tm;
    }

    public String getName() {
        return "TxInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Transaction oldTransaction = this.tm.getTransaction();
        for (int i = 0; i < MAX_RETRIES; ++i) {
            try {
                return this.internalInvoke(invocation);
            }
            catch (Exception ex) {
                ApplicationDeadlockException deadlock = ApplicationDeadlockException.isADE((Throwable)ex);
                if (deadlock != null) {
                    if (!deadlock.retryable() || oldTransaction != null || i + 1 >= MAX_RETRIES) {
                        throw deadlock;
                    }
                } else {
                    throw ex;
                }
                this.log.warn((Object)(deadlock.getMessage() + " retrying " + (i + 1)));
                Thread.sleep(random.nextInt(1 + i), random.nextInt(1000));
                continue;
            }
        }
        throw new RuntimeException("Unreachable");
    }

    protected Object internalInvoke(Invocation invocation) throws Throwable {
        String txtype = this.resolveTxType(invocation);
        TxSupport txSupport = null;
        txSupport = txtype == null ? TxSupport.DEFAULT : TxSupport.byName(txtype);
        if (txSupport == null) {
            txSupport = TxSupport.DEFAULT;
        }
        return txSupport.serverInvoke(invocation, this.tm);
    }

    protected String resolveTxType(Invocation invocation) {
        String txtype = (String)invocation.getMetaData((Object)"transaction", (Object)"trans-attribute");
        if (txtype == null) {
            Tx tx = (Tx)invocation.resolveAnnotation(class$org$jboss$aspects$tx$Tx == null ? (class$org$jboss$aspects$tx$Tx = TxInterceptor.class$("org.jboss.aspects.tx.Tx")) : class$org$jboss$aspects$tx$Tx);
            if (tx == null) {
                tx = (Tx)invocation.resolveClassAnnotation(class$org$jboss$aspects$tx$Tx == null ? (class$org$jboss$aspects$tx$Tx = TxInterceptor.class$("org.jboss.aspects.tx.Tx")) : class$org$jboss$aspects$tx$Tx);
            }
            if (tx != null) {
                txtype = tx.value().name();
            }
        }
        return txtype;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

