/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.deployment;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.aop.AspectManager;
import org.jboss.aop.AspectNotificationHandler;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.aop.ClassLoaderValidation;
import org.jboss.aop.ClassPoolFactory;
import org.jboss.aop.Deployment;
import org.jboss.aop.deployment.AspectManagerServiceMBean;
import org.jboss.aop.deployment.JBossClassLoaderValidator;
import org.jboss.aop.deployment.JBossClassPoolFactory;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.ServiceMBeanSupport;

public class AspectManagerService
extends ServiceMBeanSupport
implements AspectManagerServiceMBean,
AspectNotificationHandler {
    public static final ObjectName DEFAULT_LOADER_REPOSITORY = ObjectNameFactory.create((String)"JMImplementation:service=LoaderRepository,name=Default");
    boolean created = false;
    protected File tmpClassesDir;
    protected boolean enableTransformer = true;
    protected boolean suppressTransformationErrors = true;
    protected boolean suppressReferenceErrors = true;

    protected ClassPoolFactory createFactory() throws Exception {
        return new JBossClassPoolFactory(this.tmpClassesDir);
    }

    protected ClassLoaderValidation createClassLoaderValidation() {
        return new JBossClassLoaderValidator();
    }

    protected void createService() throws Exception {
        if (this.tmpClassesDir == null) {
            String jbossTmpDir = System.getProperty("jboss.server.temp.dir");
            if (jbossTmpDir == null) {
                jbossTmpDir = System.getProperty("java.io.tmpdir");
            }
            this.tmpClassesDir = new File(jbossTmpDir, "aopdynclasses");
        }
        if (!this.tmpClassesDir.exists() && !this.tmpClassesDir.mkdirs()) {
            throw new FileNotFoundException("Failed to create tmpClassesDir: " + this.tmpClassesDir.getAbsolutePath());
        }
        AspectManager.classPoolFactory = this.createFactory();
        AspectManager.classLoaderValidator = this.createClassLoaderValidation();
        Deployment.searchClasspath = false;
        AspectManager.suppressTransformationErrors = this.suppressTransformationErrors;
        AspectManager mgr = AspectManager.instance();
        if (this.enableTransformer) {
            this.attachTranslator();
        }
        this.created = true;
        AspectManager.notificationHandler = this;
        this.baseAop();
    }

    protected void baseAop() {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL base = cl.getResource("base-aop.xml");
            AspectXmlLoader.deployXML((URL)base);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void attachTranslator() {
        AspectManager mgr = AspectManager.instance();
        try {
            this.server.setAttribute(DEFAULT_LOADER_REPOSITORY, new Attribute("Translator", mgr));
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (AttributeNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAttributeValueException e) {
            throw new RuntimeException(e);
        }
        catch (MBeanException e) {
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
    }

    protected void detachTranslator() {
        try {
            this.server.setAttribute(DEFAULT_LOADER_REPOSITORY, new Attribute("Translator", null));
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (AttributeNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAttributeValueException e) {
            throw new RuntimeException(e);
        }
        catch (MBeanException e) {
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
    }

    public void attachClass(String classname) {
        Notification msg = new Notification("AOP class attached", this, this.getNextNotificationSequenceNumber());
        msg.setUserData(classname);
        this.sendNotification(msg);
    }

    protected void startService() throws Exception {
    }

    protected void stopService() {
    }

    public File getTmpClassesDir() {
        return this.tmpClassesDir;
    }

    public void setTmpClassesDir(File tmpClassesDir) {
        this.tmpClassesDir = tmpClassesDir;
    }

    public boolean getVerbose() {
        return AspectManager.verbose;
    }

    public void setVerbose(boolean verbose) {
        AspectManager.verbose = verbose;
    }

    public boolean getOptimized() {
        return AspectManager.optimize;
    }

    public void setOptimized(boolean verbose) {
        AspectManager.optimize = verbose;
    }

    public boolean getSuppressTransformationErrors() {
        return this.suppressTransformationErrors;
    }

    public void setSuppressTransformationErrors(boolean suppressTransformationErrors) {
        this.suppressTransformationErrors = suppressTransformationErrors;
        AspectManager.suppressTransformationErrors = suppressTransformationErrors;
    }

    public boolean getSuppressReferenceErrors() {
        return this.suppressReferenceErrors;
    }

    public void setSuppressReferenceErrors(boolean suppressReferenceErrors) {
        this.suppressReferenceErrors = suppressReferenceErrors;
        AspectManager.suppressReferenceErrors = suppressReferenceErrors;
    }

    public boolean getEnableTransformer() {
        return this.enableTransformer;
    }

    public String interceptorFactories() {
        Map factories = AspectManager.instance().getInterceptorFactories();
        Iterator it = factories.keySet().iterator();
        StringBuffer buffer = new StringBuffer("");
        while (it.hasNext()) {
            buffer.append(it.next() + "<br>");
        }
        return buffer.toString();
    }

    public String aspectDefinitions() {
        Map factories = AspectManager.instance().getAspectDefinitions();
        Iterator it = factories.keySet().iterator();
        StringBuffer buffer = new StringBuffer("");
        while (it.hasNext()) {
            buffer.append(it.next() + "<br>");
        }
        return buffer.toString();
    }

    public String introductions() {
        Map factories = AspectManager.instance().getInterfaceIntroductions();
        Iterator it = factories.keySet().iterator();
        StringBuffer buffer = new StringBuffer("");
        while (it.hasNext()) {
            buffer.append(it.next() + "<br>");
        }
        return buffer.toString();
    }

    public String stacks() {
        Map factories = AspectManager.instance().getInterceptorStacks();
        Iterator it = factories.keySet().iterator();
        StringBuffer buffer = new StringBuffer("");
        while (it.hasNext()) {
            buffer.append(it.next() + "<br>");
        }
        return buffer.toString();
    }

    public String bindings() {
        LinkedHashMap factories = AspectManager.instance().getBindings();
        Iterator it = factories.keySet().iterator();
        StringBuffer buffer = new StringBuffer("");
        while (it.hasNext()) {
            buffer.append(it.next() + "<br>");
        }
        return buffer.toString();
    }

    public String registeredClassLoaders() {
        Map factories = AspectManager.instance().getRegisteredCLs();
        Iterator it = factories.keySet().iterator();
        StringBuffer buffer = new StringBuffer("");
        while (it.hasNext()) {
            buffer.append(it.next() + "<br>");
        }
        return buffer.toString();
    }

    public void setEnableTransformer(boolean enableTransformer) {
        if (this.enableTransformer == enableTransformer) {
            return;
        }
        if (this.getState() == 3) {
            if (enableTransformer) {
                this.attachTranslator();
            } else {
                this.detachTranslator();
            }
        }
        this.enableTransformer = enableTransformer;
    }
}

