/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.PersistentObjectException;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.entry.CacheEntry;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.engine.TwoPhaseLoad;
import org.hibernate.engine.Versioning;
import org.hibernate.event.LoadEvent;
import org.hibernate.event.LoadEventListener;
import org.hibernate.event.PostLoadEvent;
import org.hibernate.event.def.AbstractLockUpgradeEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public class DefaultLoadEventListener
extends AbstractLockUpgradeEventListener
implements LoadEventListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$event$def$DefaultLoadEventListener == null ? (class$org$hibernate$event$def$DefaultLoadEventListener = DefaultLoadEventListener.class$("org.hibernate.event.def.DefaultLoadEventListener")) : class$org$hibernate$event$def$DefaultLoadEventListener));
    public static final LockMode DEFAULT_LOCK_MODE = LockMode.NONE;
    static /* synthetic */ Class class$org$hibernate$event$def$DefaultLoadEventListener;

    public Object onLoad(LoadEvent event, LoadEventListener.LoadType loadType) throws HibernateException {
        EntityPersister persister;
        SessionImplementor source = event.getSession();
        if (event.getInstanceToLoad() != null) {
            persister = source.getEntityPersister(null, event.getInstanceToLoad());
            event.setEntityClassName(event.getInstanceToLoad().getClass().getName());
        } else {
            persister = source.getFactory().getEntityPersister(event.getEntityClassName());
        }
        if (persister == null) {
            throw new HibernateException("Unable to locate persister: " + event.getEntityClassName());
        }
        EntityKey keyToLoad = new EntityKey(event.getEntityId(), persister, source.getEntityMode());
        try {
            if (loadType.isNakedEntityReturned()) {
                return this.load(event, persister, keyToLoad, loadType);
            }
            return event.getLockMode() == LockMode.NONE ? this.proxyOrLoad(event, persister, keyToLoad, loadType) : this.lockAndLoad(event, persister, keyToLoad, loadType, source);
        }
        catch (HibernateException e) {
            log.info((Object)"Error performing load command", (Throwable)e);
            throw e;
        }
    }

    protected Object load(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) throws HibernateException {
        boolean isOptionalInstance;
        if (event.getInstanceToLoad() != null) {
            if (event.getSession().getPersistenceContext().getEntry(event.getInstanceToLoad()) != null) {
                throw new PersistentObjectException("attempted to load into an instance that was already associated with the session: " + MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory()));
            }
            persister.setIdentifier(event.getInstanceToLoad(), event.getEntityId(), event.getSession().getEntityMode());
        }
        Object entity = this.doLoad(event, persister, keyToLoad, options);
        boolean bl = isOptionalInstance = event.getInstanceToLoad() != null;
        if (!options.isAllowNulls() || isOptionalInstance) {
            ObjectNotFoundException.throwIfNull(entity, event.getEntityId(), event.getEntityClassName());
        }
        if (isOptionalInstance && entity != event.getInstanceToLoad()) {
            throw new NonUniqueObjectException(event.getEntityId(), event.getEntityClassName());
        }
        return entity;
    }

    protected Object proxyOrLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("loading entity: " + MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory())));
        }
        if (!persister.hasProxy()) {
            return this.load(event, persister, keyToLoad, options);
        }
        PersistenceContext persistenceContext = event.getSession().getPersistenceContext();
        Object proxy = persistenceContext.getProxy(keyToLoad);
        if (proxy != null) {
            return this.returnNarrowedProxy(event, persister, keyToLoad, options, persistenceContext, proxy);
        }
        if (options.isAllowProxyCreation()) {
            return this.createProxyIfNecessary(event, persister, keyToLoad, options, persistenceContext);
        }
        return this.load(event, persister, keyToLoad, options);
    }

    private Object returnNarrowedProxy(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options, PersistenceContext persistenceContext, Object proxy) {
        log.trace((Object)"entity proxy found in session cache");
        Object impl = options.isAllowProxyCreation() ? null : this.load(event, persister, keyToLoad, options);
        return persistenceContext.narrowProxy(proxy, persister, keyToLoad, impl);
    }

    private Object createProxyIfNecessary(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options, PersistenceContext persistenceContext) {
        Object existing = persistenceContext.getEntity(keyToLoad);
        if (existing != null) {
            log.trace((Object)"entity found in session cache");
            if (options.isCheckDeleted()) {
                EntityEntry entry = persistenceContext.getEntry(existing);
                this.throwObjectDeletedIfNecessary(event, entry);
            }
            return existing;
        }
        log.trace((Object)"creating new proxy for entity");
        Object proxy = persister.createProxy(event.getEntityId(), event.getSession());
        persistenceContext.getBatchFetchQueue().addBatchLoadableEntityKey(keyToLoad);
        persistenceContext.addProxy(keyToLoad, proxy);
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object lockAndLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options, SessionImplementor source) throws HibernateException {
        Object entity;
        CacheKey ck;
        CacheConcurrencyStrategy.SoftLock lock = null;
        if (persister.hasCache()) {
            ck = new CacheKey(event.getEntityId(), persister.getIdentifierType(), persister.getRootEntityName(), source.getEntityMode());
            lock = persister.getCache().lock(ck, null);
        } else {
            ck = null;
        }
        try {
            entity = this.load(event, persister, keyToLoad, options);
            Object var10_9 = null;
            if (!persister.hasCache()) return event.getSession().getPersistenceContext().proxyFor(persister, keyToLoad, entity);
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (!persister.hasCache()) throw throwable;
            persister.getCache().release(ck, lock);
            throw throwable;
        }
        persister.getCache().release(ck, lock);
        return event.getSession().getPersistenceContext().proxyFor(persister, keyToLoad, entity);
    }

    protected Object doLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) throws HibernateException {
        Object entity;
        if (log.isTraceEnabled()) {
            log.trace((Object)("attempting to resolve: " + MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory())));
        }
        if ((entity = this.loadFromSessionCache(event, keyToLoad, options)) != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("resolved object in session cache: " + MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory())));
            }
            return entity;
        }
        entity = this.loadFromSecondLevelCache(event, persister, options);
        if (entity != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("resolved object in second-level cache: " + MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory())));
            }
            return entity;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("object not resolved in any cache: " + MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory())));
        }
        return this.loadFromDatasource(event, persister, keyToLoad, options);
    }

    protected Object loadFromDatasource(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) throws HibernateException {
        SessionImplementor source = event.getSession();
        Object entity = persister.load(event.getEntityId(), event.getInstanceToLoad(), event.getLockMode(), source);
        if (event.isAssociationFetch() && source.getFactory().getStatistics().isStatisticsEnabled()) {
            source.getFactory().getStatisticsImplementor().fetchEntity(event.getEntityClassName());
        }
        return entity;
    }

    protected Object loadFromSessionCache(LoadEvent event, EntityKey keyToLoad, LoadEventListener.LoadType options) throws HibernateException {
        SessionImplementor session = event.getSession();
        Object old = session.getEntityUsingInterceptor(keyToLoad);
        if (old != null) {
            EntityEntry oldEntry = session.getPersistenceContext().getEntry(old);
            if (options.isCheckDeleted()) {
                this.throwObjectDeletedIfNecessary(event, oldEntry);
            }
            this.upgradeLock(old, oldEntry, event.getLockMode(), session);
        }
        return old;
    }

    private void throwObjectDeletedIfNecessary(LoadEvent event, EntityEntry oldEntry) {
        Status status = oldEntry.getStatus();
        if (status == Status.DELETED || status == Status.GONE) {
            throw new ObjectDeletedException("The object with that id was deleted", event.getEntityId(), event.getEntityClassName());
        }
    }

    protected Object loadFromSecondLevelCache(LoadEvent event, EntityPersister persister, LoadEventListener.LoadType options) throws HibernateException {
        boolean useCache;
        SessionImplementor source = event.getSession();
        boolean bl = useCache = persister.hasCache() && source.getCacheMode().isGetEnabled() && event.getLockMode().lessThan(LockMode.READ);
        if (useCache) {
            SessionFactoryImplementor factory = source.getFactory();
            CacheKey ck = new CacheKey(event.getEntityId(), persister.getIdentifierType(), persister.getRootEntityName(), source.getEntityMode());
            Object ce = persister.getCache().get(ck, source.getTimestamp());
            if (factory.getStatistics().isStatisticsEnabled()) {
                if (ce == null) {
                    factory.getStatisticsImplementor().secondLevelCacheMiss(persister.getCache().getRegionName());
                } else {
                    factory.getStatisticsImplementor().secondLevelCacheHit(persister.getCache().getRegionName());
                }
            }
            if (ce != null) {
                CacheEntry entry = (CacheEntry)persister.getCacheEntryStructure().destructure(ce, factory);
                return this.assembleCacheEntry(entry, event.getEntityId(), persister, event);
            }
        }
        return null;
    }

    private Object assembleCacheEntry(CacheEntry entry, Serializable id, EntityPersister persister, LoadEvent event) throws HibernateException {
        Object optionalObject = event.getInstanceToLoad();
        SessionImplementor session = event.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        if (log.isTraceEnabled()) {
            log.trace((Object)("resolved object in second-level cache: " + MessageHelper.infoString(persister, id, factory)));
        }
        EntityPersister subclassPersister = factory.getEntityPersister(entry.getSubclass());
        Object result = optionalObject == null ? session.instantiate(subclassPersister, id) : optionalObject;
        TwoPhaseLoad.addUninitializedEntity(id, result, subclassPersister, LockMode.NONE, session);
        Type[] types = subclassPersister.getPropertyTypes();
        Object[] values = entry.assemble(result, id, subclassPersister, session.getInterceptor(), session);
        TypeFactory.deepCopy(values, types, subclassPersister.getPropertyUpdateability(), values, session);
        Object version = Versioning.getVersion(values, subclassPersister);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Cached Version: " + version));
        }
        PersistenceContext persistenceContext = session.getPersistenceContext();
        persistenceContext.addEntry(result, Status.MANAGED, values, null, id, version, LockMode.NONE, true, subclassPersister, false);
        subclassPersister.afterInitialize(result, entry.areLazyPropertiesUnfetched(), session);
        persistenceContext.initializeNonLazyCollections();
        PostLoadEvent postLoadEvent = new PostLoadEvent(session).setEntity(result).setId(id).setPersister(persister);
        session.getListeners().getPostLoadEventListener().onPostLoad(postLoadEvent);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

