/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.security;

import java.security.Principal;
import javax.security.auth.Subject;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.security.SecurityContext;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.SecurityAssociation;

public class AuthenticationInterceptor
implements Interceptor {
    protected Logger log = Logger.getLogger(this.getClass());
    protected AuthenticationManager authenticationManager;

    public AuthenticationInterceptor(AuthenticationManager manager) {
        this.authenticationManager = manager;
    }

    public String getName() {
        return "AuthenticationInterceptor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        Principal principal = (Principal)invocation.getMetaData((Object)"security", (Object)"principal");
        Object credential = invocation.getMetaData((Object)"security", (Object)"credential");
        if (principal == null) {
            principal = SecurityAssociation.getPrincipal();
        }
        if (credential == null) {
            credential = SecurityAssociation.getCredential();
        }
        Subject subject = new Subject();
        if (this.authenticationManager != null && !this.authenticationManager.isValid(principal, credential, subject)) {
            String message = "Authentication exception, principal=" + principal;
            this.log.error((Object)message);
            throw new SecurityException(message);
        }
        SecurityAssociation.pushSubjectContext((Subject)subject, (Principal)principal, (Object)credential);
        Object oldDomain = SecurityContext.currentDomain.get();
        try {
            SecurityContext.currentDomain.set(this.authenticationManager);
            Object object = invocation.invokeNext();
            return object;
        }
        finally {
            SecurityContext.currentDomain.set(oldDomain);
            SecurityAssociation.popSubjectContext();
        }
    }
}

