/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.encoding.ser;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.jboss.axis.encoding.SerializationContext;
import org.jboss.axis.encoding.SimpleValueSerializer;
import org.jboss.axis.types.HexBinary;
import org.jboss.axis.utils.JavaUtils;
import org.jboss.axis.wsdl.fromJava.Types;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class HexSerializer
implements SimpleValueSerializer {
    public QName xmlType;
    public Class javaType;

    public HexSerializer(Class javaType, QName xmlType) {
        this.xmlType = xmlType;
        this.javaType = javaType;
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        context.startElement(name, attributes);
        context.writeString(this.getValueAsString(value, context));
        context.endElement();
    }

    public String getValueAsString(Object value, SerializationContext context) {
        value = JavaUtils.convert(value, this.javaType);
        if (this.javaType == HexBinary.class) {
            return value.toString();
        }
        if (this.javaType.getComponentType() == Byte.class) {
            return HexBinary.encode((Byte[])value);
        }
        if (this.javaType.getComponentType() == Byte.TYPE) {
            return HexBinary.encode((byte[])value);
        }
        throw new IllegalArgumentException("Invalid Type: " + this.javaType);
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class javaType, Types types) throws Exception {
        return null;
    }
}

