/*
 * Decompiled with CFR 0.152.
 */
package javax.emb;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.emb.FormatAlreadyBoundException;
import javax.emb.FormatNotFoundException;
import javax.emb.MediaFormat;

public final class MediaFormatRegistry {
    public static final MediaFormatRegistry SINGLETON = new MediaFormatRegistry();
    private final Map mediaFormats = Collections.synchronizedMap(new HashMap());

    private MediaFormatRegistry() {
    }

    public void bind(String fileExtension, MediaFormat mediaFormat) throws FormatAlreadyBoundException {
        if (fileExtension == null || mediaFormat == null) {
            throw new NullPointerException();
        }
        if (this.mediaFormats.containsKey(fileExtension = fileExtension.toLowerCase())) {
            throw new FormatAlreadyBoundException();
        }
        this.mediaFormats.put(fileExtension, mediaFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getFileExtensions() {
        Map map = this.mediaFormats;
        synchronized (map) {
            return this.mediaFormats.keySet().iterator();
        }
    }

    public MediaFormat lookup(String fileExtension) throws FormatNotFoundException {
        if (!this.mediaFormats.containsKey(fileExtension = fileExtension.toLowerCase())) {
            throw new FormatNotFoundException();
        }
        return (MediaFormat)this.mediaFormats.get(fileExtension);
    }

    public void rebind(String fileExtension, MediaFormat mediaFormat) {
        if (fileExtension == null || mediaFormat == null) {
            throw new NullPointerException();
        }
        fileExtension = fileExtension.toLowerCase();
        this.mediaFormats.put(fileExtension, mediaFormat);
    }

    public void unbind(String fileExtension) throws FormatNotFoundException {
        if (fileExtension == null) {
            throw new NullPointerException();
        }
        if (!this.mediaFormats.containsKey(fileExtension = fileExtension.toLowerCase())) {
            throw new FormatNotFoundException();
        }
        this.mediaFormats.remove(fileExtension);
    }
}

