/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.singleton;

import java.security.InvalidParameterException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.ha.singleton.HASingletonControllerMBean;
import org.jboss.ha.singleton.HASingletonSupport;

public class HASingletonController
extends HASingletonSupport
implements HASingletonControllerMBean {
    private ObjectName mSingletonMBean;
    private String mSingletonMBeanStartMethod;
    private String mSingletonMBeanStartMethodArgument;
    private String mSingletonMBeanStopMethod;
    private String mSingletonMBeanStopMethodArgument;
    private static final Object[] NO_ARGS = new Object[0];
    private static final String[] NO_TYPES = new String[0];

    public void startSingleton() {
        super.startSingleton();
        try {
            this.log.debug((Object)("Starting: " + this.mSingletonMBean + " using: " + this.mSingletonMBeanStartMethod));
            this.invokeSingletonMBeanMethod(this.mSingletonMBean, this.mSingletonMBeanStartMethod, this.mSingletonMBeanStartMethodArgument);
        }
        catch (JMException jme) {
            this.log.error((Object)"Controlled Singleton MBean failed to become master", (Throwable)jme);
        }
    }

    public void stopSingleton() {
        super.stopSingleton();
        try {
            this.log.debug((Object)("Stopping: " + this.mSingletonMBean + " using: " + this.mSingletonMBeanStopMethod));
            this.invokeSingletonMBeanMethod(this.mSingletonMBean, this.mSingletonMBeanStopMethod, this.mSingletonMBeanStopMethodArgument);
        }
        catch (JMException jme) {
            this.log.error((Object)"Controlled Singleton MBean failed to resign from master position", (Throwable)jme);
        }
    }

    protected Object invokeSingletonMBeanMethod(ObjectName name, String operationName, Object param) throws InstanceNotFoundException, MBeanException, ReflectionException {
        Object[] params = NO_ARGS;
        String[] signature = NO_TYPES;
        if (param != null) {
            params = new Object[]{param};
            signature = new String[]{param.getClass().getName()};
        }
        return this.server.invoke(name, operationName, params, signature);
    }

    public ObjectName getTargetName() {
        return this.mSingletonMBean;
    }

    public void setTargetName(ObjectName targetObjectName) {
        this.mSingletonMBean = targetObjectName;
    }

    public String getTargetStartMethod() {
        return this.mSingletonMBeanStartMethod;
    }

    public void setTargetStartMethod(String targetStartMethod) throws InvalidParameterException {
        String methodName = null;
        methodName = targetStartMethod == null ? "" : targetStartMethod.trim();
        if (methodName.equals("")) {
            methodName = "startSingleton";
        }
        this.mSingletonMBeanStartMethod = methodName;
    }

    public String getTargetStopMethod() {
        return this.mSingletonMBeanStopMethod;
    }

    public void setTargetStopMethod(String targetStopMethod) throws InvalidParameterException {
        String methodName = null;
        methodName = targetStopMethod == null ? "" : targetStopMethod.trim();
        if (methodName.equals("")) {
            methodName = "stopSingleton";
        }
        this.mSingletonMBeanStopMethod = methodName;
    }

    public String getTargetStartMethodArgument() {
        return this.mSingletonMBeanStartMethodArgument;
    }

    public void setTargetStartMethodArgument(String targetStartMethodArgument) {
        this.mSingletonMBeanStartMethodArgument = targetStartMethodArgument;
    }

    public String getTargetStopMethodArgument() {
        return this.mSingletonMBeanStopMethodArgument;
    }

    public void setTargetStopMethodArgument(String targetStopMethodArgument) {
        this.mSingletonMBeanStopMethodArgument = targetStopMethodArgument;
    }
}

