/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChartInfo;
import org.jfree.chart.Legend;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.chart.event.LegendChangeEvent;
import org.jfree.chart.event.LegendChangeListener;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.event.TitleChangeEvent;
import org.jfree.chart.event.TitleChangeListener;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.Align;
import org.jfree.ui.Drawable;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.about.ProjectInfo;
import org.jfree.util.Log;
import org.jfree.util.LogContext;
import org.jfree.util.ObjectUtils;

public class JFreeChart
implements Drawable,
TitleChangeListener,
LegendChangeListener,
PlotChangeListener,
Serializable,
Cloneable {
    public static final ProjectInfo INFO = new JFreeChartInfo();
    public static final Font DEFAULT_TITLE_FONT = new Font("SansSerif", 1, 18);
    public static final Paint DEFAULT_BACKGROUND_PAINT = SystemColor.control;
    public static final Image DEFAULT_BACKGROUND_IMAGE = null;
    public static final int DEFAULT_BACKGROUND_IMAGE_ALIGNMENT = 15;
    public static float DEFAULT_BACKGROUND_IMAGE_ALPHA = 0.5f;
    private transient RenderingHints renderingHints;
    private boolean borderVisible;
    private transient Stroke borderStroke;
    private transient Paint borderPaint;
    private TextTitle title;
    private List subtitles;
    private Legend legend;
    private Plot plot;
    private transient Paint backgroundPaint;
    private transient Image backgroundImage;
    private int backgroundImageAlignment = 15;
    private float backgroundImageAlpha = 0.5f;
    private transient EventListenerList changeListeners;
    private transient EventListenerList progressListeners;
    private boolean notify;
    private static final LogContext LOGGER = Log.createContext(class$org$jfree$chart$JFreeChart == null ? (class$org$jfree$chart$JFreeChart = JFreeChart.class$("org.jfree.chart.JFreeChart")) : class$org$jfree$chart$JFreeChart);
    static /* synthetic */ Class class$org$jfree$chart$JFreeChart;
    static /* synthetic */ Class class$org$jfree$chart$event$ChartChangeListener;
    static /* synthetic */ Class class$org$jfree$chart$event$ChartProgressListener;

    public JFreeChart(Plot plot) {
        this(null, null, plot, false);
    }

    public JFreeChart(String title, Plot plot) {
        this(title, DEFAULT_TITLE_FONT, plot, true);
    }

    public JFreeChart(String title, Font titleFont, Plot plot, boolean createLegend) {
        if (plot == null) {
            throw new NullPointerException("JFreeChart(..): Plot is null");
        }
        this.progressListeners = new EventListenerList();
        this.changeListeners = new EventListenerList();
        this.notify = true;
        this.renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.borderVisible = false;
        this.borderStroke = new BasicStroke(1.0f);
        this.borderPaint = Color.black;
        this.plot = plot;
        plot.addChangeListener(this);
        this.subtitles = new ArrayList();
        if (createLegend) {
            this.setLegend(Legend.createInstance(this));
        }
        if (title != null) {
            if (titleFont == null) {
                titleFont = DEFAULT_TITLE_FONT;
            }
            this.title = new TextTitle(title, titleFont);
            this.title.addChangeListener(this);
        }
        this.backgroundPaint = DEFAULT_BACKGROUND_PAINT;
        this.backgroundImage = DEFAULT_BACKGROUND_IMAGE;
        this.backgroundImageAlignment = 15;
        this.backgroundImageAlpha = DEFAULT_BACKGROUND_IMAGE_ALPHA;
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        if (renderingHints == null) {
            throw new NullPointerException("RenderingHints given are null");
        }
        this.renderingHints = renderingHints;
        this.fireChartChanged();
    }

    public boolean isBorderVisible() {
        return this.borderVisible;
    }

    public void setBorderVisible(boolean visible) {
        this.borderVisible = visible;
        this.fireChartChanged();
    }

    public Stroke getBorderStroke() {
        return this.borderStroke;
    }

    public void setBorderStroke(Stroke stroke) {
        this.borderStroke = stroke;
        this.fireChartChanged();
    }

    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public void setBorderPaint(Paint paint) {
        this.borderPaint = paint;
        this.fireChartChanged();
    }

    public TextTitle getTitle() {
        return this.title;
    }

    public void setTitle(TextTitle title) {
        this.title = title;
        this.fireChartChanged();
    }

    public void setTitle(String title) {
        if (title != null) {
            if (this.title == null) {
                this.setTitle(new TextTitle(title, DEFAULT_TITLE_FONT));
            } else {
                this.title.setText(title);
            }
        } else {
            this.setTitle((TextTitle)null);
        }
    }

    public List getSubtitles() {
        return this.subtitles;
    }

    public void setSubtitles(List subtitles) {
        if (subtitles == null) {
            throw new NullPointerException("JFreeChart.setSubtitles(..): argument is null.");
        }
        this.subtitles = subtitles;
        this.fireChartChanged();
    }

    public int getSubtitleCount() {
        return this.subtitles.size();
    }

    public Title getSubtitle(int index) {
        if (index < 0 || index == this.getSubtitleCount()) {
            throw new IllegalArgumentException("JFreeChart.getSubtitle(...): index out of range.");
        }
        return (Title)this.subtitles.get(index);
    }

    public void addSubtitle(Title subtitle) {
        if (subtitle != null) {
            this.subtitles.add(subtitle);
            subtitle.addChangeListener(this);
            this.fireChartChanged();
        }
    }

    public Legend getLegend() {
        return this.legend;
    }

    public void setLegend(Legend legend) {
        Legend existing = this.legend;
        if (existing != null) {
            existing.removeChangeListener(this);
            existing.registerChart(null);
        }
        this.legend = legend;
        if (legend != null) {
            legend.registerChart(this);
            legend.addChangeListener(this);
        }
        this.fireChartChanged();
    }

    public Plot getPlot() {
        return this.plot;
    }

    public CategoryPlot getCategoryPlot() {
        return (CategoryPlot)this.plot;
    }

    public XYPlot getXYPlot() {
        return (XYPlot)this.plot;
    }

    public boolean getAntiAlias() {
        Object o = this.renderingHints.get(RenderingHints.KEY_ANTIALIASING);
        if (o == null) {
            return false;
        }
        return o.equals(RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public void setAntiAlias(boolean flag) {
        Object o = this.renderingHints.get(RenderingHints.KEY_ANTIALIASING);
        if (o == null) {
            o = RenderingHints.VALUE_ANTIALIAS_DEFAULT;
        }
        if (!flag && RenderingHints.VALUE_ANTIALIAS_OFF.equals(o) || flag && RenderingHints.VALUE_ANTIALIAS_ON.equals(o)) {
            return;
        }
        if (flag) {
            this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.fireChartChanged();
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (this.backgroundPaint != null) {
            if (!this.backgroundPaint.equals(paint)) {
                this.backgroundPaint = paint;
                this.fireChartChanged();
            }
        } else if (paint != null) {
            this.backgroundPaint = paint;
            this.fireChartChanged();
        }
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(Image image) {
        if (this.backgroundImage != null) {
            if (!this.backgroundImage.equals(image)) {
                this.backgroundImage = image;
                this.fireChartChanged();
            }
        } else if (image != null) {
            this.backgroundImage = image;
            this.fireChartChanged();
        }
    }

    public int getBackgroundImageAlignment() {
        return this.backgroundImageAlignment;
    }

    public void setBackgroundImageAlignment(int alignment) {
        if (this.backgroundImageAlignment != alignment) {
            this.backgroundImageAlignment = alignment;
            this.fireChartChanged();
        }
    }

    public float getBackgroundImageAlpha() {
        return this.backgroundImageAlpha;
    }

    public void setBackgroundImageAlpha(float alpha) {
        if (this.backgroundImageAlpha != alpha) {
            this.backgroundImageAlpha = alpha;
            this.fireChartChanged();
        }
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
        if (notify) {
            this.notifyListeners(new ChartChangeEvent(this));
        }
    }

    public void draw(Graphics2D g2, Rectangle2D area) {
        this.draw(g2, area, null, null);
    }

    public void draw(Graphics2D g2, Rectangle2D area, ChartRenderingInfo info) {
        this.draw(g2, area, null, info);
    }

    public void draw(Graphics2D g2, Rectangle2D chartArea, Point2D anchor, ChartRenderingInfo info) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entering draw() method, chartArea = " + chartArea.toString());
        }
        this.notifyListeners(new ChartProgressEvent(this, this, 1, 0));
        if (info != null) {
            info.clear();
            info.setChartArea(chartArea);
        }
        Shape savedClip = g2.getClip();
        g2.clip(chartArea);
        g2.addRenderingHints(this.renderingHints);
        if (this.backgroundPaint != null) {
            g2.setPaint(this.backgroundPaint);
            g2.fill(chartArea);
        }
        if (this.backgroundImage != null) {
            Composite originalComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, this.backgroundImageAlpha));
            Rectangle2D.Double dest = new Rectangle2D.Double(0.0, 0.0, this.backgroundImage.getWidth(null), this.backgroundImage.getHeight(null));
            Align.align(dest, chartArea, this.backgroundImageAlignment);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Drawing background image into " + ((Object)dest).toString());
            }
            g2.drawImage(this.backgroundImage, (int)((RectangularShape)dest).getX(), (int)((RectangularShape)dest).getY(), (int)((RectangularShape)dest).getWidth(), (int)((RectangularShape)dest).getHeight(), null);
            g2.setComposite(originalComposite);
        }
        if (this.isBorderVisible()) {
            Paint paint = this.getBorderPaint();
            Stroke stroke = this.getBorderStroke();
            if (paint != null && stroke != null) {
                Rectangle2D.Double borderArea = new Rectangle2D.Double(chartArea.getX(), chartArea.getY(), chartArea.getWidth() - 1.0, chartArea.getHeight() - 1.0);
                g2.setPaint(paint);
                g2.setStroke(stroke);
                g2.draw(borderArea);
            }
        }
        Rectangle2D.Double nonTitleArea = new Rectangle2D.Double();
        ((Rectangle2D)nonTitleArea).setRect(chartArea);
        if (this.title != null) {
            this.drawTitle(this.title, g2, nonTitleArea);
        }
        Iterator iterator = this.subtitles.iterator();
        while (iterator.hasNext()) {
            Title currentTitle = (Title)iterator.next();
            this.drawTitle(currentTitle, g2, nonTitleArea);
        }
        Rectangle2D.Double plotArea = nonTitleArea;
        if (this.legend != null) {
            ((Rectangle2D)plotArea).setRect(this.legend.draw(g2, nonTitleArea, info));
        }
        PlotRenderingInfo plotInfo = null;
        if (info != null) {
            plotInfo = info.getPlotInfo();
        }
        this.plot.draw(g2, plotArea, anchor, null, plotInfo);
        g2.setClip(savedClip);
        this.notifyListeners(new ChartProgressEvent(this, this, 2, 100));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Leaving draw() method");
        }
    }

    public void drawTitle(Title title, Graphics2D g2, Rectangle2D area) {
        if (title == null) {
            throw new IllegalArgumentException("Null 'title' argument.");
        }
        if (area == null) {
            throw new IllegalArgumentException("Null 'area' argument.");
        }
        Rectangle2D.Double titleArea = new Rectangle2D.Double();
        double availableHeight = 0.0;
        double availableWidth = 0.0;
        RectangleEdge position = title.getPosition();
        if (position == RectangleEdge.TOP) {
            availableWidth = area.getWidth();
            availableHeight = Math.min((double)title.getPreferredHeight(g2, (float)availableWidth), area.getHeight());
            ((Rectangle2D)titleArea).setRect(area.getX(), area.getY(), availableWidth, availableHeight);
            title.draw(g2, titleArea);
            area.setRect(area.getX(), Math.min(area.getY() + availableHeight, area.getMaxY()), availableWidth, Math.max(area.getHeight() - availableHeight, 0.0));
        } else if (position == RectangleEdge.BOTTOM) {
            availableWidth = area.getWidth();
            availableHeight = Math.min((double)title.getPreferredHeight(g2, (float)availableWidth), area.getHeight());
            ((Rectangle2D)titleArea).setRect(area.getX(), area.getMaxY() - availableHeight, availableWidth, availableHeight);
            title.draw(g2, titleArea);
            area.setRect(area.getX(), area.getY(), availableWidth, area.getHeight() - availableHeight);
        } else if (position == RectangleEdge.RIGHT) {
            availableHeight = area.getHeight();
            availableWidth = Math.min((double)title.getPreferredWidth(g2, (float)availableHeight), area.getWidth());
            ((Rectangle2D)titleArea).setRect(area.getMaxX() - availableWidth, area.getY(), availableWidth, availableHeight);
            title.draw(g2, titleArea);
            area.setRect(area.getX(), area.getY(), area.getWidth() - availableWidth, availableHeight);
        } else if (position == RectangleEdge.LEFT) {
            availableHeight = area.getHeight();
            availableWidth = Math.min((double)title.getPreferredWidth(g2, (float)availableHeight), area.getWidth());
            ((Rectangle2D)titleArea).setRect(area.getX(), area.getY(), availableWidth, availableHeight);
            title.draw(g2, titleArea);
            area.setRect(area.getX() + availableWidth, area.getY(), area.getWidth() - availableWidth, availableHeight);
        } else {
            throw new RuntimeException("JFreeChart.drawTitle(...): unknown title position.");
        }
    }

    public BufferedImage createBufferedImage(int width, int height) {
        return this.createBufferedImage(width, height, null);
    }

    public BufferedImage createBufferedImage(int width, int height, ChartRenderingInfo info) {
        return this.createBufferedImage(width, height, 1, info);
    }

    public BufferedImage createBufferedImage(int width, int height, int imageType, ChartRenderingInfo info) {
        BufferedImage image = new BufferedImage(width, height, imageType);
        Graphics2D g2 = image.createGraphics();
        this.draw(g2, new Rectangle2D.Double(0.0, 0.0, width, height), null, info);
        g2.dispose();
        return image;
    }

    public BufferedImage createBufferedImage(int imageWidth, int imageHeight, double drawWidth, double drawHeight, ChartRenderingInfo info) {
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, 1);
        Graphics2D g2 = image.createGraphics();
        double scaleX = (double)imageWidth / drawWidth;
        double scaleY = (double)imageHeight / drawHeight;
        AffineTransform st = AffineTransform.getScaleInstance(scaleX, scaleY);
        g2.transform(st);
        this.draw(g2, new Rectangle2D.Double(0.0, 0.0, drawWidth, drawHeight), null, info);
        g2.dispose();
        return image;
    }

    public void handleClick(int x, int y, ChartRenderingInfo info) {
        this.plot.handleClick(x, y, info.getPlotInfo());
    }

    public void addChangeListener(ChartChangeListener listener) {
        this.changeListeners.add(class$org$jfree$chart$event$ChartChangeListener == null ? (class$org$jfree$chart$event$ChartChangeListener = JFreeChart.class$("org.jfree.chart.event.ChartChangeListener")) : class$org$jfree$chart$event$ChartChangeListener, listener);
    }

    public void removeChangeListener(ChartChangeListener listener) {
        this.changeListeners.remove(class$org$jfree$chart$event$ChartChangeListener == null ? (class$org$jfree$chart$event$ChartChangeListener = JFreeChart.class$("org.jfree.chart.event.ChartChangeListener")) : class$org$jfree$chart$event$ChartChangeListener, listener);
    }

    public void fireChartChanged() {
        ChartChangeEvent event = new ChartChangeEvent(this);
        this.notifyListeners(event);
    }

    protected void notifyListeners(ChartChangeEvent event) {
        if (this.notify) {
            Object[] listeners = this.changeListeners.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$org$jfree$chart$event$ChartChangeListener == null ? JFreeChart.class$("org.jfree.chart.event.ChartChangeListener") : class$org$jfree$chart$event$ChartChangeListener)) continue;
                ((ChartChangeListener)listeners[i + 1]).chartChanged(event);
            }
        }
    }

    public void addProgressListener(ChartProgressListener listener) {
        this.progressListeners.add(class$org$jfree$chart$event$ChartProgressListener == null ? (class$org$jfree$chart$event$ChartProgressListener = JFreeChart.class$("org.jfree.chart.event.ChartProgressListener")) : class$org$jfree$chart$event$ChartProgressListener, listener);
    }

    public void removeProgressListener(ChartProgressListener listener) {
        this.progressListeners.remove(class$org$jfree$chart$event$ChartProgressListener == null ? (class$org$jfree$chart$event$ChartProgressListener = JFreeChart.class$("org.jfree.chart.event.ChartProgressListener")) : class$org$jfree$chart$event$ChartProgressListener, listener);
    }

    protected void notifyListeners(ChartProgressEvent event) {
        Object[] listeners = this.progressListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$jfree$chart$event$ChartProgressListener == null ? JFreeChart.class$("org.jfree.chart.event.ChartProgressListener") : class$org$jfree$chart$event$ChartProgressListener)) continue;
            ((ChartProgressListener)listeners[i + 1]).chartProgress(event);
        }
    }

    public void titleChanged(TitleChangeEvent event) {
        event.setChart(this);
        this.notifyListeners(event);
    }

    public void legendChanged(LegendChangeEvent event) {
        event.setChart(this);
        this.notifyListeners(event);
    }

    public void plotChanged(PlotChangeEvent event) {
        event.setChart(this);
        this.notifyListeners(event);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof JFreeChart) {
            JFreeChart c = (JFreeChart)obj;
            boolean b0 = ObjectUtils.equal(this.title, c.title);
            boolean b1 = ObjectUtils.equal(this.subtitles, c.subtitles);
            boolean b2 = ObjectUtils.equal(this.legend, c.legend);
            boolean b3 = ObjectUtils.equal(this.plot, c.plot);
            boolean b5 = ObjectUtils.equal(this.backgroundPaint, c.backgroundPaint);
            boolean b6 = ObjectUtils.equal(this.backgroundImage, c.backgroundImage);
            boolean b7 = this.backgroundImageAlignment == c.backgroundImageAlignment;
            boolean b8 = this.backgroundImageAlpha == c.backgroundImageAlpha;
            boolean b9 = this.notify == c.notify;
            return b0 && b1 && b2 && b3 && b5 && b6 && b7 && b8 && b9;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writeStroke(this.borderStroke, stream);
        SerialUtilities.writePaint(this.borderPaint, stream);
        SerialUtilities.writePaint(this.backgroundPaint, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.borderStroke = SerialUtilities.readStroke(stream);
        this.borderPaint = SerialUtilities.readPaint(stream);
        this.backgroundPaint = SerialUtilities.readPaint(stream);
        this.progressListeners = new EventListenerList();
        this.changeListeners = new EventListenerList();
        this.renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.title != null) {
            this.title.addChangeListener(this);
        }
        for (int i = 0; i < this.getSubtitleCount(); ++i) {
            this.getSubtitle(i).addChangeListener(this);
        }
        if (this.legend != null) {
            this.legend.addChangeListener(this);
        }
        this.plot.addChangeListener(this);
    }

    public static void main(String[] args) {
        System.out.println(INFO.toString());
    }

    public boolean getSuppressChartChangeEvents() {
        return this.isNotify();
    }

    public void setSuppressChartChangeEvents(boolean flag) {
        this.setNotify(!flag);
    }

    public Object clone() throws CloneNotSupportedException {
        JFreeChart chart = (JFreeChart)super.clone();
        chart.renderingHints = (RenderingHints)this.renderingHints.clone();
        if (this.title != null) {
            chart.title = (TextTitle)this.title.clone();
            chart.title.addChangeListener(chart);
        }
        chart.subtitles = new ArrayList();
        for (int i = 0; i < this.getSubtitleCount(); ++i) {
            Title subtitle = (Title)this.getSubtitle(i).clone();
            chart.subtitles.add(subtitle);
            subtitle.addChangeListener(chart);
        }
        if (this.legend != null) {
            chart.legend = (Legend)this.legend.clone();
            chart.legend.registerChart(chart);
            chart.legend.addChangeListener(chart);
        }
        if (this.plot != null) {
            chart.plot = (Plot)this.plot.clone();
            chart.plot.addChangeListener(chart);
        }
        chart.progressListeners = new EventListenerList();
        chart.changeListeners = new EventListenerList();
        return chart;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

