/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Vector;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Record;
import org.hsqldb.Server;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.store.ValuePool;

public class DatabaseManager {
    private static int dbIDCounter;
    static final HashMap memDatabaseMap;
    static final HashMap fileDatabaseMap;
    static final HashMap resDatabaseMap;
    static final IntKeyHashMap databaseIDMap;
    static HashMap serverMap;
    static final String S_DOT = ".";
    public static final String S_MEM = "mem:";
    public static final String S_FILE = "file:";
    public static final String S_RES = "res:";
    public static final String S_ALIAS = "alias:";
    public static final String S_HSQL = "hsql://";
    public static final String S_HSQLS = "hsqls://";
    public static final String S_HTTP = "http://";
    public static final String S_HTTPS = "https://";
    public static final String S_URL_PREFIX = "jdbc:hsqldb:";
    private static final HsqlTimer timer;

    public static Vector getDatabaseURIs() {
        Vector<String> vector = new Vector<String>();
        Iterator iterator = databaseIDMap.values().iterator();
        while (iterator.hasNext()) {
            Database database = (Database)iterator.next();
            vector.addElement(database.getURI());
        }
        return vector;
    }

    public static void closeDatabases(int n) {
        Iterator iterator = databaseIDMap.values().iterator();
        while (iterator.hasNext()) {
            Database database = (Database)iterator.next();
            try {
                database.close(n);
            }
            catch (HsqlException hsqlException) {}
        }
    }

    static Session newSession(int n, String string, String string2) throws HsqlException {
        Database database = (Database)databaseIDMap.get(n);
        return database.connect(string, string2);
    }

    public static Session newSession(String string, String string2, String string3, String string4, HsqlProperties hsqlProperties) throws HsqlException {
        Database database = DatabaseManager.getDatabase(string, string2, hsqlProperties);
        return database.connect(string3, string4);
    }

    static Session getSession(String string, String string2, int n) throws HsqlException {
        if (string2 == null) {
            return null;
        }
        Database database = DatabaseManager.lookupDatabaseObject(string, string2);
        return database.sessionManager.getSession(n);
    }

    static int getDatabase(String string, String string2, Server server, HsqlProperties hsqlProperties) throws HsqlException {
        Database database = DatabaseManager.getDatabase(string, string2, hsqlProperties);
        DatabaseManager.registerServer(server, database);
        return database.databaseID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Database getDatabase(String string, String string2, HsqlProperties hsqlProperties) throws HsqlException {
        Database database;
        Database database2 = database = DatabaseManager.getDatabaseObject(string, string2, hsqlProperties);
        synchronized (database2) {
            switch (database.getState()) {
                case 1: {
                    break;
                }
                case 16: {
                    if (DatabaseManager.lookupDatabaseObject(string, string2) == null) {
                        DatabaseManager.addDatabaseObject(string, string2, database);
                    }
                    database.open();
                    break;
                }
                case 4: 
                case 8: {
                    throw Trace.error(1, 107);
                }
            }
        }
        return database;
    }

    private static synchronized Database getDatabaseObject(String string, String string2, HsqlProperties hsqlProperties) throws HsqlException {
        HashMap hashMap;
        Object object = string2;
        if (string == S_FILE) {
            hashMap = fileDatabaseMap;
            object = DatabaseManager.filePathToKey(string2);
        } else {
            hashMap = string == S_RES ? resDatabaseMap : memDatabaseMap;
        }
        Database database = (Database)hashMap.get(object);
        if (database == null) {
            database = new Database(string, string2, string + object, hsqlProperties);
            database.databaseID = dbIDCounter;
            databaseIDMap.put(dbIDCounter, database);
            ++dbIDCounter;
            hashMap.put(object, database);
        }
        return database;
    }

    private static synchronized Database lookupDatabaseObject(String string, String string2) throws HsqlException {
        HashMap hashMap;
        Object object = string2;
        if (string == S_FILE) {
            hashMap = fileDatabaseMap;
            object = DatabaseManager.filePathToKey(string2);
        } else {
            hashMap = string == S_RES ? resDatabaseMap : memDatabaseMap;
        }
        return (Database)hashMap.get(object);
    }

    private static synchronized void addDatabaseObject(String string, String string2, Database database) throws HsqlException {
        HashMap hashMap;
        Object object = string2;
        if (string == S_FILE) {
            hashMap = fileDatabaseMap;
            object = DatabaseManager.filePathToKey(string2);
        } else {
            hashMap = string == S_RES ? resDatabaseMap : memDatabaseMap;
        }
        databaseIDMap.put(database.databaseID, database);
        hashMap.put(object, database);
    }

    static void removeDatabase(Database database) {
        HashMap hashMap;
        Object object;
        int n;
        block7: {
            n = database.databaseID;
            String string = database.getType();
            String string2 = database.getPath();
            object = string2;
            DatabaseManager.notifyServers(database);
            if (string == S_FILE) {
                hashMap = fileDatabaseMap;
                try {
                    object = DatabaseManager.filePathToKey(string2);
                }
                catch (HsqlException hsqlException) {
                    Iterator iterator = hashMap.keySet().iterator();
                    Object object2 = null;
                    while (iterator.hasNext()) {
                        Object object3 = iterator.next();
                        if (hashMap.get(object3) != database) continue;
                        object2 = object3;
                        break;
                    }
                    if (object2 == null) {
                        hsqlException.printStackTrace();
                        break block7;
                    }
                    object = object2;
                }
            } else {
                hashMap = string == S_RES ? resDatabaseMap : memDatabaseMap;
            }
        }
        databaseIDMap.remove(n);
        hashMap.remove(object);
        if (databaseIDMap.isEmpty()) {
            ValuePool.resetPool();
        }
    }

    static void deRegisterServer(Server server) {
        serverMap.remove(server);
    }

    private static void deRegisterServer(Server server, Database database) {
        Iterator iterator = serverMap.values().iterator();
        while (iterator.hasNext()) {
            HashSet hashSet = (HashSet)iterator.next();
            hashSet.remove(database);
            if (!hashSet.isEmpty()) continue;
            iterator.remove();
        }
    }

    private static void registerServer(Server server, Database database) {
        if (!serverMap.containsKey(server)) {
            serverMap.put(server, new HashSet());
        }
        HashSet hashSet = (HashSet)serverMap.get(server);
        hashSet.add(database);
    }

    private static void notifyServers(Database database) {
        Iterator iterator = serverMap.keySet().iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            HashSet hashSet = (HashSet)serverMap.get(server);
            if (!hashSet.contains(database)) continue;
            server.notify(0, database.databaseID);
        }
    }

    static boolean isServerDB(Database database) {
        Iterator iterator = serverMap.keySet().iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            HashSet hashSet = (HashSet)serverMap.get(server);
            if (!hashSet.contains(database)) continue;
            return true;
        }
        return false;
    }

    public static HsqlProperties parseURL(String string, boolean bl) {
        String string2;
        String string3 = string.toLowerCase();
        HsqlProperties hsqlProperties = new HsqlProperties();
        if (bl && !string3.startsWith(S_URL_PREFIX)) {
            return hsqlProperties;
        }
        int n = bl ? S_URL_PREFIX.length() : 0;
        String string4 = null;
        int n2 = 0;
        boolean bl2 = false;
        hsqlProperties.setProperty("url", string);
        int n3 = string.indexOf(59, n);
        if (n3 < 0) {
            n3 = string.length();
        } else {
            String string5 = string3.substring(n3 + 1, string3.length());
            HsqlProperties hsqlProperties2 = HsqlProperties.delimitedArgPairsToProps(string5, "=", ";", null);
            hsqlProperties.addProperties(hsqlProperties2);
        }
        if (n3 == n + 1 && string3.startsWith(S_DOT, n)) {
            string4 = S_DOT;
        } else if (string3.startsWith(S_MEM, n)) {
            string4 = S_MEM;
        } else if (string3.startsWith(S_FILE, n)) {
            string4 = S_FILE;
        } else if (string3.startsWith(S_RES, n)) {
            string4 = S_RES;
        } else if (string3.startsWith(S_ALIAS, n)) {
            string4 = S_ALIAS;
        } else if (string3.startsWith(S_HSQL, n)) {
            string4 = S_HSQL;
            n2 = 9001;
            bl2 = true;
        } else if (string3.startsWith(S_HSQLS, n)) {
            string4 = S_HSQLS;
            n2 = 554;
            bl2 = true;
        } else if (string3.startsWith(S_HTTP, n)) {
            string4 = S_HTTP;
            n2 = 80;
            bl2 = true;
        } else if (string3.startsWith(S_HTTPS, n)) {
            string4 = S_HTTPS;
            n2 = 443;
            bl2 = true;
        }
        if (string4 == null) {
            string4 = S_FILE;
        } else if (string4 == S_DOT) {
            string4 = S_MEM;
        } else {
            n += string4.length();
        }
        hsqlProperties.setProperty("connection_type", string4);
        if (bl2) {
            String string6;
            int n4;
            int n5 = string.indexOf(47, n);
            if (n5 < n || n5 > n3) {
                n5 = n3;
            }
            if ((n4 = string.indexOf(58, n)) < n || n4 > n5) {
                n4 = n5;
            } else {
                try {
                    n2 = Integer.parseInt(string.substring(n4 + 1, n5));
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            String string7 = string3.substring(n, n4);
            int n6 = string.lastIndexOf(47, n3);
            if (n6 < n) {
                string6 = "/";
                string2 = "";
            } else if (n6 == n5) {
                string6 = "/";
                string2 = string3.substring(n6 + 1, n3);
            } else {
                string6 = string.substring(n5, n6);
                string2 = string3.substring(n6 + 1, n3);
            }
            hsqlProperties.setProperty("port", n2);
            hsqlProperties.setProperty("host", string7);
            hsqlProperties.setProperty("path", string6);
        } else {
            if (string4 == S_MEM || string4 == S_RES) {
                string2 = string3.substring(n, n3).toLowerCase();
                if (string4 == S_RES && string2.indexOf(47) != 0) {
                    string2 = '/' + string2;
                }
            } else {
                string2 = string.substring(n, n3);
            }
            if (string2.length() == 0) {
                return null;
            }
        }
        hsqlProperties.setProperty("database", string2);
        return hsqlProperties;
    }

    static void gc() {
        if (Record.gcFrequency > 0 && Record.memoryRecords > Record.gcFrequency) {
            Record.memoryRecords = 0;
            System.gc();
        }
    }

    public static HsqlTimer getTimer() {
        return timer;
    }

    private static Object filePathToKey(String string) throws HsqlException {
        try {
            return FileUtil.canonicalFile(string);
        }
        catch (Exception exception) {
            throw Trace.error(29, exception.toString());
        }
    }

    static {
        memDatabaseMap = new HashMap();
        fileDatabaseMap = new HashMap();
        resDatabaseMap = new HashMap();
        databaseIDMap = new IntKeyHashMap();
        serverMap = new HashMap();
        timer = new HsqlTimer();
    }
}

