/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.rmi;

import java.io.IOException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.transport.rmi.RMIServerInvokerInf;

public class RMIServerInvoker
extends ServerInvoker
implements RMIServerInvokerInf {
    private final RemoteStub stub;
    public static final int DEFAULT_REGISTRY_PORT = 3455;
    public static final String REGISTRY_PORT_KEY = "registryPort";

    public RMIServerInvoker(InvokerLocator locator) throws RemoteException {
        super(locator);
        try {
            if (locator.getPort() != -1) {
                Registry registry = null;
                registry = this.getRegistry(locator);
                this.stub = (RemoteStub)UnicastRemoteObject.exportObject((Remote)this, locator.getPort());
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Binding registry to remoting/RMIServerInvoker/" + locator.getPort()));
                }
                registry.rebind("remoting/RMIServerInvoker/" + locator.getPort(), this);
            } else {
                this.stub = UnicastRemoteObject.exportObject(this);
            }
        }
        catch (RemoteException th) {
            th.printStackTrace();
            throw th;
        }
    }

    public RMIServerInvoker(InvokerLocator locator, Map configuration) throws RemoteException {
        super(locator, configuration);
        try {
            if (locator.getPort() != -1) {
                Registry registry = null;
                registry = this.getRegistry(locator);
                this.stub = (RemoteStub)UnicastRemoteObject.exportObject((Remote)this, locator.getPort());
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Binding registry to remoting/RMIServerInvoker/" + locator.getPort()));
                }
                registry.rebind("remoting/RMIServerInvoker/" + locator.getPort(), this);
            } else {
                this.stub = UnicastRemoteObject.exportObject(this);
            }
        }
        catch (RemoteException th) {
            th.printStackTrace();
            throw th;
        }
    }

    private Registry getRegistry(InvokerLocator locator) throws RemoteException {
        String value;
        Registry registry = null;
        int port = 3455;
        Map params = locator.getParameters();
        if (params != null && (value = (String)params.get(REGISTRY_PORT_KEY)) != null) {
            try {
                port = Integer.parseInt(value);
                this.log.debug((Object)("Using port " + port + " for rmi registry."));
            }
            catch (NumberFormatException e) {
                this.log.error((Object)("Can not set the RMIServerInvoker RMI registry to port " + value + ".  This is not a valid port number."));
            }
        }
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Creating registry for " + port));
            }
            registry = LocateRegistry.createRegistry(port);
        }
        catch (ExportException exportEx) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Locating registry for " + port));
            }
            registry = LocateRegistry.getRegistry(port);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Got registry: " + registry));
        }
        return registry;
    }

    protected String getDefaultDataType() {
        return "serializable";
    }

    public void destroy() {
        super.destroy();
        try {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("unbinding remoting/RMIServerInvoker/" + this.locator.getPort() + " from registry running on port " + (this.locator.getPort() + 1)));
                }
                Registry registry = this.getRegistry(this.locator);
                registry.unbind("remoting/RMIServerInvoker/" + this.locator.getPort());
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (NotBoundException e) {
                e.printStackTrace();
            }
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    public String getMBeanObjectName() {
        return "jboss.remoting:service=invoker,transport=rmi";
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    public boolean isTransportBiDirectional() {
        return true;
    }

    public final RemoteStub getStub() {
        return this.stub;
    }

    public Object transport(Object invocation) throws RemoteException, IOException {
        return this.invoke(invocation);
    }
}

