/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.loading;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.remoting.loading.ClassBytes;
import org.jboss.remoting.loading.ObjectInputStreamWithClassLoader;

public class ClassUtil {
    protected static final Logger log = Logger.getLogger((Class)ClassUtil.class);

    public static Object deserialize(ClassBytes cb, ClassLoader cl) throws IOException, ClassNotFoundException {
        if (cb.getClassBytes() == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(cb.getClassBytes());
        ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader(bis, cl);
        Object result = ois.readObject();
        bis = null;
        ois = null;
        return result;
    }

    public static Object deserialize(byte[] buf) throws IOException, ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassUtil.class.getClassLoader();
        }
        return ClassUtil.deserialize(buf, cl);
    }

    public static Object deserialize(byte[] buf, ClassLoader cl) throws IOException, ClassNotFoundException {
        if (buf == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader(bis, cl);
        Object result = ois.readObject();
        bis = null;
        ois = null;
        return result;
    }

    public static byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(obj);
        oos.flush();
        bos.flush();
        byte[] buf = bos.toByteArray();
        bos = null;
        oos = null;
        return buf;
    }

    public static boolean isArrayClass(String className) {
        return className.startsWith("[L") && className.endsWith(";");
    }

    public static String getArrayClassPart(String className) {
        String cn = className;
        int i = className.indexOf("[L");
        if (i > -1) {
            cn = className.substring(i + 2, className.length() - 1);
        }
        return cn;
    }

    public static String getPackageName(Class cl) {
        String n = cl.getName();
        int i = n.lastIndexOf(".");
        return i > -1 ? n.substring(0, i) : n;
    }

    public static String getShortClassName(Class cl) {
        String n = cl.getName();
        int i = n.lastIndexOf(".");
        return i > -1 ? n.substring(i + 1) : n;
    }

    public static Class[] getInterfacesFor(Class clazz) {
        HashSet set = new HashSet();
        ClassUtil.addInterfaces(set, clazz);
        return set.toArray(new Class[set.size()]);
    }

    private static void addInterfaces(Set list, Class clazz) {
        if (clazz != null && clazz != Object.class) {
            Class<?>[] interfaces;
            if (clazz.isInterface() && !list.contains(clazz)) {
                list.add(clazz);
            }
            if ((interfaces = clazz.getInterfaces()) != null && interfaces.length > 0) {
                for (int c = 0; c < interfaces.length; ++c) {
                    Class<?> interfaceClass = interfaces[c];
                    if (!list.contains(interfaceClass)) {
                        list.add(interfaceClass);
                    }
                    ClassUtil.addInterfaces(list, interfaceClass);
                }
            }
            ClassUtil.addInterfaces(list, clazz.getSuperclass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getClassBytes(String className, ClassLoader classbyteloader) {
        String cn = null;
        cn = ClassUtil.isArrayClass(className) ? ClassUtil.getArrayClassPart(className).replace('.', '/') + ".class" : className.replace('.', '/') + ".class";
        if (log.isDebugEnabled()) {
            log.debug((Object)("trying to load class: " + className + " from path: " + cn));
        }
        InputStream in = null;
        ClassLoader cl = classbyteloader;
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl != null && (in = cl.getResourceAsStream(cn)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("looking for classes at: " + cl));
            }
            try {
                byte[] data = ClassUtil.read(in);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("found class at classloader: " + cl));
                }
                byte[] byArray = data;
                return byArray;
            }
            catch (IOException io) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception ig) {}
                    in = null;
                }
            }
        }
        return null;
    }

    protected static byte[] read(InputStream in) throws IOException {
        int c;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((c = in.read(buf)) >= 0) {
            out.write(buf, 0, c);
        }
        return out.toByteArray();
    }
}

