/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.Invoker;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.loading.ClassByteClassLoader;
import org.jboss.remoting.marshal.MarshallLoaderFactory;

public abstract class AbstractInvoker
implements Invoker {
    protected final Logger log = Logger.getLogger(this.getClass());
    protected ClassByteClassLoader classbyteloader = new ClassByteClassLoader(this.getClass().getClassLoader());
    protected InvokerLocator locator;
    protected InvokerLocator localServerLocator;

    public AbstractInvoker(InvokerLocator locator) {
        this.locator = locator;
        this.localServerLocator = InvokerRegistry.getSuitableServerLocatorForRemote(locator);
        try {
            InvokerLocator loaderLocator = MarshallLoaderFactory.convertLocator(locator);
            if (loaderLocator != null) {
                this.classbyteloader.setClientInvoker(new Client(loaderLocator));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Could not create remote class loading for invoker.", (Throwable)e);
        }
    }

    public InvokerLocator getLocator() {
        return this.locator;
    }

    public void setClientLocator(InvokerLocator locator) {
        this.localServerLocator = locator;
    }

    public InvokerLocator getClientLocator() {
        return this.localServerLocator;
    }

    public synchronized void setClassLoader(ClassLoader classloader) {
        this.classbyteloader = new ClassByteClassLoader(classloader);
    }

    public synchronized ClassLoader getClassLoader() {
        return this.classbyteloader;
    }
}

