/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.metadata.jaxrpcmapping;

import java.io.InputStream;
import java.net.URL;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.webservice.metadata.jaxrpcmapping.ExceptionMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.MethodParamPartsMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.PackageMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.PortMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceEndpointMethodMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceInterfaceMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.VariableMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.WsdlMessageMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.WsdlReturnValueMapping;
import org.jboss.xml.binding.ContentNavigator;
import org.jboss.xml.binding.ObjectModelFactory;
import org.jboss.xml.binding.Unmarshaller;
import org.xml.sax.Attributes;

public class JavaWsdlMappingFactory
implements ObjectModelFactory {
    private static final Logger log = Logger.getLogger((Class)JavaWsdlMappingFactory.class);

    private JavaWsdlMappingFactory() {
    }

    public static JavaWsdlMappingFactory newInstance() {
        return new JavaWsdlMappingFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaWsdlMapping parse(URL jaxrpcMappingFile) throws Exception {
        if (jaxrpcMappingFile == null) {
            throw new IllegalArgumentException("URL cannot be null");
        }
        Unmarshaller unmarshaller = new Unmarshaller();
        InputStream is = jaxrpcMappingFile.openStream();
        try {
            JavaWsdlMapping javaWsdlMapping;
            JavaWsdlMapping javaWsdlMapping2 = javaWsdlMapping = (JavaWsdlMapping)unmarshaller.unmarshal(is, (ObjectModelFactory)this, null);
            return javaWsdlMapping2;
        }
        finally {
            is.close();
        }
    }

    public Object newRoot(Object root, ContentNavigator navigator, String namespaceURI, String localName, Attributes attrs) {
        return new JavaWsdlMapping();
    }

    public Object newChild(JavaWsdlMapping javaWsdlMapping, ContentNavigator navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("package-mapping".equals(localName)) {
            return new PackageMapping(javaWsdlMapping);
        }
        if ("java-xml-type-mapping".equals(localName)) {
            return new JavaXmlTypeMapping(javaWsdlMapping);
        }
        if ("exception-mapping".equals(localName)) {
            return new ExceptionMapping(javaWsdlMapping);
        }
        if ("service-interface-mapping".equals(localName)) {
            return new ServiceInterfaceMapping(javaWsdlMapping);
        }
        if ("service-endpoint-interface-mapping".equals(localName)) {
            return new ServiceEndpointInterfaceMapping(javaWsdlMapping);
        }
        return null;
    }

    public void addChild(JavaWsdlMapping javaWsdlMapping, PackageMapping packageMapping, ContentNavigator navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + javaWsdlMapping + ",child=" + packageMapping + "]"));
        javaWsdlMapping.addPackageMapping(packageMapping);
    }

    public void addChild(JavaWsdlMapping javaWsdlMapping, JavaXmlTypeMapping typeMapping, ContentNavigator navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + javaWsdlMapping + ",child=" + typeMapping + "]"));
        javaWsdlMapping.addJavaXmlTypeMappings(typeMapping);
    }

    public void addChild(JavaWsdlMapping javaWsdlMapping, ExceptionMapping exceptionMapping, ContentNavigator navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + javaWsdlMapping + ",child=" + exceptionMapping + "]"));
        javaWsdlMapping.addExceptionMappings(exceptionMapping);
    }

    public void addChild(JavaWsdlMapping javaWsdlMapping, ServiceInterfaceMapping siMapping, ContentNavigator navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + javaWsdlMapping + ",child=" + siMapping + "]"));
        javaWsdlMapping.addServiceInterfaceMappings(siMapping);
    }

    public void addChild(JavaWsdlMapping javaWsdlMapping, ServiceEndpointInterfaceMapping seiMapping, ContentNavigator navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + javaWsdlMapping + ",child=" + seiMapping + "]"));
        javaWsdlMapping.addServiceEndpointInterfaceMappings(seiMapping);
    }

    public void setValue(PackageMapping packageMapping, ContentNavigator navigator, String namespaceURI, String localName, String value) {
        log.trace((Object)("setValue: [obj=" + packageMapping + ",value=" + value + "]"));
        if ("package-type".equals(localName)) {
            packageMapping.setPackageType(value);
        } else if ("namespaceURI".equals(localName)) {
            packageMapping.setNamespaceURI(value);
        }
    }

    public Object newChild(JavaXmlTypeMapping typeMapping, ContentNavigator navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("variable-mapping".equals(localName)) {
            return new VariableMapping(typeMapping);
        }
        return null;
    }

    public void addChild(JavaXmlTypeMapping typeMapping, VariableMapping variableMapping, ContentNavigator navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + typeMapping + ",child=" + variableMapping + "]"));
        typeMapping.addVariableMapping(variableMapping);
    }

    public void setValue(JavaXmlTypeMapping typeMapping, ContentNavigator navigator, String namespaceURI, String localName, String value) {
        log.trace((Object)("setValue: [obj=" + typeMapping + ",value=" + value + "]"));
        if ("java-type".equals(localName)) {
            typeMapping.setJavaType(value);
        } else if ("root-type-qname".equals(localName)) {
            typeMapping.setRootTypeQName(navigator.resolveQName(value));
        } else if ("anonymous-type-qname".equals(localName)) {
            int index = value.lastIndexOf(58);
            if (index < 0) {
                throw new IllegalArgumentException("Invalid anonymous qname: " + value);
            }
            String nsURI = value.substring(0, index);
            String localPart = value.substring(index + 1);
            typeMapping.setAnonymousTypeQName(new QName(nsURI, localPart));
        } else if ("qname-scope".equals(localName)) {
            typeMapping.setQnameScope(value);
        }
    }

    public void setValue(ExceptionMapping exceptionMapping, ContentNavigator navigator, String namespaceURI, String localName, String value) {
        log.trace((Object)("setValue: [obj=" + exceptionMapping + ",value=" + value + "]"));
        if ("exception-type".equals(localName)) {
            exceptionMapping.setExceptionType(value);
        } else if ("wsdl-message".equals(localName)) {
            exceptionMapping.setWsdlMessage(navigator.resolveQName(value));
        } else if ("constructor-parameter-order".equals(localName)) {
            exceptionMapping.addConstructorParameter(value);
        }
    }

    public Object newChild(ServiceInterfaceMapping siMapping, ContentNavigator navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("port-mapping".equals(localName)) {
            return new PortMapping(siMapping);
        }
        return null;
    }

    public void addChild(ServiceInterfaceMapping siMapping, PortMapping portMapping, ContentNavigator navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + siMapping + ",child=" + portMapping + "]"));
        siMapping.addPortMapping(portMapping);
    }

    public void setValue(ServiceInterfaceMapping siMapping, ContentNavigator navigator, String namespaceURI, String localName, String value) {
        log.trace((Object)("setValue: [obj=" + siMapping + ",value=" + value + "]"));
        if ("service-interface".equals(localName)) {
            siMapping.setServiceInterface(value);
        } else if ("wsdl-service-name".equals(localName)) {
            siMapping.setWsdlServiceName(navigator.resolveQName(value));
        }
    }

    public Object newChild(ServiceEndpointInterfaceMapping seiMapping, ContentNavigator navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("service-endpoint-method-mapping".equals(localName)) {
            return new ServiceEndpointMethodMapping(seiMapping);
        }
        return null;
    }

    public void addChild(ServiceEndpointInterfaceMapping seiMapping, ServiceEndpointMethodMapping seiMethodMapping, ContentNavigator navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + seiMapping + ",child=" + seiMapping + "]"));
        seiMapping.addServiceEndpointMethodMapping(seiMethodMapping);
    }

    public void setValue(ServiceEndpointInterfaceMapping seiMapping, ContentNavigator navigator, String namespaceURI, String localName, String value) {
        log.trace((Object)("setValue: [obj=" + seiMapping + ",value=" + value + "]"));
        if ("service-endpoint-interface".equals(localName)) {
            seiMapping.setServiceEndpointInterface(value);
        } else if ("wsdl-port-type".equals(localName)) {
            seiMapping.setWsdlPortType(navigator.resolveQName(value));
        } else if ("wsdl-binding".equals(localName)) {
            seiMapping.setWsdlBinding(navigator.resolveQName(value));
        }
    }

    public void setValue(VariableMapping variableMapping, ContentNavigator navigator, String namespaceURI, String localName, String value) {
        log.trace((Object)("setValue: [obj=" + variableMapping + ",value=" + value + "]"));
        if ("java-variable-name".equals(localName)) {
            variableMapping.setJavaVariableName(value);
        } else if ("data-member".equals(localName)) {
            variableMapping.setDataMember(true);
        } else if ("xml-attribute-name".equals(localName)) {
            variableMapping.setXmlAttributeName(value);
        } else if ("xml-element-name".equals(localName)) {
            variableMapping.setXmlElementName(value);
        } else if ("xml-wildcard".equals(localName)) {
            variableMapping.setXmlWildcard(value);
        }
    }

    public void setValue(PortMapping portMapping, ContentNavigator navigator, String namespaceURI, String localName, String value) {
        log.trace((Object)("setValue: [obj=" + portMapping + ",value=" + value + "]"));
        if ("port-name".equals(localName)) {
            portMapping.setPortName(value);
        } else if ("java-port-name".equals(localName)) {
            portMapping.setJavaPortName(value);
        }
    }

    public Object newChild(ServiceEndpointMethodMapping methodMapping, ContentNavigator navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("method-param-parts-mapping".equals(localName)) {
            return new MethodParamPartsMapping(methodMapping);
        }
        if ("wsdl-return-value-mapping".equals(localName)) {
            return new WsdlReturnValueMapping(methodMapping);
        }
        return null;
    }

    public void addChild(ServiceEndpointMethodMapping methodMapping, MethodParamPartsMapping partsMapping, ContentNavigator navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + methodMapping + ",child=" + partsMapping + "]"));
        methodMapping.addMethodParamPartsMapping(partsMapping);
    }

    public void addChild(ServiceEndpointMethodMapping methodMapping, WsdlReturnValueMapping returnValueMapping, ContentNavigator navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + methodMapping + ",child=" + returnValueMapping + "]"));
        methodMapping.setWsdlReturnValueMapping(returnValueMapping);
    }

    public void setValue(ServiceEndpointMethodMapping methodMapping, ContentNavigator navigator, String namespaceURI, String localName, String value) {
        log.trace((Object)("setValue: [obj=" + methodMapping + ",value=" + value + "]"));
        if ("java-method-name".equals(localName)) {
            methodMapping.setJavaMethodName(value);
        } else if ("wsdl-operation".equals(localName)) {
            methodMapping.setWsdlOperation(value);
        } else if ("wrapped-element".equals(localName)) {
            methodMapping.setWrappedElement(true);
        }
    }

    public Object newChild(MethodParamPartsMapping partsMapping, ContentNavigator navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("wsdl-message-mapping".equals(localName)) {
            return new WsdlMessageMapping(partsMapping);
        }
        return null;
    }

    public void addChild(MethodParamPartsMapping partsMapping, WsdlMessageMapping msgMapping, ContentNavigator navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + partsMapping + ",child=" + msgMapping + "]"));
        partsMapping.setWsdlMessageMapping(msgMapping);
    }

    public void setValue(MethodParamPartsMapping partsMapping, ContentNavigator navigator, String namespaceURI, String localName, String value) {
        log.trace((Object)("setValue: [obj=" + partsMapping + ",value=" + value + "]"));
        if ("param-position".equals(localName)) {
            partsMapping.setParamPosition(new Integer(value));
        } else if ("param-type".equals(localName)) {
            partsMapping.setParamType(value);
        }
    }

    public void setValue(WsdlReturnValueMapping retValueMapping, ContentNavigator navigator, String namespaceURI, String localName, String value) {
        log.trace((Object)("setValue: [obj=" + retValueMapping + ",value=" + value + "]"));
        if ("method-return-value".equals(localName)) {
            retValueMapping.setMethodReturnValue(value);
        } else if ("wsdl-message".equals(localName)) {
            retValueMapping.setWsdlMessage(navigator.resolveQName(value));
        } else if ("wsdl-message-part-name".equals(localName)) {
            retValueMapping.setWsdlMessagePartName(value);
        }
    }

    public void setValue(WsdlMessageMapping msgMapping, ContentNavigator navigator, String namespaceURI, String localName, String value) {
        log.trace((Object)("setValue: [obj=" + msgMapping + ",value=" + value + "]"));
        if ("wsdl-message".equals(localName)) {
            msgMapping.setWsdlMessage(navigator.resolveQName(value));
        } else if ("wsdl-message-part-name".equals(localName)) {
            msgMapping.setWsdlMessagePartName(value);
        } else if ("parameter-mode".equals(localName)) {
            msgMapping.setParameterMode(value);
        } else if ("soap-header".equals(localName)) {
            msgMapping.setSoapHeader(true);
        }
    }
}

