/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.metadata.jaxrpcmapping;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.webservice.metadata.jaxrpcmapping.ExceptionMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.PackageMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceInterfaceMapping;

public class JavaWsdlMapping {
    private final Logger log = Logger.getLogger((Class)JavaWsdlMapping.class);
    private ArrayList packageMappings = new ArrayList();
    private ArrayList javaXmlTypeMappings = new ArrayList();
    private ArrayList exceptionMappings = new ArrayList();
    private ArrayList serviceInterfaceMappings = new ArrayList();
    private ArrayList serviceEndpointInterfaceMappings = new ArrayList();

    public PackageMapping[] getPackageMappings() {
        PackageMapping[] arr = new PackageMapping[this.packageMappings.size()];
        this.packageMappings.toArray(arr);
        return arr;
    }

    public JavaXmlTypeMapping[] getJavaXmlTypeMappings() {
        JavaXmlTypeMapping[] arr = new JavaXmlTypeMapping[this.javaXmlTypeMappings.size()];
        this.javaXmlTypeMappings.toArray(arr);
        return arr;
    }

    public ExceptionMapping[] getExceptionMappings() {
        ExceptionMapping[] arr = new ExceptionMapping[this.exceptionMappings.size()];
        this.exceptionMappings.toArray(arr);
        return arr;
    }

    public ServiceInterfaceMapping[] getServiceInterfaceMappings() {
        ServiceInterfaceMapping[] arr = new ServiceInterfaceMapping[this.serviceInterfaceMappings.size()];
        this.serviceInterfaceMappings.toArray(arr);
        return arr;
    }

    public ServiceEndpointInterfaceMapping[] getServiceEndpointInterfaceMappings() {
        ServiceEndpointInterfaceMapping[] arr = new ServiceEndpointInterfaceMapping[this.serviceEndpointInterfaceMappings.size()];
        this.serviceEndpointInterfaceMappings.toArray(arr);
        return arr;
    }

    public String getPackageTypeForURI(String uri) {
        String packageStr = null;
        for (int i = 0; packageStr == null && i < this.packageMappings.size(); ++i) {
            PackageMapping mapping = (PackageMapping)this.packageMappings.get(i);
            if (!mapping.getNamespaceURI().equals(uri)) continue;
            packageStr = mapping.getPackageType();
        }
        return packageStr;
    }

    public JavaXmlTypeMapping getTypeMappingForQName(QName typeQName) {
        JavaXmlTypeMapping typeMapping = null;
        if (typeQName != null) {
            JavaXmlTypeMapping mapping;
            Iterator it = this.javaXmlTypeMappings.iterator();
            while (typeMapping == null && it.hasNext()) {
                mapping = (JavaXmlTypeMapping)it.next();
                if (!typeQName.equals(mapping.getRootTypeQName())) continue;
                typeMapping = mapping;
            }
            it = this.javaXmlTypeMappings.iterator();
            while (typeMapping == null && it.hasNext()) {
                mapping = (JavaXmlTypeMapping)it.next();
                QName anonymousQName = mapping.getAnonymousTypeQName();
                if (anonymousQName == null || !typeQName.getNamespaceURI().equals(anonymousQName.getNamespaceURI())) continue;
                String localPart = typeQName.getLocalPart();
                if (anonymousQName.getLocalPart().equals(localPart)) {
                    typeMapping = mapping;
                }
                if (!anonymousQName.getLocalPart().equals(">" + localPart)) continue;
                typeMapping = mapping;
            }
            if (typeMapping == null) {
                this.log.warn((Object)("Cannot find jaxrpc-mapping for type: " + typeQName));
            }
        }
        return typeMapping;
    }

    public ExceptionMapping getExceptionMappingForMessageQName(QName wsdlMessage) {
        ExceptionMapping exMapping = null;
        if (wsdlMessage != null) {
            Iterator it = this.exceptionMappings.iterator();
            while (it.hasNext()) {
                ExceptionMapping mapping = (ExceptionMapping)it.next();
                if (!wsdlMessage.equals(mapping.getWsdlMessage())) continue;
                exMapping = mapping;
            }
        }
        return exMapping;
    }

    public QName getPortTypeQNameForServiceEndpointInterface(String seiName) {
        QName portTypeQName = null;
        ServiceEndpointInterfaceMapping[] seiMappings = this.getServiceEndpointInterfaceMappings();
        for (int i = 0; i < seiMappings.length; ++i) {
            ServiceEndpointInterfaceMapping seiMapping = seiMappings[i];
            if (!seiMapping.getServiceEndpointInterface().equals(seiName)) continue;
            portTypeQName = seiMapping.getWsdlPortType();
        }
        return portTypeQName;
    }

    public ServiceEndpointInterfaceMapping getServiceEndpointInterfaceMappingByPortType(QName portType) {
        ServiceEndpointInterfaceMapping seiMapping = null;
        ServiceEndpointInterfaceMapping[] seiMappings = this.getServiceEndpointInterfaceMappings();
        for (int i = 0; seiMapping == null && i < seiMappings.length; ++i) {
            ServiceEndpointInterfaceMapping aux = seiMappings[i];
            if (!aux.getWsdlPortType().equals(portType)) continue;
            seiMapping = aux;
        }
        return seiMapping;
    }

    public void addPackageMapping(PackageMapping packageMapping) {
        this.packageMappings.add(packageMapping);
    }

    public void addJavaXmlTypeMappings(JavaXmlTypeMapping typeMapping) {
        this.javaXmlTypeMappings.add(typeMapping);
    }

    public void addExceptionMappings(ExceptionMapping exceptionMapping) {
        this.exceptionMappings.add(exceptionMapping);
    }

    public void addServiceInterfaceMappings(ServiceInterfaceMapping serviceInterfaceMapping) {
        this.serviceInterfaceMappings.add(serviceInterfaceMapping);
    }

    public void addServiceEndpointInterfaceMappings(ServiceEndpointInterfaceMapping serviceEndpointInterfaceMapping) {
        this.serviceEndpointInterfaceMappings.add(serviceEndpointInterfaceMapping);
    }
}

