/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.ServiceException;
import org.jboss.axis.encoding.DefaultTypeMappingImpl;
import org.jboss.axis.encoding.TypeMapping;
import org.jboss.axis.enums.Enum;
import org.jboss.axis.enums.Style;
import org.jboss.axis.enums.Use;
import org.jboss.logging.Logger;
import org.jboss.webservice.WSDLDefinitionFactory;
import org.jboss.webservice.deployment.BeanXMLMetaData;
import org.jboss.webservice.deployment.OperationDescription;
import org.jboss.webservice.deployment.TypeMappingDescription;
import org.jboss.webservice.metadata.jaxrpcmapping.ExceptionMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMappingFactory;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.MethodParamPartsMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceEndpointMethodMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.WsdlMessageMapping;
import org.jboss.webservice.util.DOMUtils;
import org.jboss.xml.binding.NamespaceRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServiceDescription {
    private final Logger log = Logger.getLogger((Class)ServiceDescription.class);
    private Definition wsdlDefinition;
    private Service wsdlService;
    private Binding wsdlBinding;
    private JavaWsdlMapping javaWsdlMapping;
    private Style style;
    private Use use;
    private HashMap operations = new HashMap();
    private HashMap typeMappings = new HashMap();
    private NamespaceRegistry nsRegistry = new NamespaceRegistry();
    private HashSet userTypes = new HashSet();
    private Properties callProperties;

    public ServiceDescription(Definition wsdlDefinition, JavaWsdlMapping javaMapping, URL ws4eeMetaData, String portName) throws ServiceException {
        this.wsdlDefinition = wsdlDefinition;
        this.wsdlService = this.getWsdlService(wsdlDefinition, portName);
        this.wsdlBinding = this.getWsdlBinding(this.wsdlService, portName);
        this.javaWsdlMapping = javaMapping;
        this.initServiceDescription();
        this.mergeDeploymentMetaData(ws4eeMetaData, portName);
    }

    public ServiceDescription(URL wsdlLocation, URL jaxrpcLocation, String portName) throws Exception {
        WSDLDefinitionFactory wsdlFactory = WSDLDefinitionFactory.newInstance();
        wsdlFactory.setFeature("javax.wsdl.verbose", true);
        this.wsdlDefinition = wsdlFactory.parse(wsdlLocation);
        this.wsdlService = this.getWsdlService(this.wsdlDefinition, portName);
        this.wsdlBinding = this.getWsdlBinding(this.wsdlService, portName);
        if (jaxrpcLocation != null) {
            JavaWsdlMappingFactory mappingFactory = JavaWsdlMappingFactory.newInstance();
            this.javaWsdlMapping = mappingFactory.parse(jaxrpcLocation);
        }
        this.initServiceDescription();
    }

    private void initServiceDescription() throws ServiceException {
        this.initServiceStyle();
        this.initServiceUse();
        this.initOperations();
        this.initTypeMappings();
    }

    public Definition getWsdlDefinition() {
        return this.wsdlDefinition;
    }

    public JavaWsdlMapping getJavaWsdlMapping() {
        return this.javaWsdlMapping;
    }

    public Service getWsdlService() {
        return this.wsdlService;
    }

    public Binding getWsdlBinding() {
        return this.wsdlBinding;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.nsRegistry;
    }

    public Style getStyle() {
        return this.style;
    }

    public Use getUse() {
        return this.use;
    }

    public String[] getOperationNames() {
        String[] names = new String[this.operations.size()];
        return this.operations.keySet().toArray(names);
    }

    public OperationDescription getOperation(String name) {
        return (OperationDescription)this.operations.get(name);
    }

    public Iterator getOperations() {
        return this.operations.values().iterator();
    }

    public QName[] getTypMappingNames() {
        QName[] names = new QName[this.typeMappings.size()];
        return this.typeMappings.keySet().toArray(names);
    }

    public Iterator getTypMappings() {
        return this.typeMappings.values().iterator();
    }

    public TypeMappingDescription getTypMapping(QName qname) {
        return (TypeMappingDescription)this.typeMappings.get(qname);
    }

    public void dumpWsdlDefinition(OutputStream out) throws WSDLException, IOException {
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
        wsdlWriter.writeWSDL(this.wsdlDefinition, out);
    }

    public Properties getCallProperties() {
        return this.callProperties;
    }

    public void setCallProperties(Properties callProperties) {
        this.callProperties = callProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeDeploymentMetaData(URL ws4eeMetaData, String portName) throws ServiceException {
        if (ws4eeMetaData == null) {
            this.log.debug((Object)"No ws4ee deployment meta data available");
            return;
        }
        this.log.debug((Object)("Merging with ws4ee deployment meta data: " + ws4eeMetaData));
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Element rootElement = null;
            InputStream is = ws4eeMetaData.openStream();
            try {
                rootElement = builder.parse(is).getDocumentElement();
            }
            finally {
                is.close();
            }
            Element portElement = null;
            NodeList nlistRoot = rootElement.getElementsByTagName("port");
            for (int i = 0; portElement == null && i < nlistRoot.getLength(); ++i) {
                Element el = (Element)nlistRoot.item(i);
                String name = el.getAttribute("name");
                if (!name.equals(portName)) continue;
                portElement = el;
            }
            if (portElement != null) {
                this.log.debug((Object)("Using port element: " + portName));
                Element importElement = DOMUtils.getFirstChildElement(portElement);
                if (importElement.getLocalName().equals("import")) {
                    String importFile = importElement.getFirstChild().getNodeValue();
                    this.log.debug((Object)("Using import: " + importFile));
                    String resource = ws4eeMetaData.toExternalForm();
                    resource = resource.substring(0, resource.lastIndexOf("/")) + "/" + importFile;
                    InputStream isImport = new URL(resource).openStream();
                    try {
                        portElement = builder.parse(isImport).getDocumentElement();
                    }
                    finally {
                        is.close();
                    }
                }
            }
            if (portElement == null) {
                portElement = rootElement;
            }
            this.mergeTypeMappings(portElement);
            this.mergeOperations(portElement);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private void mergeTypeMappings(Element portElement) {
        ArrayList<QName> mergedTypeMappings = new ArrayList<QName>();
        NodeList nlistPort = portElement.getElementsByTagName("typeMapping");
        for (int i = 0; i < nlistPort.getLength(); ++i) {
            TypeMappingDescription tm;
            Element el = (Element)nlistPort.item(i);
            QName qname = DOMUtils.getAttributeValueAsQName(el, "qname");
            String javaType = DOMUtils.getAttributeValue(el, "type");
            if (mergedTypeMappings.contains(qname)) {
                throw new IllegalArgumentException("Cannot add/replace the same type mapping twice: " + qname);
            }
            mergedTypeMappings.add(qname);
            if (javaType.startsWith("java:")) {
                javaType = javaType.substring(5);
            }
            if ((tm = (TypeMappingDescription)this.typeMappings.get(qname)) != null) {
                this.log.debug((Object)("Replacing typeMapping: " + qname));
            } else {
                this.log.debug((Object)("Addinging typeMapping: " + qname));
            }
            tm = new TypeMappingDescription(qname, null, javaType, this.use, null);
            tm.setEncodingURI(el.getAttribute("encodingStyle"));
            tm.setSerializerFactoryName(el.getAttribute("serializer"));
            tm.setDeserializerFactoryName(el.getAttribute("deserializer"));
            tm.setUserDefined(true);
            this.typeMappings.put(qname, tm);
            BeanXMLMetaData metaData = BeanXMLMetaData.parse(DOMUtils.getFirstChildElement(el));
            tm.setMetaData(metaData);
        }
    }

    private void mergeOperations(Element portElement) {
        ArrayList<String> mergedOperations = new ArrayList<String>();
        NodeList nlistOperation = portElement.getElementsByTagName("operation");
        for (int i = 0; i < nlistOperation.getLength(); ++i) {
            Element elOp = (Element)nlistOperation.item(i);
            String opName = elOp.getAttribute("name");
            QName opQName = DOMUtils.getAttributeValueAsQName(elOp, "qname");
            QName returnQName = DOMUtils.getAttributeValueAsQName(elOp, "returnQName");
            QName returnType = DOMUtils.getAttributeValueAsQName(elOp, "returnType");
            if (mergedOperations.contains(opName)) {
                throw new IllegalArgumentException("Cannot add/replace the same operation twice: " + opName);
            }
            mergedOperations.add(opName);
            OperationDescription op = (OperationDescription)this.operations.get(opName);
            if (op != null) {
                this.log.debug((Object)("Replacing operation: " + opName));
            } else {
                this.log.debug((Object)("Addinging operation: " + opName));
            }
            if (opQName == null) {
                opQName = new QName(opName);
            }
            op = new OperationDescription(opName, opQName);
            op.setReturnQName(returnQName);
            op.setReturnType(returnType);
            this.operations.put(opName, op);
            NodeList paramList = elOp.getElementsByTagName("parameter");
            for (int j = 0; j < paramList.getLength(); ++j) {
                Element elParam = (Element)paramList.item(j);
                String paramName = elParam.getAttribute("name");
                QName paramQName = DOMUtils.getAttributeValueAsQName(elParam, "qname");
                String mode = elParam.getAttribute("mode");
                QName type = DOMUtils.getAttributeValueAsQName(elParam, "type");
                boolean inHeader = DOMUtils.getAttributeValueAsBoolean(elParam, "inHeader");
                boolean outHeader = DOMUtils.getAttributeValueAsBoolean(elParam, "outHeader");
                if (paramQName == null) {
                    paramQName = new QName(paramName);
                }
                OperationDescription.Parameter param = new OperationDescription.Parameter(paramName, paramQName, mode, type);
                param.setInHeader(inHeader);
                param.setOutHeader(outHeader);
                op.addParameter(param);
            }
            NodeList faultList = elOp.getElementsByTagName("fault");
            for (int j = 0; j < faultList.getLength(); ++j) {
                Element elFault = (Element)faultList.item(j);
                String faultName = DOMUtils.getAttributeValue(elFault, "name");
                QName faultQName = DOMUtils.getAttributeValueAsQName(elFault, "qname");
                String javaType = DOMUtils.getAttributeValue(elFault, "class");
                QName faultType = DOMUtils.getAttributeValueAsQName(elFault, "type");
                OperationDescription.Fault fault = new OperationDescription.Fault(faultName, faultQName, javaType, faultType);
                op.addFault(fault);
            }
        }
    }

    private void initServiceStyle() {
        Iterator itBinding = this.wsdlBinding.getExtensibilityElements().iterator();
        while (itBinding.hasNext()) {
            ExtensibilityElement exElement = (ExtensibilityElement)itBinding.next();
            if (!(exElement instanceof SOAPBinding)) continue;
            SOAPBinding soapBinding = (SOAPBinding)exElement;
            Style bindingStyle = Style.getStyle((String)soapBinding.getStyle());
            if (this.style == null && bindingStyle != null) {
                this.style = bindingStyle;
            }
            if (this.style == null || bindingStyle == null || this.style.equals((Enum)bindingStyle)) continue;
            throw new IllegalArgumentException("Unsupported mix of style attributes " + this.style + "/" + bindingStyle);
        }
        if (this.style == null) {
            this.log.warn((Object)("Cannot find any style attribute for binding: " + this.wsdlBinding.getQName()));
            this.style = Style.RPC;
        }
    }

    private void initServiceUse() {
        Iterator itOp = this.wsdlBinding.getBindingOperations().iterator();
        while (itOp.hasNext()) {
            BindingOutput wsdlBindingOutput;
            BindingOperation wsdlBindingOperation = (BindingOperation)itOp.next();
            BindingInput wsdlBindingInput = wsdlBindingOperation.getBindingInput();
            if (wsdlBindingInput != null) {
                Iterator itIn = wsdlBindingInput.getExtensibilityElements().iterator();
                while (itIn.hasNext()) {
                    Object obj = itIn.next();
                    if (!(obj instanceof SOAPBody)) continue;
                    SOAPBody soapBody = (SOAPBody)obj;
                    Use soapBodyUse = Use.getUse((String)soapBody.getUse());
                    if (this.use == null) {
                        this.use = soapBodyUse != null ? soapBodyUse : Use.getUse((String)"literal");
                    }
                    if (this.use == null || soapBodyUse == null || this.use.equals((Enum)soapBodyUse)) continue;
                    throw new IllegalArgumentException("Unsupported mix of use attributes " + this.use + "/" + soapBodyUse);
                }
            }
            if ((wsdlBindingOutput = wsdlBindingOperation.getBindingOutput()) == null) continue;
            Iterator itOut = wsdlBindingOutput.getExtensibilityElements().iterator();
            while (itOut.hasNext()) {
                Object obj = itOut.next();
                if (!(obj instanceof SOAPBody)) continue;
                SOAPBody soapBody = (SOAPBody)obj;
                Use soapBodyUse = Use.getUse((String)soapBody.getUse());
                if (this.use == null) {
                    this.use = soapBodyUse != null ? soapBodyUse : Use.getUse((String)"literal");
                }
                if (this.use == null || soapBodyUse == null || this.use.equals((Enum)soapBodyUse)) continue;
                throw new IllegalArgumentException("Unsupported mix of use attributes " + this.use + "/" + soapBodyUse);
            }
        }
        if (this.use == null) {
            this.log.warn((Object)("Cannot find any use attribute for binding: " + this.wsdlBinding.getQName()));
            this.use = Use.LITERAL;
        }
    }

    private void initOperations() throws ServiceException {
        PortType wsdlPortType = this.wsdlBinding.getPortType();
        QName portTypeQName = wsdlPortType.getQName();
        Iterator itOp = wsdlPortType.getOperations().iterator();
        while (itOp.hasNext()) {
            QName typeQName;
            String paramName;
            Part wsdlPart;
            String opWsdlName;
            Operation wsdlOperation = (Operation)itOp.next();
            String opJavaName = opWsdlName = wsdlOperation.getName();
            QName opQName = null;
            if (portTypeQName.getNamespaceURI().length() > 0) {
                opQName = new QName(portTypeQName.getNamespaceURI(), opWsdlName);
                opQName = this.nsRegistry.registerQName(opQName);
            } else {
                opQName = new QName(opWsdlName);
            }
            ServiceEndpointMethodMapping seMethodMapping = this.getServiceEndpointMethodMapping(wsdlPortType, opWsdlName);
            if (seMethodMapping != null) {
                opJavaName = seMethodMapping.getJavaMethodName();
            }
            OperationDescription opDesc = new OperationDescription(opJavaName, opQName);
            this.operations.put(opJavaName, opDesc);
            Output wsdlOutput = wsdlOperation.getOutput();
            Input wsdlInput = wsdlOperation.getInput();
            if (wsdlInput != null && wsdlOutput == null) {
                this.log.debug((Object)("Using one-way call semantics: " + opWsdlName));
                opDesc.setOneWay(true);
            }
            if (this.style == Style.DOCUMENT && seMethodMapping != null) {
                boolean outParams;
                boolean inParams;
                boolean bl = inParams = seMethodMapping.getMethodParamPartsMappings().length > 0;
                if (wsdlInput != null && wsdlInput.getMessage().getParts().size() > 0 && !inParams) {
                    this.log.debug((Object)"jaxrpc-mapping does not have any <method-param-parts-mapping>, ignoring wsdl parts");
                    wsdlInput = null;
                }
                boolean bl2 = outParams = seMethodMapping.getWsdlReturnValueMapping() != null;
                if (wsdlOutput != null && wsdlOutput.getMessage().getParts().size() > 0 && !outParams) {
                    this.log.debug((Object)"jaxrpc-mapping does not have any <wsdl-return-value-mapping>, ignoring wsdl parts");
                    wsdlOutput = null;
                }
            }
            if (wsdlOutput != null) {
                Message wsdlMessageOut = wsdlOutput.getMessage();
                Iterator outParts = wsdlMessageOut.getOrderedParts(null).iterator();
                while (outParts.hasNext()) {
                    wsdlPart = (Part)outParts.next();
                    paramName = wsdlPart.getName();
                    typeQName = wsdlPart.getTypeName();
                    boolean outHeader = this.isHeaderParam(opWsdlName, paramName);
                    QName element = wsdlPart.getElementName();
                    if (typeQName == null && element != null) {
                        typeQName = element;
                    }
                    if (typeQName != null) {
                        typeQName = this.nsRegistry.registerQName(typeQName);
                        this.userTypes.add(typeQName);
                    }
                    String paramMode = null;
                    if (seMethodMapping != null) {
                        MethodParamPartsMapping[] mppMappings = seMethodMapping.getMethodParamPartsMappings();
                        for (int i = 0; paramMode == null && i < mppMappings.length; ++i) {
                            WsdlMessageMapping wmMapping = mppMappings[i].getWsdlMessageMapping();
                            if (!paramName.equals(wmMapping.getWsdlMessagePartName())) continue;
                            paramMode = wmMapping.getParameterMode();
                        }
                    }
                    if (opDesc.getReturnType() == null && wsdlOperation.getInput().getMessage().getPart(paramName) == null && paramMode == null) {
                        QName returnQName = this.getParameterQName(wsdlPart);
                        opDesc.setReturnQName(returnQName);
                        opDesc.setReturnType(typeQName);
                        continue;
                    }
                    if (paramMode == null) {
                        paramMode = "OUT";
                    }
                    QName paramQName = this.getParameterQName(wsdlPart);
                    OperationDescription.Parameter param = new OperationDescription.Parameter(paramName, paramQName, paramMode, typeQName);
                    param.setOutHeader(outHeader);
                    opDesc.addParameter(param);
                }
            }
            if (wsdlInput != null) {
                Message wsdlMessageIn = wsdlInput.getMessage();
                Iterator inParts = wsdlMessageIn.getOrderedParts(null).iterator();
                while (inParts.hasNext()) {
                    OperationDescription.Parameter param;
                    wsdlPart = (Part)inParts.next();
                    paramName = wsdlPart.getName();
                    typeQName = wsdlPart.getTypeName();
                    boolean inHeader = this.isHeaderParam(opWsdlName, paramName);
                    if (typeQName == null && wsdlPart.getElementName() != null) {
                        typeQName = wsdlPart.getElementName();
                    }
                    if (typeQName != null) {
                        typeQName = this.nsRegistry.registerQName(typeQName);
                        this.userTypes.add(typeQName);
                    }
                    if ((param = opDesc.getParameterForName(paramName)) != null) {
                        param.setMode("INOUT");
                        param.setInHeader(inHeader);
                        continue;
                    }
                    QName paramQName = this.getParameterQName(wsdlPart);
                    param = new OperationDescription.Parameter(paramName, paramQName, "IN", typeQName);
                    param.setInHeader(inHeader);
                    opDesc.addParameter(param);
                }
            }
            this.reorderOperationParameters(opDesc, wsdlOperation);
            Iterator inFaults = wsdlOperation.getFaults().values().iterator();
            while (inFaults.hasNext()) {
                TypeMapping defMapping;
                Class typeClass;
                Fault wsdlFault = (Fault)inFaults.next();
                wsdlPart = (Part)wsdlFault.getMessage().getParts().values().iterator().next();
                String partName = wsdlPart.getName();
                typeQName = wsdlPart.getTypeName();
                QName faultQName = wsdlPart.getElementName();
                if (typeQName == null && faultQName != null) {
                    typeQName = faultQName;
                }
                if (typeQName != null) {
                    typeQName = this.nsRegistry.registerQName(typeQName);
                }
                if (faultQName != null) {
                    faultQName = this.nsRegistry.registerQName(faultQName);
                }
                String javaType = null;
                if (this.javaWsdlMapping != null) {
                    QName wsdlMessageName = wsdlFault.getMessage().getQName();
                    ExceptionMapping exceptionMapping = this.javaWsdlMapping.getExceptionMappingForMessageQName(wsdlMessageName);
                    if (exceptionMapping != null) {
                        javaType = exceptionMapping.getExceptionType();
                    } else {
                        JavaXmlTypeMapping javaMapping = this.javaWsdlMapping.getTypeMappingForQName(typeQName);
                        if (javaMapping != null) {
                            javaType = javaMapping.getJavaType();
                        }
                    }
                }
                if (javaType == null && (typeClass = (defMapping = DefaultTypeMappingImpl.getSingleton()).getClassForQName(typeQName)) != null) {
                    javaType = typeClass.getName();
                }
                if (javaType == null) {
                    String packageName = this.getPackageName(typeQName);
                    javaType = packageName + "." + typeQName.getLocalPart();
                    this.log.warn((Object)("Guessing fault java type from qname: " + javaType));
                }
                OperationDescription.Fault fault = new OperationDescription.Fault(partName, faultQName, javaType, typeQName);
                opDesc.addFault(fault);
            }
        }
        if (this.operations.size() == 0) {
            this.log.warn((Object)("Cannot find any operations for portType: " + wsdlPortType.getQName()));
        }
    }

    private void reorderOperationParameters(OperationDescription opDesc, Operation wsdlOperation) {
        List wsdlParamOrder = wsdlOperation.getParameterOrdering();
        if (wsdlParamOrder != null && wsdlParamOrder.size() > 0) {
            ArrayList<OperationDescription.Parameter> orderedParams = new ArrayList<OperationDescription.Parameter>();
            Iterator it = wsdlParamOrder.iterator();
            while (it.hasNext()) {
                String paramName = (String)it.next();
                OperationDescription.Parameter opParam = opDesc.getParameterForName(paramName);
                if (opParam == null) {
                    throw new IllegalArgumentException("Operation paramerter appears in wsdl paramOrder, but not in operation: " + paramName);
                }
                orderedParams.add(opParam);
            }
            opDesc.setParameters(orderedParams);
        }
    }

    private QName getParameterQName(Part wsdlPart) {
        QName paramQName;
        String partName = wsdlPart.getName();
        QName elementName = wsdlPart.getElementName();
        QName qName = paramQName = elementName != null ? elementName : new QName(partName);
        if (!paramQName.getNamespaceURI().equals("")) {
            paramQName = this.nsRegistry.registerQName(paramQName);
        }
        return paramQName;
    }

    private ServiceEndpointMethodMapping getServiceEndpointMethodMapping(PortType wsdlPortType, String opWsdlName) {
        ServiceEndpointInterfaceMapping seiMapping;
        ServiceEndpointMethodMapping seiMethodMapping = null;
        if (this.javaWsdlMapping != null && (seiMapping = this.javaWsdlMapping.getServiceEndpointInterfaceMappingByPortType(wsdlPortType.getQName())) != null) {
            seiMethodMapping = seiMapping.getServiceEndpointMethodMappingByWsdlOperation(opWsdlName);
        }
        return seiMethodMapping;
    }

    private boolean isHeaderParam(String opName, String paramName) {
        boolean inHeader = false;
        BindingOperation wsdlBindingOperation = this.wsdlBinding.getBindingOperation(opName, null, null);
        if (wsdlBindingOperation != null) {
            BindingOutput bindingOutput;
            BindingInput bindingInput = wsdlBindingOperation.getBindingInput();
            if (bindingInput != null) {
                Iterator itIn = bindingInput.getExtensibilityElements().iterator();
                while (!inHeader && itIn.hasNext()) {
                    ExtensibilityElement exElement = (ExtensibilityElement)itIn.next();
                    if (!(exElement instanceof SOAPHeader)) continue;
                    SOAPHeader soapHeader = (SOAPHeader)exElement;
                    inHeader = soapHeader.getPart().equals(paramName);
                }
            }
            if ((bindingOutput = wsdlBindingOperation.getBindingOutput()) != null) {
                Iterator itOut = bindingOutput.getExtensibilityElements().iterator();
                while (!inHeader && itOut.hasNext()) {
                    ExtensibilityElement exElement = (ExtensibilityElement)itOut.next();
                    if (!(exElement instanceof SOAPHeader)) continue;
                    SOAPHeader soapHeader = (SOAPHeader)exElement;
                    inHeader = soapHeader.getPart().equals(paramName);
                }
            }
        } else {
            this.log.warn((Object)("Cannot obtain binding operation for: " + opName));
        }
        return inHeader;
    }

    private void initTypeMappings() throws ServiceException {
        TypeMappingDescription typeMapping;
        String javaType;
        QName anonymousQName;
        Iterator itRem = this.userTypes.iterator();
        while (itRem.hasNext()) {
            QName typeQName = (QName)itRem.next();
            String typeURI = typeQName.getNamespaceURI();
            if (!typeURI.equals("http://www.w3.org/2001/XMLSchema") && !typeURI.equals("http://schemas.xmlsoap.org/soap/encoding/")) continue;
            itRem.remove();
        }
        Iterator it = this.userTypes.iterator();
        while (it.hasNext()) {
            QName typeQName = (QName)it.next();
            String typeURI = typeQName.getNamespaceURI();
            String prefix = this.nsRegistry.getPrefix(typeURI);
            if (prefix == null) {
                throw new IllegalStateException("Cannot find uri in registry: " + typeURI);
            }
            anonymousQName = null;
            javaType = null;
            JavaXmlTypeMapping javaTypeMapping = null;
            if (this.javaWsdlMapping != null && (javaTypeMapping = this.javaWsdlMapping.getTypeMappingForQName(typeQName)) != null) {
                anonymousQName = javaTypeMapping.getAnonymousTypeQName();
                javaType = javaTypeMapping.getJavaType();
            }
            if (javaType == null) {
                String packageName = this.getPackageName(typeQName);
                String localPart = typeQName.getLocalPart();
                javaType = packageName + "." + localPart;
                this.log.debug((Object)("Guessing the javaType from typeQName: " + typeQName + " -> " + javaType));
            }
            typeMapping = new TypeMappingDescription(typeQName, anonymousQName, javaType, this.use, javaTypeMapping);
            this.typeMappings.put(typeQName, typeMapping);
            it.remove();
        }
        if (this.javaWsdlMapping != null) {
            JavaXmlTypeMapping[] javaXmlTypeMappings = this.javaWsdlMapping.getJavaXmlTypeMappings();
            for (int i = 0; i < javaXmlTypeMappings.length; ++i) {
                JavaXmlTypeMapping javaTypeMapping = javaXmlTypeMappings[i];
                anonymousQName = javaTypeMapping.getAnonymousTypeQName();
                javaType = javaTypeMapping.getJavaType();
                QName typeQName = javaTypeMapping.getRootTypeQName();
                if (typeQName == null && anonymousQName != null) {
                    typeQName = anonymousQName;
                }
                if ((typeQName = this.nsRegistry.registerQName(typeQName)) == null || this.typeMappings.get(typeQName) != null) continue;
                typeMapping = new TypeMappingDescription(typeQName, anonymousQName, javaType, this.use, javaTypeMapping);
                this.typeMappings.put(typeQName, typeMapping);
            }
        }
    }

    private String getPackageName(QName typeQName) throws ServiceException {
        String packageName = null;
        if (this.javaWsdlMapping != null) {
            packageName = this.javaWsdlMapping.getPackageTypeForURI(typeQName.getNamespaceURI());
            if (packageName == null) {
                throw new IllegalArgumentException("Cannot find package type for: " + typeQName);
            }
        } else {
            try {
                URI uri = new URI(typeQName.getNamespaceURI());
                String reverse = uri.getHost();
                StringTokenizer st = new StringTokenizer(reverse, ".");
                while (st.hasMoreTokens()) {
                    if (packageName == null) {
                        packageName = st.nextToken();
                        continue;
                    }
                    packageName = st.nextToken() + "." + packageName;
                }
                this.log.debug((Object)("Using type uri to obtain package: " + uri + " -> " + packageName));
            }
            catch (URISyntaxException e) {
                throw new ServiceException((Throwable)e);
            }
        }
        return packageName;
    }

    private Service getWsdlService(Definition wsdlDefinition, String portName) {
        Service wsdlService = null;
        if (portName == null) {
            if (wsdlDefinition.getServices().values().size() != 1) {
                throw new IllegalArgumentException("Unsupported number of service elements");
            }
            wsdlService = (Service)wsdlDefinition.getServices().values().iterator().next();
        } else {
            Iterator it = wsdlDefinition.getServices().values().iterator();
            while (wsdlService == null && it.hasNext()) {
                Service service = (Service)it.next();
                if (service.getPort(portName) == null) continue;
                wsdlService = service;
            }
        }
        if (wsdlService == null) {
            throw new IllegalArgumentException("Cannot find wsdl service for port: " + portName);
        }
        return wsdlService;
    }

    private Binding getWsdlBinding(Service wsdlService, String portName) {
        Binding wsdlBinding = null;
        if (portName != null) {
            Port port = wsdlService.getPort(portName);
            if (port == null) {
                throw new IllegalArgumentException("Cannot find wsdl port for: " + portName);
            }
            wsdlBinding = port.getBinding();
        } else {
            Iterator it = wsdlService.getPorts().values().iterator();
            while (it.hasNext()) {
                Port port = (Port)it.next();
                Binding binding = port.getBinding();
                if (wsdlBinding != null && !wsdlBinding.getQName().equals(binding.getQName())) {
                    throw new IllegalArgumentException("Multiple bindings not supported for service: " + wsdlService.getQName());
                }
                if (wsdlBinding != null) continue;
                wsdlBinding = binding;
            }
        }
        if (wsdlBinding == null) {
            throw new IllegalArgumentException("Cannot find wsdl binding for: " + wsdlService.getQName());
        }
        return wsdlBinding;
    }
}

