/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.media.util.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.media.util.registry.ObjectAlreadyBoundException;
import org.jboss.media.util.registry.ObjectNotBoundException;
import org.jboss.media.util.registry.Registry;

public class MapRegistry
implements Registry {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$media$util$registry$MapRegistry == null ? (class$org$jboss$media$util$registry$MapRegistry = MapRegistry.class$("org.jboss.media.util.registry.MapRegistry")) : class$org$jboss$media$util$registry$MapRegistry));
    private static final Map entries = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$org$jboss$media$util$registry$MapRegistry;

    public MapRegistry() {
    }

    public MapRegistry(Map initialEntries) throws ObjectAlreadyBoundException {
        this();
        Iterator keys = initialEntries.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            Object value = initialEntries.get(key);
            this.bind(key, value);
        }
    }

    public void bind(Object key, Object value) throws ObjectAlreadyBoundException {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        if (entries.containsKey(key)) {
            throw new ObjectAlreadyBoundException();
        }
        entries.put(key, value);
        if (log.isTraceEnabled()) {
            log.trace((Object)("bound " + key + "=" + value));
        }
    }

    public void rebind(Object key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        entries.put(key, value);
        if (log.isTraceEnabled()) {
            log.trace((Object)("rebind " + key + "=" + value));
        }
    }

    public Object unbind(Object key) throws ObjectNotBoundException {
        if (key == null) {
            throw new NullPointerException();
        }
        if (!entries.containsKey(key)) {
            throw new ObjectNotBoundException();
        }
        Object object = entries.remove(key);
        if (log.isTraceEnabled()) {
            log.trace((Object)("unbound " + key + "=" + object));
        }
        return object;
    }

    public Object lookup(Object key) throws ObjectNotBoundException {
        if (!entries.containsKey(key)) {
            throw new ObjectNotBoundException();
        }
        Object object = entries.get(key);
        if (log.isTraceEnabled()) {
            log.trace((Object)("lookup " + key + "=" + object));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator keyIterator() {
        Map map = entries;
        synchronized (map) {
            return entries.keySet().iterator();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

