/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.media.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import org.jboss.util.stream.Streams;

public class ResourceUtils {
    public static InputStream createStreamFromResource(String resourceName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResourceAsStream(resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createFileFromResource(String resourceName, String filePrefix, String fileSuffix) throws IOException {
        InputStream inputStream = ResourceUtils.createStreamFromResource(resourceName);
        try {
            File tempFile = File.createTempFile(filePrefix, fileSuffix);
            tempFile.deleteOnExit();
            FileOutputStream tempFileStream = new FileOutputStream(tempFile);
            try {
                Streams.copyb((InputStream)inputStream, (OutputStream)tempFileStream);
            }
            finally {
                ((OutputStream)tempFileStream).close();
            }
            File file = tempFile;
            return file;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadBinaryData(String resourceName) throws IOException {
        InputStream inputStream = ResourceUtils.createStreamFromResource(resourceName);
        try {
            byte[] byArray;
            ByteArrayOutputStream ouputStream = new ByteArrayOutputStream();
            try {
                int byteRead;
                while ((byteRead = inputStream.read()) != -1) {
                    ouputStream.write(byteRead);
                }
                byArray = ouputStream.toByteArray();
            }
            catch (Throwable throwable) {
                ouputStream.close();
                throw throwable;
            }
            ouputStream.close();
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadTextData(String resourceName) throws IOException {
        InputStream inputStream = ResourceUtils.createStreamFromResource(resourceName);
        try {
            String string;
            StringWriter stringWriter = new StringWriter();
            try {
                int byteRead;
                while ((byteRead = inputStream.read()) != -1) {
                    stringWriter.write(byteRead);
                }
                string = stringWriter.toString();
            }
            catch (Throwable throwable) {
                stringWriter.close();
                throw throwable;
            }
            stringWriter.close();
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    public static InputStream getResourceStream(String resource) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
    }

    public static File getResourceFile(String resource) {
        URL u = Thread.currentThread().getContextClassLoader().getResource(resource);
        String file = u.toExternalForm();
        return new File(file.substring(6, file.length()));
    }
}

