/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.media.registry;

import java.util.Iterator;
import java.util.Map;
import javax.emb.FormatAlreadyBoundException;
import javax.emb.MediaFormat;
import org.jboss.media.registry.SimpleMediaFormatRegistry;

public class ReflectionMediaFormatRegistry
extends SimpleMediaFormatRegistry {
    public ReflectionMediaFormatRegistry() {
    }

    public ReflectionMediaFormatRegistry(Map initialEntries) {
        this();
        Iterator it = initialEntries.keySet().iterator();
        while (it.hasNext()) {
            String fileExtension = (String)it.next();
            String mediaFormatClassName = (String)initialEntries.get(fileExtension);
            try {
                this.bind(fileExtension, mediaFormatClassName);
            }
            catch (FormatAlreadyBoundException ignore) {}
        }
    }

    public void bind(String fileExtension, String mediaFormatClassName) throws FormatAlreadyBoundException {
        try {
            Class<?> mediaFormatClass = Class.forName(mediaFormatClassName);
            MediaFormat mediaFormat = (MediaFormat)mediaFormatClass.newInstance();
            super.bind(fileExtension, mediaFormat);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void rebind(String fileExtension, String mediaFormatClassName) {
        try {
            Class<?> mediaFormatClass = Class.forName(mediaFormatClassName);
            MediaFormat mediaFormat = (MediaFormat)mediaFormatClass.newInstance();
            super.rebind(fileExtension, mediaFormat);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

