/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;

public class UnicastTest2
implements Runnable {
    Channel channel;
    String groupname = "UnicastTest2Group";
    String props = "UDP:PING:FD:DISCARD(down=0.1):NAKACK(retransmit_timeout=1000):UNICAST:FRAG:FLUSH:GMS:VIEW_ENFORCER:QUEUE";
    Thread writer = null;
    Vector mbrs = new Vector();
    Hashtable senders = new Hashtable();
    boolean running = true;
    final int NUM_MSGS = 100;

    public void start() throws Exception {
        this.channel = new JChannel(this.props);
        this.channel.connect(this.groupname);
        System.out.println("[ready]");
        while (true) {
            try {
                while (true) {
                    Object obj;
                    if ((obj = this.channel.receive(0L)) instanceof View) {
                        View view = (View)obj;
                        Vector tmp = view.getMembers();
                        this.mbrs.removeAllElements();
                        for (int i = 0; i < tmp.size(); ++i) {
                            this.mbrs.addElement(tmp.elementAt(i));
                        }
                        Enumeration e = this.senders.keys();
                        while (e.hasMoreElements()) {
                            Object sender = e.nextElement();
                            if (this.mbrs.contains(sender)) continue;
                            this.mbrs.removeElement(sender);
                        }
                        if (this.mbrs.size() > 1) {
                            if (this.writer != null) continue;
                            this.writer = new Thread((Runnable)this, "WriterThread");
                            this.writer.start();
                            continue;
                        }
                        if (this.writer != null) {
                            this.running = false;
                            this.writer.interrupt();
                        }
                        this.writer = null;
                        continue;
                    }
                    if (!(obj instanceof Message)) continue;
                    Message msg = (Message)obj;
                    UnicastTest2Info info = (UnicastTest2Info)msg.getObject();
                    System.out.println("Received msg: " + info);
                    UnicastTest2Info myinfo = (UnicastTest2Info)this.senders.get(info.sender);
                    if (myinfo == null) {
                        if (info.msgno == 1) {
                            this.senders.put(info.sender, info);
                            continue;
                        }
                        System.err.println("UnicastTest2.start(): first seqno must be 1");
                        continue;
                    }
                    if (info.msgno - 1 != myinfo.msgno) {
                        System.err.println("UnicastTest2.start(): received msg " + info.sender + ':' + info.msgno + ", but last received was " + myinfo.sender + ':' + myinfo.msgno);
                        continue;
                    }
                    System.out.println("UnicastTest2.start(): OK received " + info.sender + ':' + info.msgno + ", prev seqno=" + myinfo.sender + ':' + myinfo.msgno);
                    ++myinfo.msgno;
                }
            }
            catch (ChannelClosedException closed) {
                System.err.println("Channel closed");
            }
            catch (ChannelNotConnectedException not_conn) {
                System.err.println("Channel not connected");
            }
            catch (Exception e) {
                System.err.println(e);
                continue;
            }
            break;
        }
    }

    Address selectTarget() {
        Vector tmp = new Vector();
        if (this.mbrs == null || this.mbrs.size() < 2) {
            return null;
        }
        for (int i = 0; i < this.mbrs.size(); ++i) {
            if (this.mbrs.elementAt(i).equals(this.channel.getLocalAddress())) continue;
            tmp.addElement(this.mbrs.elementAt(i));
        }
        int t = (int)(Math.random() * 100.0);
        Address ret = (Address)tmp.elementAt(t % tmp.size());
        return ret;
    }

    public void run() {
        Address target = this.selectTarget();
        UnicastTest2Info info = null;
        int msgno = 1;
        if (target == null) {
            return;
        }
        while (this.running && msgno <= 100) {
            try {
                info = new UnicastTest2Info(msgno++, this.channel.getLocalAddress());
                System.out.println("Sending message #" + (msgno - 1) + " to " + target);
                this.channel.send(new Message(target, null, info));
                Thread.sleep(500L);
            }
            catch (ChannelClosedException closed) {
                System.err.println(closed);
                break;
            }
            catch (ChannelNotConnectedException not_conn) {
                System.err.println(not_conn);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        System.out.println("UnicastTest2Info.run(): writer thread terminated");
    }

    public static void main(String[] args) {
        try {
            new UnicastTest2().start();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private static class UnicastTest2Info
    implements Serializable {
        int msgno = 0;
        Object sender = null;

        public UnicastTest2Info() {
        }

        public UnicastTest2Info(int msgno, Object sender) {
            this.msgno = msgno;
            this.sender = sender;
        }

        public String toString() {
            return "#" + this.msgno + " (sender=" + this.sender + ')';
        }
    }
}

