/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.Transport;
import org.jgroups.View;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.stack.GossipServer;
import org.jgroups.stack.Router;
import org.jgroups.util.Promise;

public class DisconnectTest
extends TestCase {
    private JChannel channel;
    static /* synthetic */ Class class$org$jgroups$tests$DisconnectTest;

    public DisconnectTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    private String getTUNNELProps(int routerPort, int gossipPort) {
        return "TUNNEL(router_host=localhost;router_port=" + routerPort + "):" + "PING(gossip_host=localhost;gossip_port=" + gossipPort + "):" + "pbcast.FD:" + "VERIFY_SUSPECT(timeout=1500;down_thread=false;up_thread=false):" + "pbcast.NAKACK(gc_lag=100;retransmit_timeout=3000;" + "down_thread=true;up_thread=true):" + "pbcast.STABLE(desired_avg_gossip=20000;down_thread=false;" + "up_thread=false):" + "pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;" + "print_local_addr=false;down_thread=true;up_thread=true)";
    }

    public void testDisconnectConnectOne_Default() throws Exception {
        this.channel = new JChannel();
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup2");
        View view = this.channel.getView();
        DisconnectTest.assertEquals((int)1, (int)view.size());
        DisconnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
    }

    public void testDisconnectConnectTwo_Default() throws Exception {
        JChannel coordinator = new JChannel();
        coordinator.connect("testgroup");
        this.channel = new JChannel();
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup");
        View view = this.channel.getView();
        DisconnectTest.assertEquals((int)2, (int)view.size());
        DisconnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
        DisconnectTest.assertTrue((boolean)view.containsMember(coordinator.getLocalAddress()));
        coordinator.close();
    }

    public void testDisconnectConnectSendTwo_Default() throws Exception {
        Promise msgPromise = new Promise();
        JChannel coordinator = new JChannel();
        coordinator.connect("testgroup");
        PullPushAdapter ppa = new PullPushAdapter((Transport)coordinator, new PromisedMessageListener(msgPromise));
        ppa.start();
        this.channel = new JChannel();
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup");
        this.channel.send(new Message(null, null, (Serializable)((Object)"payload")));
        Message msg = (Message)msgPromise.getResult(20000L);
        DisconnectTest.assertTrue((msg != null ? 1 : 0) != 0);
        DisconnectTest.assertEquals((Object)"payload", (Object)msg.getObject());
        ppa.stop();
        coordinator.close();
    }

    public void testDisconnectConnectOne_TUNNEL() throws Exception {
        String props = this.getTUNNELProps(this.startRouter(), this.startGossipServer());
        this.channel = new JChannel(props);
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup2");
        View view = this.channel.getView();
        DisconnectTest.assertEquals((int)1, (int)view.size());
        DisconnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
    }

    public void testDisconnectConnectTwo_TUNNEL() throws Exception {
        String props = this.getTUNNELProps(this.startRouter(), this.startGossipServer());
        JChannel coordinator = new JChannel(props);
        coordinator.connect("testgroup");
        this.channel = new JChannel(props);
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup");
        View view = this.channel.getView();
        DisconnectTest.assertEquals((int)2, (int)view.size());
        DisconnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
        DisconnectTest.assertTrue((boolean)view.containsMember(coordinator.getLocalAddress()));
        coordinator.close();
    }

    public void testDisconnectConnectSendTwo_TUNNEL() throws Exception {
        String props = this.getTUNNELProps(this.startRouter(), this.startGossipServer());
        Promise msgPromise = new Promise();
        JChannel coordinator = new JChannel(props);
        coordinator.connect("testgroup");
        PullPushAdapter ppa = new PullPushAdapter((Transport)coordinator, new PromisedMessageListener(msgPromise));
        ppa.start();
        this.channel = new JChannel(props);
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup");
        this.channel.send(new Message(null, null, (Serializable)((Object)"payload")));
        Message msg = (Message)msgPromise.getResult(20000L);
        DisconnectTest.assertTrue((msg != null ? 1 : 0) != 0);
        DisconnectTest.assertEquals((Object)"payload", (Object)msg.getObject());
        ppa.stop();
        coordinator.close();
    }

    public static Test suite() {
        TestSuite s = new TestSuite(class$org$jgroups$tests$DisconnectTest == null ? (class$org$jgroups$tests$DisconnectTest = DisconnectTest.class$("org.jgroups.tests.DisconnectTest")) : class$org$jgroups$tests$DisconnectTest);
        return s;
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{(class$org$jgroups$tests$DisconnectTest == null ? (class$org$jgroups$tests$DisconnectTest = DisconnectTest.class$("org.jgroups.tests.DisconnectTest")) : class$org$jgroups$tests$DisconnectTest).getName()};
        TestRunner.main((String[])testCaseName);
    }

    private int startRouter() throws Exception {
        long startms;
        final int routerPort = this.getFreePort();
        Thread routerThread = new Thread(new Runnable(){

            public void run() {
                try {
                    new Router(routerPort).start();
                }
                catch (Exception e) {
                    System.err.println("Failed to start the router on port " + routerPort);
                    e.printStackTrace();
                }
            }
        });
        routerThread.start();
        long crtms = startms = System.currentTimeMillis();
        Throwable lastConnectException = null;
        while (crtms - startms < 10000L) {
            Socket s = null;
            try {
                s = new Socket("localhost", routerPort);
            }
            catch (Exception e) {
                lastConnectException = e;
                Thread.sleep(1000L);
                crtms = System.currentTimeMillis();
                continue;
            }
            lastConnectException = null;
            DataInputStream dis = new DataInputStream(s.getInputStream());
            DataOutputStream dos = new DataOutputStream(s.getOutputStream());
            int len = dis.readInt();
            byte[] buffer = new byte[len];
            dis.read(buffer, 0, len);
            dos.writeInt(-10);
            dos.writeUTF("nogroup_setup");
            dis.readInt();
            s.close();
            break;
        }
        if (lastConnectException != null) {
            lastConnectException.printStackTrace();
            DisconnectTest.fail((String)"Cannot connect to the router");
        }
        System.out.println("router ok");
        return routerPort;
    }

    private int startGossipServer() throws Exception {
        long startms;
        final int gossipPort = this.getFreePort();
        Thread gossipThread = new Thread(new Runnable(){

            public void run() {
                try {
                    new GossipServer(gossipPort).run();
                }
                catch (Exception e) {
                    System.err.println("Failed to start the gossip server on port " + gossipPort);
                    e.printStackTrace();
                }
            }
        });
        gossipThread.start();
        long crtms = startms = System.currentTimeMillis();
        Throwable lastConnectException = null;
        while (crtms - startms < 10000L) {
            Socket s = null;
            try {
                s = new Socket("localhost", gossipPort);
            }
            catch (Exception e) {
                lastConnectException = e;
                Thread.sleep(1000L);
                crtms = System.currentTimeMillis();
                continue;
            }
            lastConnectException = null;
            ObjectOutputStream oos = new ObjectOutputStream(s.getOutputStream());
            Object gd = null;
            oos.writeObject(gd);
            oos.close();
            s.close();
            break;
        }
        if (lastConnectException != null) {
            lastConnectException.printStackTrace();
            DisconnectTest.fail((String)"Cannot connect to the gossip server");
        }
        System.out.println("gossip server ok");
        return gossipPort;
    }

    private int getFreePort() throws Exception {
        ServerSocket ss = new ServerSocket(0);
        int port = ss.getLocalPort();
        ss.close();
        return port;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PromisedMessageListener
    implements MessageListener {
        private Promise promise;

        public PromisedMessageListener(Promise promise) {
            this.promise = promise;
        }

        public byte[] getState() {
            return null;
        }

        public void receive(Message msg) {
            this.promise.setResult(msg);
        }

        public void setState(byte[] state) {
        }
    }
}

