/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.jdbc2;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.jms.JMSException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.pm.CacheStore;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.pm.TxManager;
import org.jboss.mq.pm.jdbc2.PersistenceManagerMBean;
import org.jboss.mq.server.JMSDestination;
import org.jboss.mq.server.MessageCache;
import org.jboss.mq.server.MessageReference;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.TransactionManagerService;

public class PersistenceManager
extends ServiceMBeanSupport
implements PersistenceManagerMBean,
org.jboss.mq.pm.PersistenceManager,
CacheStore {
    private SynchronizedLong nextTransactionId = new SynchronizedLong(0L);
    private TxManager txManager;
    private DataSource datasource;
    private TransactionManager tm;
    String UPDATE_MARKED_MESSAGES = "UPDATE JMS_MESSAGES SET TXID=?, TXOP=? WHERE TXOP=?";
    String UPDATE_MARKED_MESSAGES_WITH_TX = "UPDATE JMS_MESSAGES SET TXID=?, TXOP=? WHERE TXOP=? AND TXID=?";
    String DELETE_MARKED_MESSAGES_WITH_TX = "DELETE FROM JMS_MESSAGES WHERE TXID IN (SELECT TXID FROM JMS_TRANSACTIONS) AND TXOP=?";
    String DELETE_TX = "DELETE FROM JMS_TRANSACTIONS WHERE TXID = ?";
    String DELETE_MARKED_MESSAGES = "DELETE FROM JMS_MESSAGES WHERE TXID=? AND TXOP=?";
    String DELETE_TEMPORARY_MESSAGES = "DELETE FROM JMS_MESSAGES WHERE TXOP = 'T'";
    String INSERT_TX = "INSERT INTO JMS_TRANSACTIONS (TXID) values(?)";
    String SELECT_MAX_TX = "SELECT MAX(TXID) FROM JMS_MESSAGES";
    String SELECT_MESSAGES_IN_DEST = "SELECT MESSAGEID, MESSAGEBLOB FROM JMS_MESSAGES WHERE DESTINATION=?";
    String SELECT_MESSAGE = "SELECT MESSAGEID, MESSAGEBLOB FROM JMS_MESSAGES WHERE MESSAGEID=? AND DESTINATION=?";
    String INSERT_MESSAGE = "INSERT INTO JMS_MESSAGES (MESSAGEID, DESTINATION, MESSAGEBLOB, TXID, TXOP) VALUES(?,?,?,?,?)";
    String MARK_MESSAGE = "UPDATE JMS_MESSAGES SET TXID=?, TXOP=? WHERE MESSAGEID=? AND DESTINATION=?";
    String DELETE_MESSAGE = "DELETE FROM JMS_MESSAGES WHERE MESSAGEID=? AND DESTINATION=?";
    String UPDATE_MESSAGE = "UPDATE JMS_MESSAGES SET MESSAGEBLOB=? WHERE MESSAGEID=? AND DESTINATION=?";
    String CREATE_MESSAGE_TABLE = "CREATE TABLE JMS_MESSAGES ( MESSAGEID INTEGER NOT NULL, DESTINATION VARCHAR(32) NOT NULL, TXID INTEGER, TXOP CHAR(1),MESSAGEBLOB OBJECT, PRIMARY KEY (MESSAGEID, DESTINATION) )";
    String CREATE_IDX_MESSAGE_TXOP_TXID = "CREATE INDEX JMS_MESSAGES_TXOP_TXID ON JMS_MESSAGES (TXOP, TXID)";
    String CREATE_IDX_MESSAGE_DESTINATION = "CREATE INDEX JMS_MESSAGES_DESTINATION ON JMS_MESSAGES (DESTINATION)";
    String CREATE_TX_TABLE = "CREATE TABLE JMS_TRANSACTIONS ( TXID INTEGER, PRIMARY KEY (TXID) )";
    static final int OBJECT_BLOB = 0;
    static final int BYTES_BLOB = 1;
    static final int BINARYSTREAM_BLOB = 2;
    static final int BLOB_BLOB = 3;
    int blobType = 0;
    boolean createTables;
    private int connectionRetryAttempts = 5;
    private ObjectName connectionManagerName;
    private Properties sqlProperties = new Properties();

    public PersistenceManager() throws JMSException {
        this.txManager = new TxManager(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resolveAllUncommitedTXs() throws JMSException {
        boolean threadWasInterrupted;
        ResultSet rs;
        Statement stmt;
        Connection c;
        TransactionManagerStrategy tms;
        block87: {
            tms = new TransactionManagerStrategy();
            tms.startTX();
            c = null;
            stmt = null;
            rs = null;
            threadWasInterrupted = Thread.interrupted();
            try {
                if (!this.createTables) break block87;
                c = this.getConnection();
                boolean createdMessageTable = false;
                try {
                    stmt = c.prepareStatement(this.CREATE_MESSAGE_TABLE);
                    stmt.executeUpdate();
                    createdMessageTable = true;
                }
                catch (SQLException e) {
                    this.log.debug((Object)("Could not create table with SQL: " + this.CREATE_MESSAGE_TABLE), (Throwable)e);
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Throwable ignored) {
                        this.log.trace((Object)("Ignored: " + ignored));
                    }
                    stmt = null;
                }
                if (createdMessageTable) {
                    try {
                        stmt = c.prepareStatement(this.CREATE_IDX_MESSAGE_TXOP_TXID);
                        stmt.executeUpdate();
                    }
                    catch (SQLException e) {
                        this.log.debug((Object)("Could not create index with SQL: " + this.CREATE_IDX_MESSAGE_TXOP_TXID), (Throwable)e);
                    }
                    finally {
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (Throwable ignored) {
                            this.log.trace((Object)("Ignored: " + ignored));
                        }
                        stmt = null;
                    }
                    try {
                        stmt = c.prepareStatement(this.CREATE_IDX_MESSAGE_DESTINATION);
                        stmt.executeUpdate();
                    }
                    catch (SQLException e) {
                        this.log.debug((Object)("Could not create index with SQL: " + this.CREATE_IDX_MESSAGE_DESTINATION), (Throwable)e);
                    }
                    finally {
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (Throwable ignored) {
                            this.log.trace((Object)("Ignored: " + ignored));
                        }
                        stmt = null;
                    }
                }
                try {
                    stmt = c.prepareStatement(this.CREATE_TX_TABLE);
                    stmt.executeUpdate();
                }
                catch (SQLException e) {
                    this.log.debug((Object)("Could not create table with SQL: " + this.CREATE_TX_TABLE), (Throwable)e);
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Throwable ignored) {
                        this.log.trace((Object)("Ignored: " + ignored));
                    }
                    stmt = null;
                }
            }
            catch (SQLException e) {
                tms.setRollbackOnly();
                throw new SpyJMSException("Could not get a connection for jdbc2 table construction ", e);
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Throwable ignore) {}
                stmt = null;
                try {
                    if (c != null) {
                        c.close();
                    }
                }
                catch (Throwable ignore) {}
                c = null;
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        tms = new TransactionManagerStrategy();
        tms.startTX();
        threadWasInterrupted = Thread.interrupted();
        try {
            c = this.getConnection();
            stmt = c.prepareStatement(this.SELECT_MAX_TX);
            rs = stmt.executeQuery();
            if (rs.next()) {
                this.nextTransactionId.set(rs.getLong(1) + 1L);
            }
            stmt.close();
            stmt = c.prepareStatement(this.DELETE_TEMPORARY_MESSAGES);
            stmt.executeUpdate();
            stmt.close();
            stmt = c.prepareStatement(this.DELETE_MARKED_MESSAGES_WITH_TX);
            stmt.setString(1, "A");
            stmt.executeUpdate();
            stmt.close();
            stmt = c.prepareStatement(this.UPDATE_MARKED_MESSAGES);
            stmt.setNull(1, -5);
            stmt.setString(2, "A");
            stmt.setString(3, "D");
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            tms.setRollbackOnly();
            throw new SpyJMSException("Could not resolve uncommited transactions.  Message recovery may not be accurate", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Throwable ignore) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Throwable ignore) {}
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable ignore) {}
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized void restoreQueue(JMSDestination jmsDest, SpyDestination dest) throws JMSException {
        if (jmsDest == null) {
            throw new IllegalArgumentException("Must supply non null JMSDestination to restoreQueue");
        }
        if (dest == null) {
            throw new IllegalArgumentException("Must supply non null SpyDestination to restoreQueue");
        }
        TransactionManagerStrategy tms = new TransactionManagerStrategy();
        tms.startTX();
        Connection c = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            c = this.getConnection();
            stmt = c.prepareStatement(this.SELECT_MESSAGES_IN_DEST);
            stmt.setString(1, dest.toString());
            rs = stmt.executeQuery();
            int counter = 0;
            while (rs.next()) {
                SpyMessage message = this.extractMessage(rs);
                if (dest instanceof SpyTopic) {
                    message.header.durableSubscriberID = ((SpyTopic)dest).getDurableSubscriptionID();
                }
                jmsDest.restoreMessage(message);
                ++counter;
            }
            this.log.debug((Object)("Restored " + counter + " message(s) to: " + dest));
        }
        catch (IOException e) {
            tms.setRollbackOnly();
            throw new SpyJMSException("Could not restore messages to destination : " + dest.toString(), e);
        }
        catch (SQLException e) {
            tms.setRollbackOnly();
            throw new SpyJMSException("Could not restore messages to destination : " + dest.toString(), e);
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable ignore) {}
            try {
                stmt.close();
            }
            catch (Throwable ignore) {}
            try {
                c.close();
            }
            catch (Throwable ignore) {}
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    SpyMessage extractMessage(ResultSet rs) throws SQLException, IOException {
        try {
            long messageid = rs.getLong(1);
            SpyMessage message = null;
            if (this.blobType == 0) {
                message = (SpyMessage)rs.getObject(2);
            } else if (this.blobType == 1) {
                byte[] st = rs.getBytes(2);
                ByteArrayInputStream baip = new ByteArrayInputStream(st);
                ObjectInputStream ois = new ObjectInputStream(baip);
                message = SpyMessage.readMessage(ois);
            } else if (this.blobType == 2) {
                ObjectInputStream ois = new ObjectInputStream(rs.getBinaryStream(2));
                message = SpyMessage.readMessage(ois);
            } else if (this.blobType == 3) {
                ObjectInputStream ois = new ObjectInputStream(rs.getBlob(2).getBinaryStream());
                message = SpyMessage.readMessage(ois);
            }
            message.header.messageId = messageid;
            return message;
        }
        catch (StreamCorruptedException e) {
            throw new IOException("Could not load the message: " + e);
        }
    }

    public void commitPersistentTx(Tx txId) throws JMSException {
        if (!txId.wasPersisted()) {
            return;
        }
        TransactionManagerStrategy tms = new TransactionManagerStrategy();
        tms.startTX();
        Connection c = null;
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            c = this.getConnection();
            this.removeMarkedMessages(c, txId, "D");
            this.removeTXRecord(c, txId.longValue());
        }
        catch (SQLException e) {
            tms.setRollbackOnly();
            throw new SpyJMSException("Could not commit tx: " + txId, e);
        }
        finally {
            try {
                c.close();
            }
            catch (Throwable ignore) {}
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMarkedMessages(Connection c, Tx txid, String mark) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = c.prepareStatement(this.DELETE_MARKED_MESSAGES);
            stmt.setLong(1, txid.longValue());
            stmt.setString(2, mark);
            stmt.executeUpdate();
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTXRecord(Connection c, long txid) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = c.prepareStatement(this.INSERT_TX);
            stmt.setLong(1, txid);
            stmt.executeUpdate();
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTXRecord(Connection c, long txid) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = c.prepareStatement(this.DELETE_TX);
            stmt.setLong(1, txid);
            stmt.executeUpdate();
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable e) {}
        }
    }

    public void rollbackPersistentTx(Tx txId) throws JMSException {
        if (!txId.wasPersisted()) {
            return;
        }
        TransactionManagerStrategy tms = new TransactionManagerStrategy();
        tms.startTX();
        Connection c = null;
        Statement stmt = null;
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            c = this.getConnection();
            this.removeMarkedMessages(c, txId, "A");
            this.removeTXRecord(c, txId.longValue());
            stmt = c.prepareStatement(this.UPDATE_MARKED_MESSAGES_WITH_TX);
            stmt.setNull(1, -5);
            stmt.setString(2, "A");
            stmt.setString(3, "D");
            stmt.setLong(4, txId.longValue());
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            tms.setRollbackOnly();
            throw new SpyJMSException("Could not rollback tx: " + txId, e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable ignore) {}
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public Tx createPersistentTx() throws JMSException {
        Tx id = new Tx(this.nextTransactionId.increment());
        return id;
    }

    public void insertPersistentTx(TransactionManagerStrategy tms, Connection c, Tx tx) throws JMSException {
        try {
            if (tx != null && !tx.checkPersisted()) {
                this.addTXRecord(c, tx.longValue());
            }
        }
        catch (SQLException e) {
            tms.setRollbackOnly();
            throw new SpyJMSException("Could not create tx: " + tx.longValue(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(MessageReference messageRef, Tx txId) throws JMSException {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("About to add message " + messageRef + " transaction=" + txId));
        }
        TransactionManagerStrategy tms = new TransactionManagerStrategy();
        tms.startTX();
        Connection c = null;
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            c = this.getConnection();
            this.insertPersistentTx(tms, c, txId);
            MessageReference messageReference = messageRef;
            synchronized (messageReference) {
                SpyMessage message = messageRef.getMessage();
                if (messageRef.stored == 2) {
                    if (trace) {
                        this.log.trace((Object)("Updating message " + messageRef + " transaction=" + txId));
                    }
                    this.markMessage(c, messageRef.messageId, messageRef.getPersistentKey(), txId, "A");
                } else {
                    if (trace) {
                        this.log.trace((Object)("Inserting message " + messageRef + " transaction=" + txId));
                    }
                    this.add(c, messageRef.getPersistentKey(), message, txId, "A");
                    messageRef.setStored(2);
                }
                if (trace) {
                    this.log.trace((Object)("Added message " + messageRef + " transaction=" + txId));
                }
            }
        }
        catch (IOException e) {
            tms.setRollbackOnly();
            throw new SpyJMSException("Could not store message: " + messageRef, e);
        }
        catch (SQLException e) {
            tms.setRollbackOnly();
            throw new SpyJMSException("Could not store message: " + messageRef, e);
        }
        finally {
            try {
                c.close();
            }
            catch (Throwable ignore) {}
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(Connection c, String queue, SpyMessage message, Tx txId, String mark) throws SQLException, IOException {
        PreparedStatement stmt = null;
        try {
            stmt = c.prepareStatement(this.INSERT_MESSAGE);
            stmt.setLong(1, message.header.messageId);
            stmt.setString(2, queue);
            this.setBlob(stmt, 3, message);
            if (txId != null) {
                stmt.setLong(4, txId.longValue());
            } else {
                stmt.setNull(4, -5);
            }
            stmt.setString(5, mark);
            stmt.executeUpdate();
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markMessage(Connection c, long messageid, String destination, Tx txId, String mark) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = c.prepareStatement(this.MARK_MESSAGE);
            if (txId == null) {
                stmt.setNull(1, -5);
            } else {
                stmt.setLong(1, txId.longValue());
            }
            stmt.setString(2, mark);
            stmt.setLong(3, messageid);
            stmt.setString(4, destination);
            stmt.executeUpdate();
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable ignore) {}
        }
    }

    public void setBlob(PreparedStatement stmt, int column, SpyMessage message) throws IOException, SQLException {
        if (this.blobType == 0) {
            stmt.setObject(column, message);
        } else if (this.blobType == 1) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            SpyMessage.writeMessage(message, oos);
            oos.flush();
            byte[] messageAsBytes = baos.toByteArray();
            stmt.setBytes(column, messageAsBytes);
        } else if (this.blobType == 2) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            SpyMessage.writeMessage(message, oos);
            oos.flush();
            byte[] messageAsBytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(messageAsBytes);
            stmt.setBinaryStream(column, (InputStream)bais, messageAsBytes.length);
        } else if (this.blobType == 3) {
            throw new RuntimeException("BLOB_TYPE: BLOB_BLOB is not yet implemented.");
        }
    }

    public void update(MessageReference messageRef, Tx txId) throws JMSException {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("Updating message " + messageRef + " transaction=" + txId));
        }
        TransactionManagerStrategy tms = new TransactionManagerStrategy();
        tms.startTX();
        Connection c = null;
        Statement stmt = null;
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            c = this.getConnection();
            if (txId == null) {
                stmt = c.prepareStatement(this.UPDATE_MESSAGE);
                this.setBlob((PreparedStatement)stmt, 1, messageRef.getMessage());
                stmt.setLong(2, messageRef.messageId);
                stmt.setString(3, messageRef.getPersistentKey());
                int rc = stmt.executeUpdate();
                if (rc != 1) {
                    throw new SpyJMSException("Could not update the message in the database: update affected " + rc + " rows");
                }
            } else {
                throw new SpyJMSException("NYI: Updating a message in a transaction is not currently used");
            }
            if (trace) {
                this.log.trace((Object)("Updated message " + messageRef + " transaction=" + txId));
            }
        }
        catch (IOException e) {
            tms.setRollbackOnly();
            throw new SpyJMSException("Could not update message: " + messageRef, e);
        }
        catch (SQLException e) {
            tms.setRollbackOnly();
            throw new SpyJMSException("Could not update message: " + messageRef, e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable ignore) {}
            try {
                c.close();
            }
            catch (Throwable ignore) {}
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(MessageReference messageRef, Tx txId) throws JMSException {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("Removing message " + messageRef + " transaction=" + txId));
        }
        TransactionManagerStrategy tms = new TransactionManagerStrategy();
        tms.startTX();
        Connection c = null;
        Statement stmt = null;
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            c = this.getConnection();
            this.insertPersistentTx(tms, c, txId);
            MessageReference messageReference = messageRef;
            synchronized (messageReference) {
                if (txId == null) {
                    stmt = c.prepareStatement(this.DELETE_MESSAGE);
                    stmt.setLong(1, messageRef.messageId);
                    stmt.setString(2, messageRef.getPersistentKey());
                    int rc = stmt.executeUpdate();
                    if (rc != 1) {
                        throw new SpyJMSException("Could not delete the message from the database: delete affected " + rc + " rows");
                    }
                    messageRef.setStored(1);
                    messageRef.removeDelayed();
                } else {
                    stmt = c.prepareStatement(this.MARK_MESSAGE);
                    stmt.setLong(1, txId.longValue());
                    stmt.setString(2, "D");
                    stmt.setLong(3, messageRef.messageId);
                    stmt.setString(4, messageRef.getPersistentKey());
                    int rc = stmt.executeUpdate();
                    if (rc != 1) {
                        throw new SpyJMSException("Could not mark the message as deleted in the database: update affected " + rc + " rows");
                    }
                }
                if (trace) {
                    this.log.trace((Object)("Removed message " + messageRef + " transaction=" + txId));
                }
            }
        }
        catch (SQLException e) {
            tms.setRollbackOnly();
            throw new SpyJMSException("Could not remove message: " + messageRef, e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable ignore) {}
            try {
                c.close();
            }
            catch (Throwable ignore) {}
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public TxManager getTxManager() {
        return this.txManager;
    }

    public void closeQueue(JMSDestination jmsDest, SpyDestination dest) throws JMSException {
    }

    public SpyMessage loadFromStorage(MessageReference messageRef) throws JMSException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Loading message from storage " + messageRef));
        }
        TransactionManagerStrategy tms = new TransactionManagerStrategy();
        tms.startTX();
        Connection c = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            c = this.getConnection();
            stmt = c.prepareStatement(this.SELECT_MESSAGE);
            stmt.setLong(1, messageRef.messageId);
            stmt.setString(2, messageRef.getPersistentKey());
            rs = stmt.executeQuery();
            if (rs.next()) {
                SpyMessage spyMessage = this.extractMessage(rs);
                return spyMessage;
            }
            SpyMessage spyMessage = null;
            return spyMessage;
        }
        catch (IOException e) {
            tms.setRollbackOnly();
            throw new SpyJMSException("Could not load message : " + messageRef, e);
        }
        catch (SQLException e) {
            tms.setRollbackOnly();
            throw new SpyJMSException("Could not load message : " + messageRef, e);
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable ignore) {}
            try {
                stmt.close();
            }
            catch (Throwable ignore) {}
            try {
                c.close();
            }
            catch (Throwable ignore) {}
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void removeFromStorage(MessageReference messageRef) throws JMSException {
        if (messageRef.isPersistent()) {
            return;
        }
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("Removing message from storage " + messageRef));
        }
        TransactionManagerStrategy tms = new TransactionManagerStrategy();
        tms.startTX();
        Connection c = null;
        Statement stmt = null;
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            c = this.getConnection();
            stmt = c.prepareStatement(this.DELETE_MESSAGE);
            stmt.setLong(1, messageRef.messageId);
            stmt.setString(2, messageRef.getPersistentKey());
            stmt.executeUpdate();
            messageRef.setStored(1);
            if (trace) {
                this.log.trace((Object)("Removed message from storage " + messageRef));
            }
        }
        catch (SQLException e) {
            tms.setRollbackOnly();
            throw new SpyJMSException("Could not remove message: " + messageRef, e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable ignore) {}
            try {
                c.close();
            }
            catch (Throwable ignore) {}
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void saveToStorage(MessageReference messageRef, SpyMessage message) throws JMSException {
        if (messageRef.isPersistent()) {
            return;
        }
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("Saving message to storage " + messageRef));
        }
        TransactionManagerStrategy tms = new TransactionManagerStrategy();
        tms.startTX();
        Connection c = null;
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            c = this.getConnection();
            this.add(c, messageRef.getPersistentKey(), message, null, "T");
            messageRef.setStored(2);
            if (trace) {
                this.log.trace((Object)("Saved message to storage " + messageRef));
            }
        }
        catch (IOException e) {
            tms.setRollbackOnly();
            throw new SpyJMSException("Could not store message: " + messageRef, e);
        }
        catch (SQLException e) {
            tms.setRollbackOnly();
            throw new SpyJMSException("Could not store message: " + messageRef, e);
        }
        finally {
            try {
                c.close();
            }
            catch (Throwable ignore) {}
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection() throws SQLException {
        int attempts = this.connectionRetryAttempts;
        int attemptCount = 0;
        SQLException sqlException = null;
        while (attempts-- > 0) {
            if (++attemptCount > 1) {
                this.log.debug((Object)("Retrying connection: attempt # " + attemptCount));
            }
            try {
                sqlException = null;
                Connection connection = this.datasource.getConnection();
                return connection;
            }
            catch (SQLException exception) {
                this.log.debug((Object)("Connection attempt # " + attemptCount + " failed with SQLException"), (Throwable)exception);
                sqlException = exception;
            }
            finally {
                if (sqlException == null && attemptCount > 1) {
                    this.log.debug((Object)("Connection succeeded on attempt # " + attemptCount));
                }
            }
            if (attempts <= 0) continue;
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        if (sqlException != null) {
            throw sqlException;
        }
        throw new SQLException("connection attempt interrupted");
    }

    public void startService() throws Exception {
        this.UPDATE_MARKED_MESSAGES = this.sqlProperties.getProperty("UPDATE_MARKED_MESSAGES", this.UPDATE_MARKED_MESSAGES);
        this.UPDATE_MARKED_MESSAGES_WITH_TX = this.sqlProperties.getProperty("UPDATE_MARKED_MESSAGES_WITH_TX", this.UPDATE_MARKED_MESSAGES_WITH_TX);
        this.DELETE_MARKED_MESSAGES_WITH_TX = this.sqlProperties.getProperty("DELETE_MARKED_MESSAGES_WITH_TX", this.DELETE_MARKED_MESSAGES_WITH_TX);
        this.DELETE_TX = this.sqlProperties.getProperty("DELETE_TX", this.DELETE_TX);
        this.DELETE_MARKED_MESSAGES = this.sqlProperties.getProperty("DELETE_MARKED_MESSAGES", this.DELETE_MARKED_MESSAGES);
        this.DELETE_TEMPORARY_MESSAGES = this.sqlProperties.getProperty("DELETE_TEMPORARY_MESSAGES", this.DELETE_TEMPORARY_MESSAGES);
        this.INSERT_TX = this.sqlProperties.getProperty("INSERT_TX", this.INSERT_TX);
        this.SELECT_MAX_TX = this.sqlProperties.getProperty("SELECT_MAX_TX", this.SELECT_MAX_TX);
        this.SELECT_MESSAGES_IN_DEST = this.sqlProperties.getProperty("SELECT_MESSAGES_IN_DEST", this.SELECT_MESSAGES_IN_DEST);
        this.SELECT_MESSAGE = this.sqlProperties.getProperty("SELECT_MESSAGE", this.SELECT_MESSAGE);
        this.INSERT_MESSAGE = this.sqlProperties.getProperty("INSERT_MESSAGE", this.INSERT_MESSAGE);
        this.MARK_MESSAGE = this.sqlProperties.getProperty("MARK_MESSAGE", this.MARK_MESSAGE);
        this.DELETE_MESSAGE = this.sqlProperties.getProperty("DELETE_MESSAGE", this.DELETE_MESSAGE);
        this.UPDATE_MESSAGE = this.sqlProperties.getProperty("UPDATE_MESSAGE", this.UPDATE_MESSAGE);
        this.CREATE_MESSAGE_TABLE = this.sqlProperties.getProperty("CREATE_MESSAGE_TABLE", this.CREATE_MESSAGE_TABLE);
        this.CREATE_IDX_MESSAGE_TXOP_TXID = this.sqlProperties.getProperty("CREATE_IDX_MESSAGE_TXOP_TXID", this.CREATE_IDX_MESSAGE_TXOP_TXID);
        this.CREATE_IDX_MESSAGE_DESTINATION = this.sqlProperties.getProperty("CREATE_IDX_MESSAGE_DESTINATION", this.CREATE_IDX_MESSAGE_DESTINATION);
        this.CREATE_TX_TABLE = this.sqlProperties.getProperty("CREATE_TX_TABLE", this.CREATE_TX_TABLE);
        this.createTables = this.sqlProperties.getProperty("CREATE_TABLES_ON_STARTUP", "true").equalsIgnoreCase("true");
        String s = this.sqlProperties.getProperty("BLOB_TYPE", "OBJECT_BLOB");
        if (s.equals("OBJECT_BLOB")) {
            this.blobType = 0;
        } else if (s.equals("BYTES_BLOB")) {
            this.blobType = 1;
        } else if (s.equals("BINARYSTREAM_BLOB")) {
            this.blobType = 2;
        } else if (s.equals("BLOB_BLOB")) {
            this.blobType = 3;
        }
        String dsName = (String)this.getServer().getAttribute(this.connectionManagerName, "BindName");
        InitialContext ctx = new InitialContext();
        this.datasource = (DataSource)ctx.lookup(dsName);
        this.tm = (TransactionManager)ctx.lookup(TransactionManagerService.JNDI_NAME);
        this.log.debug((Object)"Resolving uncommited TXS");
        this.resolveAllUncommitedTXs();
    }

    public Object getInstance() {
        return this;
    }

    public ObjectName getMessageCache() {
        throw new UnsupportedOperationException("This is now set on the destination manager");
    }

    public void setMessageCache(ObjectName messageCache) {
        throw new UnsupportedOperationException("This is now set on the destination manager");
    }

    public ObjectName getConnectionManager() {
        return this.connectionManagerName;
    }

    public void setConnectionManager(ObjectName connectionManagerName) {
        this.connectionManagerName = connectionManagerName;
    }

    public MessageCache getMessageCacheInstance() {
        throw new UnsupportedOperationException("This is now set on the destination manager");
    }

    public String getSqlProperties() {
        try {
            ByteArrayOutputStream boa = new ByteArrayOutputStream();
            this.sqlProperties.store(boa, "");
            return new String(boa.toByteArray());
        }
        catch (IOException shouldnothappen) {
            return "";
        }
    }

    public void setSqlProperties(String value) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(value.getBytes());
            this.sqlProperties = new Properties();
            this.sqlProperties.load(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setConnectionRetryAttempts(int value) {
        this.connectionRetryAttempts = value;
    }

    public int getConnectionRetryAttempts() {
        return this.connectionRetryAttempts;
    }

    class TransactionManagerStrategy {
        Transaction threadTx;

        TransactionManagerStrategy() {
        }

        void startTX() throws JMSException {
            try {
                this.threadTx = PersistenceManager.this.tm.suspend();
                PersistenceManager.this.tm.begin();
            }
            catch (Exception e) {
                try {
                    if (this.threadTx != null) {
                        PersistenceManager.this.tm.resume(this.threadTx);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SpyJMSException("Could not start a transaction with the transaction manager.", e);
            }
        }

        void setRollbackOnly() throws JMSException {
            try {
                PersistenceManager.this.tm.setRollbackOnly();
            }
            catch (Exception e) {
                throw new SpyJMSException("Could not start a mark the transaction for rollback .", e);
            }
        }

        void endTX() throws JMSException {
            try {
                if (PersistenceManager.this.tm.getStatus() == 1) {
                    PersistenceManager.this.tm.rollback();
                } else {
                    PersistenceManager.this.tm.commit();
                }
            }
            catch (Exception e) {
                throw new SpyJMSException("Could not start a transaction with the transaction manager.", e);
            }
            finally {
                try {
                    if (this.threadTx != null) {
                        PersistenceManager.this.tm.resume(this.threadTx);
                    }
                }
                catch (Exception exception) {}
            }
        }
    }
}

