/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.message;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.jboss.axis.AxisFault;
import org.jboss.axis.NotImplementedException;
import org.jboss.axis.encoding.DeserializationContext;
import org.jboss.axis.message.RPCElement;
import org.jboss.axis.message.RPCParam;
import org.jboss.axis.message.SOAPElementAxisImpl;
import org.jboss.logging.Logger;
import org.w3c.dom.DOMException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RPCParamElementImpl
extends SOAPElementAxisImpl {
    private static Logger log = Logger.getLogger((String)RPCParamElementImpl.class.getName());
    private RPCElement rpcElement;
    private DeserializationContext context;

    public RPCParamElementImpl(String namespace, String localPart, String prefix, Attributes attributes, DeserializationContext context) throws AxisFault {
        super(namespace, localPart, prefix, attributes, context);
        SOAPElementAxisImpl curEl = context.getCurElement();
        if (curEl instanceof RPCParamElementImpl) {
            this.rpcElement = ((RPCParamElementImpl)curEl).rpcElement;
        }
        if (curEl instanceof RPCElement) {
            this.rpcElement = (RPCElement)curEl;
        }
        if (this.rpcElement == null) {
            IllegalArgumentException ex = new IllegalArgumentException("Unexpected element type: " + curEl.getClass().getName());
            log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        this.context = context;
    }

    public RPCParamElementImpl(RPCParam rpcParam) {
        super(rpcParam.getQName(), rpcParam.getValue());
        this.rpcElement = rpcParam.myCall;
        if (this.rpcElement == null) {
            IllegalArgumentException ex = new IllegalArgumentException("RPCParam has no parent element");
            log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        List<Class> supported = Arrays.asList(String.class, Integer.class, Float.class, Double.class, Long.class, Boolean.class, Short.class, Byte.class, BigInteger.class, BigDecimal.class);
        Object value = rpcParam.getValue();
        if (value != null) {
            try {
                if (supported.contains(value.getClass())) {
                    super.addTextNode(value.toString());
                } else {
                    log.debug((Object)("Cannot add text node for rpc parameter type: " + value.getClass().getName()));
                }
            }
            catch (SOAPException e) {
                log.error((Object)("Cannot addTextNode: " + value), (Throwable)e);
            }
        }
    }

    public Iterator getChildElements() {
        if (!this.hasChildNodes() && this.objectValue != null) {
            throw new NotImplementedException("SOAPElement view of RPCParam not implemented");
        }
        return super.getChildElements();
    }

    public Iterator getChildElements(Name name) {
        if (!this.hasChildNodes() && this.objectValue != null) {
            throw new NotImplementedException("SOAPElement view of RPCParam not implemented");
        }
        return super.getChildElements(name);
    }

    public SOAPElement addTextNode(String value) throws SOAPException {
        SOAPElement txtNode = super.addTextNode(value);
        this.setRPCParamValue(value);
        return txtNode;
    }

    public void setValue(String value) {
        super.setValue(value);
        this.setRPCParamValue(value);
    }

    public void setNodeValue(String value) throws DOMException {
        super.setNodeValue(value);
        this.setRPCParamValue(value);
    }

    private void setRPCParamValue(String newValue) {
        if (this.context == null || this.context.isDoneParsing()) {
            RPCParam rpcParam = this.getRPCParam();
            Object paramValue = rpcParam.getValue();
            if (paramValue != null && !paramValue.getClass().isAssignableFrom(newValue.getClass())) {
                log.warn((Object)("Trying to change the value type from " + paramValue.getClass().getName() + " to " + newValue.getClass().getName()));
            }
            rpcParam.setValue(newValue);
        }
    }

    private RPCParam getRPCParam() {
        RPCParam rpcParam = null;
        QName rpcParamElementName = this.getQName();
        ArrayList<QName> weHave = new ArrayList<QName>();
        try {
            Vector params = this.rpcElement.getParams();
            for (int i = 0; i < params.size(); ++i) {
                RPCParam aux = (RPCParam)params.elementAt(i);
                QName rpcParamName = aux.getQName();
                weHave.add(rpcParamName);
                if (!rpcParamName.equals(rpcParamElementName)) continue;
                if (rpcParam != null) {
                    log.error((Object)("Duplicate parameter: " + rpcParamName));
                    continue;
                }
                rpcParam = aux;
            }
        }
        catch (SAXException e) {
            log.error((Object)("Cannot get RPCParam " + rpcParamElementName), (Throwable)e);
        }
        if (rpcParam == null) {
            log.warn((Object)("Cannot find parameter: " + this.getQName() + " we have " + weHave));
        }
        return rpcParam;
    }
}

