/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import org.jacorb.idl.ConstExpr;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.TemplateTypeSpec;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.parser;

public class StringType
extends TemplateTypeSpec {
    public ConstExpr max = null;
    private int length = 0;
    private boolean wide = false;

    public StringType(int num) {
        super(num);
    }

    public boolean isWide() {
        return this.wide;
    }

    public void setWide() {
        this.wide = true;
    }

    public Object clone() {
        StringType s = new StringType(StringType.new_num());
        s.max = this.max;
        if (this.wide) {
            s.setWide();
        }
        s.parse();
        return s;
    }

    public String typeName() {
        return "java.lang.String";
    }

    public String getIDLTypeName() {
        return this.wide ? "wstring" : "string";
    }

    public TypeSpec typeSpec() {
        return this;
    }

    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
    }

    public void print(PrintWriter pw) {
    }

    public void setPackage(String s) {
        s = parser.pack_replace(s);
        if (this.max != null) {
            this.max.setPackage(s);
        }
    }

    public String toString() {
        return this.typeName();
    }

    public String holderName() {
        return "org.omg.CORBA.StringHolder";
    }

    public String getTypeCodeExpression() {
        if (this.wide) {
            return "org.omg.CORBA.ORB.init().create_wstring_tc(" + this.length + ")";
        }
        return "org.omg.CORBA.ORB.init().create_string_tc(" + this.length + ")";
    }

    public String printReadExpression(String strname) {
        if (this.wide) {
            return strname + ".read_wstring()";
        }
        return strname + ".read_string()";
    }

    public String printReadStatement(String var_name, String strname) {
        if (this.wide) {
            return var_name + "=" + strname + ".read_wstring();";
        }
        return var_name + "=" + strname + ".read_string();";
    }

    public String printWriteStatement(String var_name, String strname) {
        if (this.wide) {
            return strname + ".write_wstring(" + var_name + ");";
        }
        return strname + ".write_string(" + var_name + ");";
    }

    public String printInsertExpression() {
        if (this.wide) {
            return "insert_wstring";
        }
        return "insert_string";
    }

    public String printExtractExpression() {
        if (this.wide) {
            return "extract_wstring";
        }
        return "extract_string";
    }

    public void parse() {
        if (this.max != null) {
            this.length = this.max.pos_int_const();
        }
    }
}

