/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.jacorb.idl.ConstDecl;
import org.jacorb.idl.Environment;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.ParseException;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;

public class JacIDL
extends MatchingTask {
    private File _destdir;
    private File _srcdir;
    private Path _includepath;
    private int _debuglevel = 1;
    private boolean _generateir = false;
    private boolean _omgprefix;
    private boolean _generateincluded = false;
    private boolean _parseonly = false;
    private boolean _noskel = false;
    private boolean _nostub = false;
    private boolean _sloppyforward;
    private boolean _sloppynames;
    private boolean _includestate;
    private boolean _nofinal = false;
    private boolean _ami_callback = false;
    private boolean _force_overwrite = false;
    private boolean _unchecked_narrow = false;
    private List _defines = new ArrayList();
    private List _undefines = new ArrayList();
    private File[] _compileList = new File[0];
    private List _i2jpackages = new ArrayList();
    private I2JPackageTagHandler i2jHandler = new I2JPackageTagHandler();

    public JacIDL() {
        this._destdir = new File(".");
        this._srcdir = new File(".");
    }

    public void setDestdir(File dir) {
        this._destdir = dir;
    }

    public void setSrcdir(File dir) {
        this._srcdir = dir;
    }

    public void setIncludepath(Path path) {
        this._includepath = path;
    }

    public void setDebuglevel(int level) {
        this._debuglevel = level;
    }

    public void setGenerateir(boolean flag) {
        this._generateir = flag;
    }

    public void setOmgprefix(boolean flag) {
        this._omgprefix = flag;
    }

    public void setAll(boolean flag) {
        this._generateincluded = flag;
    }

    public void setParseonly(boolean flag) {
        this._parseonly = flag;
    }

    public void setNoskel(boolean flag) {
        this._noskel = flag;
    }

    public void setNostub(boolean flag) {
        this._nostub = flag;
    }

    public void setSloppyforward(boolean flag) {
        this._sloppyforward = flag;
    }

    public void setSloppynames(boolean flag) {
        this._sloppynames = flag;
    }

    public void setNofinal(boolean flag) {
        this._nofinal = flag;
    }

    public void setAmi_callback(boolean flag) {
        this._ami_callback = flag;
    }

    public void setForceOverwrite(boolean flag) {
        this._force_overwrite = flag;
    }

    public void setUncheckedNarrow(boolean flag) {
        this._unchecked_narrow = flag;
    }

    public void addDefine(Environment.Variable def) {
        this._defines.add(def);
    }

    public void addUndefine(Environment.Variable def) {
        this._undefines.add(def);
    }

    public I2JPackageTagHandler createI2jpackage() {
        return this.i2jHandler;
    }

    public void execute() throws BuildException {
        parser myparser = null;
        parser.init();
        if (!this._destdir.exists()) {
            this._destdir.mkdirs();
        }
        parser.out_dir = this._destdir.getPath();
        parser.generateIncluded = this._generateincluded;
        parser.generateIR = this._generateir;
        parser.parse_only = this._parseonly;
        parser.generate_skeletons = !this._noskel;
        parser.generate_stubs = !this._nostub;
        parser.sloppy = this._sloppyforward;
        parser.strict_names = !this._sloppynames;
        parser.setGenerateFinalCode(!this._nofinal);
        parser.generate_ami_callback = this._ami_callback;
        parser.forceOverwrite = this._force_overwrite;
        parser.useUncheckedNarrow = this._unchecked_narrow;
        if (this._includepath != null) {
            String[] includeList = this._includepath.list();
            for (int i = 0; i < includeList.length; ++i) {
                File incDir = this.project.resolveFile(includeList[i]);
                if (incDir.exists()) continue;
                throw new BuildException("include directory \"" + incDir.getPath() + "\" does not exist !", this.location);
            }
            GlobalInputStream.setIncludePath(this._includepath.toString());
        }
        if (this._omgprefix) {
            parser.package_prefix = "org.omg";
        }
        for (int i = 0; i < this._i2jpackages.size(); ++i) {
            parser.addI2JPackage((String)this._i2jpackages.get(i));
        }
        parser.getLogger().setPriority(Environment.intToPriority(this._debuglevel));
        this.resetFileLists();
        DirectoryScanner ds = this.getDirectoryScanner(this._srcdir);
        String[] files = ds.getIncludedFiles();
        this.scanFiles(files);
        try {
            if (this._compileList != null) {
                for (int i = 0; i < this._compileList.length; ++i) {
                    String fileName = this._compileList[i].getPath();
                    this.log("processing idl file: " + fileName);
                    GlobalInputStream.init();
                    GlobalInputStream.setInput(fileName);
                    lexer.reset();
                    NameTable.init();
                    ConstDecl.init();
                    TypeMap.init();
                    this.setupDefines();
                    myparser = new parser();
                    myparser.parse();
                }
            }
        }
        catch (IOException ex) {
            System.err.println(ex);
            throw new BuildException();
        }
        catch (ParseException ex) {
            System.err.println(ex);
            throw new BuildException();
        }
        catch (Exception ex) {
            System.err.println(ex);
            throw new BuildException();
        }
    }

    protected void resetFileLists() {
        this._compileList = new File[0];
    }

    protected void scanFiles(String[] files) throws BuildException {
        GlobPatternMapper m = new GlobPatternMapper();
        m.setFrom("*.idl");
        m.setTo("*.java");
        SourceFileScanner sfs = new SourceFileScanner((Task)this);
        File[] newfiles = sfs.restrictAsFiles(files, this._srcdir, this._destdir, (FileNameMapper)m);
        this._compileList = new File[newfiles.length];
        for (int i = 0; i < newfiles.length; ++i) {
            this.log("scan file: " + newfiles[i].getPath());
            File file = newfiles[i];
            if (!file.exists()) {
                throw new BuildException("The input file \"" + file.getPath() + "\" does not exist !");
            }
            this._compileList[i] = file;
        }
    }

    public File[] getFileList() {
        return this._compileList;
    }

    private static boolean fileExists(String filename) {
        if (filename == null || filename.length() == 0) {
            return false;
        }
        File file = new File(filename);
        return file.exists() && file.isFile();
    }

    private static boolean dirExists(File dir) {
        return dir.exists() && dir.isDirectory();
    }

    private void setupDefines() {
        Environment.Variable prop;
        int i;
        for (i = 0; i < this._defines.size(); ++i) {
            prop = (Environment.Variable)this._defines.get(i);
            String value = prop.getValue();
            if (value == null) {
                value = "1";
            }
            lexer.define(prop.getKey(), value);
        }
        for (i = 0; i < this._undefines.size(); ++i) {
            prop = (Environment.Variable)this._undefines.get(i);
            lexer.undefine(prop.getKey());
        }
    }

    public class I2JPackageTagHandler {
        public void setNames(String names) {
            JacIDL.this._i2jpackages.add(names);
        }
    }
}

