/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.ConstExpr;
import org.jacorb.idl.ConstType;
import org.jacorb.idl.Declaration;
import org.jacorb.idl.Environment;
import org.jacorb.idl.FixedPointConstType;
import org.jacorb.idl.FixedPointType;
import org.jacorb.idl.FloatType;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.IntType;
import org.jacorb.idl.Interface;
import org.jacorb.idl.LongLongType;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.OctetType;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.ShortType;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;

class ConstDecl
extends Declaration {
    private static Hashtable values = new Hashtable();
    private static Hashtable declarations = new Hashtable();
    private ScopedName t = new ScopedName(ConstDecl.new_num());
    private int pos_int_const = 0;
    private boolean int_const_set = false;
    public ConstExpr const_expr;
    public ConstType const_type;

    public ConstDecl(int num) {
        super(num);
    }

    public static void init() {
        values.clear();
        declarations.clear();
    }

    public static String namedValue(ScopedName sn) {
        String resolvedName = sn.resolvedName();
        if (values.containsKey(resolvedName)) {
            return (String)values.get(resolvedName);
        }
        return resolvedName;
    }

    public void setPackage(String s) {
        s = parser.pack_replace(s);
        super.setPackage(s);
        this.const_type.setPackage(s);
        this.const_expr.setPackage(s);
        this.t.typeName = this.name;
        this.t.setPackage(s);
    }

    public void parse() {
        this.const_expr.setDeclaration(this);
        try {
            NameTable.define(this.full_name(), "constant");
        }
        catch (NameAlreadyDefined p) {
            parser.error("Constant " + this.full_name() + " already defined", this.token);
        }
        this.const_type.parse();
        this.const_expr.parse();
        this.t.typeName = this.name;
        values.put(this.t.resolvedName() + (this.contained() ? "" : ".value"), this.const_expr.value());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ConstDecl.parse, put value: " + this.t.resolvedName() + (this.contained() ? "" : ".value") + " , " + this.const_expr.value());
        }
        declarations.put(this.t.resolvedName(), this);
    }

    static ConstDecl getDeclaration(String resolvedName) {
        return (ConstDecl)declarations.get(resolvedName);
    }

    int pos_int_const() {
        if (!this.int_const_set) {
            this.pos_int_const = this.const_expr.pos_int_const();
            this.int_const_set = true;
        }
        return this.pos_int_const;
    }

    public void printContained(PrintWriter ps) {
        TypeSpec ts = this.const_type.symbol.typeSpec();
        boolean alias = ts instanceof AliasTypeSpec;
        if (ts instanceof AliasTypeSpec) {
            ts = ((AliasTypeSpec)ts).originalType();
        }
        ps.print("\t" + this.const_type + " " + this.name + " = ");
        if (ts instanceof IntType && ((IntType)ts).type_spec instanceof ShortType) {
            ps.print("(short)(");
            this.const_expr.print(ps);
            ps.println(");");
        } else if (ts instanceof LongLongType) {
            ps.print(this.const_expr.toString() + ';');
        } else if (ts instanceof FloatType) {
            ps.print("(float)(");
            this.const_expr.print(ps);
            ps.println(");");
        } else if (ts instanceof FixedPointConstType) {
            ps.print("new java.math.BigDecimal(");
            this.const_expr.print(ps);
            ps.println(");");
        } else if (ts instanceof OctetType) {
            ps.print("(byte)(");
            this.const_expr.print(ps);
            ps.println(");");
        } else {
            this.const_expr.print(ps);
            ps.println(";");
        }
    }

    boolean contained() {
        boolean result = false;
        for (IdlSymbol enc = this.getEnclosingSymbol(); enc != null; enc = enc.getEnclosingSymbol()) {
            if (!(enc instanceof Interface)) continue;
            result = true;
            break;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ConstDecl.contained()? " + this.full_name() + " returns " + result);
        }
        return result;
    }

    public void print(PrintWriter ps) {
        if (this.contained() || this.included && !this.generateIncluded()) {
            return;
        }
        try {
            String fname;
            File f;
            String className;
            String fullName = ScopedName.unPseudoName(this.full_name());
            if (fullName.indexOf(46) > 0) {
                this.pack_name = fullName.substring(0, fullName.lastIndexOf(46));
                className = fullName.substring(fullName.lastIndexOf(46) + 1);
            } else {
                this.pack_name = "";
                className = fullName;
            }
            String path = parser.out_dir + fileSeparator + this.pack_name.replace('.', fileSeparator);
            File dir = new File(path);
            if (!dir.exists() && !dir.mkdirs()) {
                parser.fatal_error("Unable to create " + path, null);
            }
            if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + ".java"))) {
                PrintWriter pw = new PrintWriter(new FileWriter(f));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ConstDecl.print " + fname);
                }
                if (Environment.JAVA14 && this.pack_name.equals("")) {
                    lexer.emit_warn("No package defined for " + className + " - illegal in JDK1.4", this.token);
                }
                if (!this.pack_name.equals("")) {
                    pw.println("package " + this.pack_name + ";");
                }
                pw.println("/**");
                pw.println(" * Automatically generated from IDL const definition ");
                pw.println(" * @author JacORB IDL compiler ");
                pw.println(" */\n");
                pw.println("public interface " + className);
                pw.println("{");
                TypeSpec ts = this.const_type.symbol.typeSpec();
                if (ts instanceof AliasTypeSpec) {
                    ts = ((AliasTypeSpec)ts).originalType();
                }
                pw.print("\t" + this.const_type.toString() + " value = ");
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("ConstDecl, ts " + this.const_type.toString() + " " + ts.getClass());
                }
                if (ts instanceof ShortType) {
                    pw.print("(short)(" + this.const_expr.toString() + ");");
                } else if (ts instanceof LongLongType) {
                    pw.print(this.const_expr.toString() + ';');
                } else if (ts instanceof FloatType) {
                    pw.println("(float)(" + this.const_expr.toString() + ");");
                } else if (ts instanceof OctetType) {
                    pw.println("(byte)(" + this.const_expr.toString() + ");");
                } else if (ts instanceof FixedPointConstType || ts instanceof FixedPointType) {
                    pw.println("new java.math.BigDecimal (" + this.const_expr.toString() + ");");
                } else {
                    pw.println(this.const_expr.toString() + ";");
                }
                pw.println("}");
                pw.close();
            }
        }
        catch (IOException i) {
            throw new RuntimeException("File IO error" + i);
        }
    }
}

