/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tabbedpane;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.custom.tabbedpane.HtmlPanelTab;
import org.apache.myfaces.custom.tabbedpane.HtmlPanelTabbedPane;
import org.apache.myfaces.custom.tabbedpane.TabChangeEvent;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HTML;
import org.apache.myfaces.renderkit.html.HtmlRenderer;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;

public class HtmlTabbedPaneRenderer
extends HtmlRenderer {
    private static final String TABLE_STYLE = "border-style: none; padding: 0px; border-spacing: 0px; empty-cells: show; ";
    private static final String ACTIVE_HEADER_CELL_STYLE = "border-top: 2px outset #CCCCCC; border-right: 2px outset #CCCCCC; border-bottom: 0px none; border-left: 2px outset #CCCCCC; text-align: center; ";
    private static final String INACTIVE_HEADER_CELL_STYLE = "border-top: 1px outset #CCCCCC; border-right: 1px outset #CCCCCC; border-bottom: 0px none; border-left: 1px outset #CCCCCC; text-align: center; background-color: #CCCCCC; ";
    private static final String EMPTY_HEADER_CELL_STYLE = "border-top: 0px none; border-right: 0px none; border-bottom: 0px none; border-left: 0px none; ";
    private static final String SUB_HEADER_CELL_STYLE = "height: 2px; line-height: 0px; font-size: 0px; border-bottom: 0px none; ";
    private static final String TAB_CELL_STYLE = "border-top: 0px none; border-right: 2px outset #CCCCCC; border-bottom: 2px outset #CCCCCC; border-left: 2px outset #CCCCCC; padding: 10px; ";
    private static final String NO_BORDER_STYLE = "0px none; ";
    private static final String BORDER_STYLE = "2px outset #CCCCCC; ";
    private static final String BUTTON_STYLE_ACTIVE = "border-style:none; width:100%; cursor:pointer;";
    private static final String BUTTON_STYLE_INACTIVE = "border-style:none; width:100%; cursor:pointer; background-color:#CCCCCC;";
    private static final String BUTTON_STYLE_DISABLED = "border-style:none; width:100%; cursor:normal;";
    private static final String DEFAULT_BG_COLOR = "#FFFFFF";
    private static final String AUTO_FORM_SUFFIX = ".autoform";
    static /* synthetic */ Class class$org$apache$myfaces$custom$tabbedpane$HtmlPanelTabbedPane;

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facescontext, UIComponent uicomponent) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UIForm parentForm;
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$org$apache$myfaces$custom$tabbedpane$HtmlPanelTabbedPane == null ? (class$org$apache$myfaces$custom$tabbedpane$HtmlPanelTabbedPane = HtmlTabbedPaneRenderer.class$("org.apache.myfaces.custom.tabbedpane.HtmlPanelTabbedPane")) : class$org$apache$myfaces$custom$tabbedpane$HtmlPanelTabbedPane);
        ResponseWriter writer = facesContext.getResponseWriter();
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        HtmlPanelTabbedPane tabbedPane = (HtmlPanelTabbedPane)uiComponent;
        int selectedIndex = tabbedPane.getSelectedIndex();
        if (tabbedPane.getBgcolor() == null) {
            tabbedPane.setBgcolor(DEFAULT_BG_COLOR);
        }
        if ((parentForm = RendererUtils.findParentForm(tabbedPane)) == null) {
            this.writeFormStart(writer, facesContext, tabbedPane);
        }
        this.writeTableStart(writer, facesContext, tabbedPane);
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", uiComponent);
        int tabIdx = 0;
        int visibleTabCount = 0;
        int visibleTabSelectedIdx = -1;
        List children = tabbedPane.getChildren();
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            UIComponent child = this.getUIComponent((UIComponent)children.get(i));
            if (!(child instanceof HtmlPanelTab)) continue;
            if (child.isRendered()) {
                this.writeHeaderCell(writer, facesContext, tabbedPane, (HtmlPanelTab)child, tabIdx, tabIdx == selectedIndex, this.isDisabled(facesContext, child));
                if (tabIdx == selectedIndex) {
                    visibleTabSelectedIdx = visibleTabCount;
                }
                ++visibleTabCount;
            }
            ++tabIdx;
        }
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        HtmlRendererUtils.writePrettyIndent(facesContext);
        writer.startElement("td", uiComponent);
        writer.writeAttribute("style", EMPTY_HEADER_CELL_STYLE, null);
        writer.write("&#160;");
        writer.endElement("td");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.endElement("tr");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", uiComponent);
        this.writeSubHeaderCells(writer, facesContext, tabbedPane, visibleTabCount, visibleTabSelectedIdx, false);
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.endElement("tr");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", uiComponent);
        this.writeTabCell(writer, facesContext, tabbedPane, visibleTabCount, selectedIndex);
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.endElement("tr");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.endElement("table");
        if (parentForm == null) {
            this.writeFormEnd(writer, facesContext);
        }
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$org$apache$myfaces$custom$tabbedpane$HtmlPanelTabbedPane == null ? (class$org$apache$myfaces$custom$tabbedpane$HtmlPanelTabbedPane = HtmlTabbedPaneRenderer.class$("org.apache.myfaces.custom.tabbedpane.HtmlPanelTabbedPane")) : class$org$apache$myfaces$custom$tabbedpane$HtmlPanelTabbedPane);
        HtmlPanelTabbedPane tabbedPane = (HtmlPanelTabbedPane)uiComponent;
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        int tabIdx = 0;
        List children = tabbedPane.getChildren();
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            UIComponent child = this.getUIComponent((UIComponent)children.get(i));
            if (!(child instanceof HtmlPanelTab)) continue;
            String paramName = tabbedPane.getClientId(facesContext) + "." + tabIdx;
            String paramValue = (String)paramMap.get(paramName);
            if (paramValue != null && paramValue.length() > 0) {
                tabbedPane.queueEvent(new TabChangeEvent(tabbedPane, tabbedPane.getSelectedIndex(), tabIdx));
                return;
            }
            ++tabIdx;
        }
    }

    protected void writeFormStart(ResponseWriter writer, FacesContext facesContext, UIComponent tabbedPane) throws IOException {
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        String viewId = facesContext.getViewRoot().getViewId();
        String actionURL = viewHandler.getActionURL(facesContext, viewId);
        writer.startElement("form", null);
        writer.writeAttribute("name", tabbedPane.getClientId(facesContext) + AUTO_FORM_SUFFIX, null);
        writer.writeAttribute("style", "display:inline", null);
        writer.writeAttribute("method", "post", null);
        writer.writeURIAttribute("action", facesContext.getExternalContext().encodeActionURL(actionURL), null);
        writer.flush();
    }

    protected void writeTableStart(ResponseWriter writer, FacesContext facesContext, HtmlPanelTabbedPane tabbedPane) throws IOException {
        String oldStyle = tabbedPane.getStyle();
        if (oldStyle == null) {
            tabbedPane.setStyle(TABLE_STYLE);
        } else {
            tabbedPane.setStyle("border-style: none; padding: 0px; border-spacing: 0px; empty-cells: show; ; " + oldStyle);
        }
        String oldBgColor = tabbedPane.getBgcolor();
        tabbedPane.setBgcolor(null);
        writer.startElement("table", tabbedPane);
        writer.writeAttribute("cellspacing", "0", null);
        HtmlRendererUtils.renderHTMLAttributes(writer, tabbedPane, HTML.TABLE_PASSTHROUGH_ATTRIBUTES);
        writer.flush();
        tabbedPane.setStyle(oldStyle);
        tabbedPane.setBgcolor(oldBgColor);
    }

    protected void writeHeaderCell(ResponseWriter writer, FacesContext facesContext, HtmlPanelTabbedPane tabbedPane, HtmlPanelTab tab, int tabIndex, boolean active, boolean disabled) throws IOException {
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        HtmlRendererUtils.writePrettyIndent(facesContext);
        writer.startElement("td", tabbedPane);
        if (active) {
            writer.writeAttribute("style", "border-top: 2px outset #CCCCCC; border-right: 2px outset #CCCCCC; border-bottom: 0px none; border-left: 2px outset #CCCCCC; text-align: center; background-color:" + tabbedPane.getBgcolor(), null);
            HtmlRendererUtils.renderHTMLAttribute(writer, tabbedPane, "activeTabStyleClass", "styleClass");
        } else if (disabled) {
            writer.writeAttribute("style", INACTIVE_HEADER_CELL_STYLE, null);
            HtmlRendererUtils.renderHTMLAttribute(writer, tabbedPane, "disabledTabStyleClass", "styleClass");
        } else {
            writer.writeAttribute("style", INACTIVE_HEADER_CELL_STYLE, null);
            HtmlRendererUtils.renderHTMLAttribute(writer, tabbedPane, "inactiveTabStyleClass", "styleClass");
        }
        String label = tab.getLabel();
        if (label == null || label.length() == 0) {
            label = "Tab " + tabIndex;
        }
        if (disabled) {
            writer.startElement("label", tabbedPane);
            writer.writeAttribute("name", tabbedPane.getClientId(facesContext) + "." + tabIndex, null);
            writer.writeAttribute("style", BUTTON_STYLE_DISABLED, null);
            writer.writeText(label, null);
            writer.endElement("label");
        } else {
            writer.startElement("input", tabbedPane);
            writer.writeAttribute("type", "submit", null);
            writer.writeAttribute("name", tabbedPane.getClientId(facesContext) + "." + tabIndex, null);
            writer.writeAttribute("value", label, null);
            if (active) {
                writer.writeAttribute("style", "border-style:none; width:100%; cursor:pointer;background-color:" + tabbedPane.getBgcolor(), null);
            } else {
                writer.writeAttribute("style", BUTTON_STYLE_INACTIVE, null);
            }
            writer.endElement("input");
        }
        writer.endElement("td");
    }

    protected void writeSubHeaderCells(ResponseWriter writer, FacesContext facesContext, HtmlPanelTabbedPane tabbedPane, int visibleTabCount, int visibleTabSelectedIndex, boolean disabled) throws IOException {
        StringBuffer buf = new StringBuffer();
        int cnt = visibleTabCount + 1;
        for (int i = 0; i < cnt; ++i) {
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            HtmlRendererUtils.writePrettyIndent(facesContext);
            writer.startElement("td", tabbedPane);
            buf.setLength(0);
            buf.append(SUB_HEADER_CELL_STYLE);
            buf.append("border-top:").append(i == visibleTabSelectedIndex ? NO_BORDER_STYLE : BORDER_STYLE);
            buf.append("border-right:").append(i + 1 < cnt ? NO_BORDER_STYLE : BORDER_STYLE);
            buf.append("border-left:").append(i > 0 ? NO_BORDER_STYLE : BORDER_STYLE);
            buf.append("background-color:").append(tabbedPane.getBgcolor());
            writer.writeAttribute("style", buf.toString(), null);
            if (i == visibleTabSelectedIndex) {
                HtmlRendererUtils.renderHTMLAttribute(writer, tabbedPane, "activeSubStyleClass", "styleClass");
            } else {
                HtmlRendererUtils.renderHTMLAttribute(writer, tabbedPane, "inactiveSubStyleClass", "styleClass");
            }
            writer.write("&#160;");
            writer.endElement("td");
        }
    }

    protected void writeTabCell(ResponseWriter writer, FacesContext facesContext, HtmlPanelTabbedPane tabbedPane, int tabCount, int selectedIndex) throws IOException {
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        HtmlRendererUtils.writePrettyIndent(facesContext);
        writer.startElement("td", tabbedPane);
        writer.writeAttribute("colspan", Integer.toString(tabCount + 1), null);
        writer.writeAttribute("style", "border-top: 0px none; border-right: 2px outset #CCCCCC; border-bottom: 2px outset #CCCCCC; border-left: 2px outset #CCCCCC; padding: 10px; background-color:" + tabbedPane.getBgcolor(), null);
        HtmlRendererUtils.renderHTMLAttribute(writer, tabbedPane, "tabContentStyleClass", "styleClass");
        int tabIdx = 0;
        List children = tabbedPane.getChildren();
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            UIComponent child = this.getUIComponent((UIComponent)children.get(i));
            if (child instanceof HtmlPanelTab) {
                if (tabIdx == selectedIndex) {
                    RendererUtils.renderChild(facesContext, child);
                }
                ++tabIdx;
                continue;
            }
            RendererUtils.renderChild(facesContext, child);
        }
        writer.endElement("td");
    }

    private UIComponent getUIComponent(UIComponent uiComponent) {
        if (uiComponent instanceof UIForm || uiComponent instanceof UINamingContainer) {
            List children = uiComponent.getChildren();
            int len = children.size();
            for (int i = 0; i < len; ++i) {
                uiComponent = this.getUIComponent((UIComponent)children.get(i));
            }
        }
        return uiComponent;
    }

    protected void writeFormEnd(ResponseWriter writer, FacesContext facesContext) throws IOException {
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        viewHandler.writeState(facesContext);
        writer.endElement("form");
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        return !UserRoleUtils.isEnabledOnUserRole(uiComponent);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

