/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.html.ext;

import java.io.IOException;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.model.DataModel;
import javax.faces.render.Renderer;
import javax.servlet.jsp.jstl.sql.Result;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.UIColumns;
import org.apache.myfaces.component.UserRoleAware;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.component.html.ext.HtmlDataTableHack;
import org.apache.myfaces.component.html.ext._SerializableArrayDataModel;
import org.apache.myfaces.component.html.ext._SerializableDataModel;
import org.apache.myfaces.component.html.ext._SerializableListDataModel;
import org.apache.myfaces.component.html.ext._SerializableResultDataModel;
import org.apache.myfaces.component.html.ext._SerializableResultSetDataModel;
import org.apache.myfaces.component.html.ext._SerializableScalarDataModel;

public class HtmlDataTable
extends HtmlDataTableHack
implements UserRoleAware {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$component$html$ext$HtmlDataTable == null ? (class$org$apache$myfaces$component$html$ext$HtmlDataTable = HtmlDataTable.class$("org.apache.myfaces.component.html.ext.HtmlDataTable")) : class$org$apache$myfaces$component$html$ext$HtmlDataTable));
    private static final int PROCESS_DECODES = 1;
    private static final int PROCESS_VALIDATORS = 2;
    private static final int PROCESS_UPDATES = 3;
    private static final boolean DEFAULT_SORTASCENDING = true;
    private static final Class OBJECT_ARRAY_CLASS = new Object[0].getClass();
    private transient boolean _isDataModelRestored = false;
    private transient boolean _firstTimeRendered = true;
    private String _sortColumn = null;
    private Boolean _sortAscending = null;
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlDataTable";
    private static final boolean DEFAULT_PRESERVEDATAMODEL = false;
    private static final boolean DEFAULT_PRESERVESORT = true;
    private static final boolean DEFAULT_RENDEREDIFEMPTY = true;
    private Boolean _preserveDataModel = null;
    private Boolean _preserveSort = null;
    private String _enabledOnUserRole = null;
    private String _visibleOnUserRole = null;
    private Boolean _renderedIfEmpty = null;
    private String _rowIndexVar = null;
    private String _rowCountVar = null;
    private String _previousRowDataVar = null;
    static /* synthetic */ Class class$org$apache$myfaces$component$html$ext$HtmlDataTable;
    static /* synthetic */ Class class$javax$faces$model$DataModel;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$sql$ResultSet;

    public void setValue(Object value) {
        this._dataModel = null;
        this._isDataModelRestored = false;
        super.setValue(value);
    }

    public void setRowIndex(int rowIndex) {
        String rowIndexVar = this.getRowIndexVar();
        String rowCountVar = this.getRowCountVar();
        String previousRowDataVar = this.getPreviousRowDataVar();
        if (rowIndexVar != null || rowCountVar != null || previousRowDataVar != null) {
            Map requestMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
            if (previousRowDataVar != null && rowIndex >= 0) {
                if (this.isRowAvailable()) {
                    requestMap.put(previousRowDataVar, this.getRowData());
                } else {
                    requestMap.put(previousRowDataVar, null);
                }
            }
            super.setRowIndex(rowIndex);
            if (rowIndex >= 0) {
                if (rowIndexVar != null) {
                    requestMap.put(rowIndexVar, new Integer(rowIndex));
                }
                if (rowCountVar != null) {
                    requestMap.put(rowCountVar, new Integer(this.getRowCount()));
                }
            } else {
                if (rowIndexVar != null) {
                    requestMap.remove(rowIndexVar);
                }
                if (rowCountVar != null) {
                    requestMap.remove(rowCountVar);
                }
                if (previousRowDataVar != null) {
                    requestMap.remove(previousRowDataVar);
                }
            }
        } else {
            super.setRowIndex(rowIndex);
        }
    }

    public void processRestoreState(FacesContext context, Object state) {
        super.processRestoreState(context, state);
    }

    public void processDecodes(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        super.processDecodes(context);
        this.setRowIndex(-1);
        this.processColumnsFacets(context, 1);
        this.processColumnsChildren(context, 1);
        this.setRowIndex(-1);
    }

    private void processColumnsChildren(FacesContext context, int processAction) {
        int first = this.getFirst();
        int rows = this.getRows();
        int last = rows == 0 ? this.getRowCount() : first + rows;
        for (int rowIndex = first; rowIndex < last; ++rowIndex) {
            this.setRowIndex(rowIndex);
            if (!this.isRowAvailable()) continue;
            Iterator it = this.getChildren().iterator();
            while (it.hasNext()) {
                UIComponent child = (UIComponent)it.next();
                if (!(child instanceof UIColumns) || !child.isRendered()) continue;
                UIColumns columns = (UIColumns)child;
                int size = columns.getRowCount();
                for (int colIndex = 0; colIndex < size; ++colIndex) {
                    columns.setRowIndex(colIndex);
                    Iterator columnChildIter = child.getChildren().iterator();
                    while (columnChildIter.hasNext()) {
                        UIComponent columnChild = (UIComponent)columnChildIter.next();
                        this.process(context, columnChild, processAction);
                    }
                }
                columns.setRowIndex(-1);
            }
        }
    }

    private void processColumnsFacets(FacesContext context, int processAction) {
        Iterator childIter = this.getChildren().iterator();
        while (childIter.hasNext()) {
            UIComponent child = (UIComponent)childIter.next();
            if (!(child instanceof UIColumns) || !child.isRendered()) continue;
            UIColumns columns = (UIColumns)child;
            int size = columns.getRowCount();
            for (int i = 0; i < size; ++i) {
                columns.setRowIndex(i);
                Iterator facetsIter = child.getFacets().values().iterator();
                while (facetsIter.hasNext()) {
                    UIComponent facet = (UIComponent)facetsIter.next();
                    this.process(context, facet, processAction);
                }
            }
            columns.setRowIndex(-1);
        }
    }

    private void process(FacesContext context, UIComponent component, int processAction) {
        switch (processAction) {
            case 1: {
                component.processDecodes(context);
                break;
            }
            case 2: {
                component.processValidators(context);
                break;
            }
            case 3: {
                component.processUpdates(context);
            }
        }
    }

    public void processValidators(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        super.processValidators(context);
        this.setRowIndex(-1);
        this.processColumnsFacets(context, 2);
        this.processColumnsChildren(context, 2);
        this.setRowIndex(-1);
    }

    public Object processSaveState(FacesContext context) {
        return super.processSaveState(context);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
    }

    public void processUpdates(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(context);
        this.setRowIndex(-1);
        this.processColumnsFacets(context, 3);
        this.processColumnsChildren(context, 3);
        this.setRowIndex(-1);
        if (this._isDataModelRestored) {
            this.updateModelFromPreservedDataModel(context);
        }
        if (this.isPreserveSort()) {
            ValueBinding vb;
            if (this._sortColumn != null && (vb = this.getValueBinding("sortColumn")) != null) {
                vb.setValue(context, this._sortColumn);
                this._sortColumn = null;
            }
            if (this._sortAscending != null && (vb = this.getValueBinding("sortAscending")) != null) {
                vb.setValue(context, this._sortAscending);
                this._sortAscending = null;
            }
        }
    }

    private void updateModelFromPreservedDataModel(FacesContext context) {
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null && !vb.isReadOnly(context)) {
            Class type;
            _SerializableDataModel dm = (_SerializableDataModel)this._dataModel;
            if ((class$javax$faces$model$DataModel == null ? (class$javax$faces$model$DataModel = HtmlDataTable.class$("javax.faces.model.DataModel")) : class$javax$faces$model$DataModel).isAssignableFrom(type = vb.getType(context))) {
                vb.setValue(context, dm);
            } else if ((class$java$util$List == null ? (class$java$util$List = HtmlDataTable.class$("java.util.List")) : class$java$util$List).isAssignableFrom(type)) {
                vb.setValue(context, (List)dm.getWrappedData());
            } else if (OBJECT_ARRAY_CLASS.isAssignableFrom(type)) {
                List lst = (List)dm.getWrappedData();
                vb.setValue(context, lst.toArray(new Object[lst.size()]));
            } else {
                if ((class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = HtmlDataTable.class$("java.sql.ResultSet")) : class$java$sql$ResultSet).isAssignableFrom(type)) {
                    throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
                }
                List lst = (List)dm.getWrappedData();
                if (lst.size() > 0) {
                    vb.setValue(context, lst.get(0));
                } else {
                    vb.setValue(context, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAllChildrenAndFacetsValid() {
        int first = this.getFirst();
        int rows = this.getRows();
        int last = rows == 0 ? this.getRowCount() : first + rows;
        try {
            for (int rowIndex = first; rowIndex < last; ++rowIndex) {
                this.setRowIndex(rowIndex);
                if (!this.isRowAvailable() || this.isAllEditableValueHoldersValidRecursive(this.getFacetsAndChildren())) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.setRowIndex(-1);
        }
        return true;
    }

    private boolean isAllEditableValueHoldersValidRecursive(Iterator facetsAndChildrenIterator) {
        while (facetsAndChildrenIterator.hasNext()) {
            UIComponent c = (UIComponent)facetsAndChildrenIterator.next();
            if (c instanceof EditableValueHolder && !((EditableValueHolder)((Object)c)).isValid()) {
                return false;
            }
            if (this.isAllEditableValueHoldersValidRecursive(c.getFacetsAndChildren())) continue;
            return false;
        }
        return true;
    }

    protected void refresh(FacesContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Refresh for HtmlDataTable " + this.getClientId(context) + " was called"));
        }
        if (this._firstTimeRendered || this.isAllChildrenAndFacetsValid()) {
            this._dataModel = null;
            if (this._dataModelMap != null) {
                this._dataModelMap.clear();
            }
            this._isDataModelRestored = false;
            this._saveDescendantStates = false;
        } else {
            this._saveDescendantStates = true;
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (this.isRenderedIfEmpty() || this.getRowCount() > 0) {
            if (context == null) {
                throw new NullPointerException("context");
            }
            if (!this.isRendered()) {
                return;
            }
            Renderer renderer = this.getRenderer(context);
            if (renderer != null) {
                renderer.encodeBegin(context, this);
            }
        }
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (this.isRenderedIfEmpty() || this.getRowCount() > 0) {
            super.encodeChildren(context);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (this.isRenderedIfEmpty() || this.getRowCount() > 0) {
            super.encodeEnd(context);
        }
    }

    public int getFirst() {
        if (this._isDataModelRestored) {
            return ((_SerializableDataModel)this._dataModel).getFirst();
        }
        return super.getFirst();
    }

    public void setFirst(int first) {
        if (this._isDataModelRestored) {
            ((_SerializableDataModel)this._dataModel).setFirst(first);
        }
        super.setFirst(first);
    }

    public int getRows() {
        if (this._isDataModelRestored) {
            return ((_SerializableDataModel)this._dataModel).getRows();
        }
        return super.getRows();
    }

    public void setRows(int rows) {
        if (this._isDataModelRestored) {
            ((_SerializableDataModel)this._dataModel).setRows(rows);
        }
        super.setRows(rows);
    }

    public Object saveState(FacesContext context) {
        boolean preserveSort = this.isPreserveSort();
        Object[] values = new Object[]{super.saveState(context), this._preserveDataModel, this.isPreserveDataModel() ? HtmlDataTable.saveAttachedState(context, this.getSerializableDataModel()) : null, this._preserveSort, preserveSort ? this.getSortColumn() : this._sortColumn, preserveSort ? Boolean.valueOf(this.isSortAscending()) : this._sortAscending, this._renderedIfEmpty, this._rowCountVar, this._rowIndexVar};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._preserveDataModel = (Boolean)values[1];
        if (this.isPreserveDataModel()) {
            this._dataModel = (_SerializableDataModel)HtmlDataTable.restoreAttachedState(context, values[2]);
            this._isDataModelRestored = true;
        } else {
            this._dataModel = null;
            this._isDataModelRestored = false;
        }
        this._preserveSort = (Boolean)values[3];
        this._sortColumn = (String)values[4];
        this._sortAscending = (Boolean)values[5];
        this._renderedIfEmpty = (Boolean)values[6];
        this._rowCountVar = (String)values[7];
        this._rowIndexVar = (String)values[8];
        this._firstTimeRendered = false;
    }

    public _SerializableDataModel getSerializableDataModel() {
        if (this._dataModel != null) {
            if (this._dataModel instanceof _SerializableDataModel) {
                return (_SerializableDataModel)this._dataModel;
            }
            return new _SerializableDataModel(this.getFirst(), this.getRows(), this._dataModel);
        }
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof DataModel) {
            return new _SerializableDataModel(this.getFirst(), this.getRows(), (DataModel)value);
        }
        if (value instanceof List) {
            return new _SerializableListDataModel(this.getFirst(), this.getRows(), (List)value);
        }
        if (OBJECT_ARRAY_CLASS.isAssignableFrom(value.getClass())) {
            return new _SerializableArrayDataModel(this.getFirst(), this.getRows(), (Object[])value);
        }
        if (value instanceof ResultSet) {
            return new _SerializableResultSetDataModel(this.getFirst(), this.getRows(), (ResultSet)value);
        }
        if (value instanceof Result) {
            return new _SerializableResultDataModel(this.getFirst(), this.getRows(), (Result)value);
        }
        return new _SerializableScalarDataModel(this.getFirst(), this.getRows(), value);
    }

    public boolean isRendered() {
        if (!UserRoleUtils.isVisibleOnUserRole(this)) {
            return false;
        }
        return super.isRendered();
    }

    public void setSortColumn(String sortColumn) {
        this._sortColumn = sortColumn;
        ValueBinding vb = this.getValueBinding("sortColumn");
        if (vb != null) {
            vb.setValue(this.getFacesContext(), this._sortColumn);
            this._sortColumn = null;
        }
    }

    public String getSortColumn() {
        if (this._sortColumn != null) {
            return this._sortColumn;
        }
        ValueBinding vb = this.getValueBinding("sortColumn");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setSortAscending(boolean sortAscending) {
        this._sortAscending = sortAscending;
        ValueBinding vb = this.getValueBinding("sortAscending");
        if (vb != null) {
            vb.setValue(this.getFacesContext(), this._sortAscending);
            this._sortAscending = null;
        }
    }

    public boolean isSortAscending() {
        if (this._sortAscending != null) {
            return this._sortAscending;
        }
        ValueBinding vb = this.getValueBinding("sortAscending");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : true;
    }

    public void setPreserveDataModel(boolean preserveDataModel) {
        this._preserveDataModel = preserveDataModel;
    }

    public boolean isPreserveDataModel() {
        if (this._preserveDataModel != null) {
            return this._preserveDataModel;
        }
        ValueBinding vb = this.getValueBinding("preserveDataModel");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : false;
    }

    public void setPreserveSort(boolean preserveSort) {
        this._preserveSort = preserveSort;
    }

    public boolean isPreserveSort() {
        if (this._preserveSort != null) {
            return this._preserveSort;
        }
        ValueBinding vb = this.getValueBinding("preserveSort");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : true;
    }

    public void setEnabledOnUserRole(String enabledOnUserRole) {
        this._enabledOnUserRole = enabledOnUserRole;
    }

    public String getEnabledOnUserRole() {
        if (this._enabledOnUserRole != null) {
            return this._enabledOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("enabledOnUserRole");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setVisibleOnUserRole(String visibleOnUserRole) {
        this._visibleOnUserRole = visibleOnUserRole;
    }

    public String getVisibleOnUserRole() {
        if (this._visibleOnUserRole != null) {
            return this._visibleOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("visibleOnUserRole");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setRenderedIfEmpty(boolean renderedIfEmpty) {
        this._renderedIfEmpty = renderedIfEmpty;
    }

    public boolean isRenderedIfEmpty() {
        if (this._renderedIfEmpty != null) {
            return this._renderedIfEmpty;
        }
        ValueBinding vb = this.getValueBinding("renderedIfEmpty");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : true;
    }

    public void setRowIndexVar(String rowIndexVar) {
        this._rowIndexVar = rowIndexVar;
    }

    public String getRowIndexVar() {
        if (this._rowIndexVar != null) {
            return this._rowIndexVar;
        }
        ValueBinding vb = this.getValueBinding("rowIndexVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setRowCountVar(String rowCountVar) {
        this._rowCountVar = rowCountVar;
    }

    public String getRowCountVar() {
        if (this._rowCountVar != null) {
            return this._rowCountVar;
        }
        ValueBinding vb = this.getValueBinding("rowCountVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setPreviousRowDataVar(String previousRowDataVar) {
        this._previousRowDataVar = previousRowDataVar;
    }

    public String getPreviousRowDataVar() {
        if (this._previousRowDataVar != null) {
            return this._previousRowDataVar;
        }
        ValueBinding vb = this.getValueBinding("previousRowDataVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

