/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.functions;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.functions.Function;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;

public class FuncPosition
extends Function {
    public XObject execute(XPathContext xPathContext) throws TransformerException {
        double d = this.getPositionInContextNodeList(xPathContext);
        return new XNumber(d);
    }

    public void fixupVariables(Vector vector, int n) {
    }

    public int getPositionInContextNodeList(XPathContext xPathContext) {
        SubContextList subContextList = xPathContext.getSubContextList();
        if (subContextList != null) {
            int n = subContextList.getProximityPosition(xPathContext);
            return n;
        }
        DTMIterator dTMIterator = xPathContext.getContextNodeList();
        if (dTMIterator != null) {
            int n = dTMIterator.getCurrentNode();
            if (n == -1) {
                if (dTMIterator.getCurrentPos() == 0) {
                    return 0;
                }
                try {
                    dTMIterator = dTMIterator.cloneWithReset();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new WrappedRuntimeException(cloneNotSupportedException);
                }
                int n2 = xPathContext.getContextNode();
                while ((n = dTMIterator.nextNode()) != -1) {
                    if (n == n2) break;
                }
            }
            return dTMIterator.getCurrentPos();
        }
        return -1;
    }
}

