/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.compiler.Compiler;

public class ChildIterator
extends LocPathIterator {
    ChildIterator(Compiler compiler, int n, int n2) throws TransformerException {
        super(compiler, n, n2, false);
    }

    public int asNode(XPathContext xPathContext) throws TransformerException {
        int n = xPathContext.getCurrentNode();
        DTM dTM = xPathContext.getDTM(n);
        return dTM.getFirstChild(n);
    }

    public int getAxis() {
        return 3;
    }

    public int nextNode() {
        if (this.m_cachedNodes != null && this.m_next < this.m_cachedNodes.size()) {
            int n = this.m_cachedNodes.elementAt(this.m_next);
            this.incrementNextPosition();
            this.m_currentContextNode = n;
            return n;
        }
        if (this.m_foundLast) {
            this.m_lastFetched = -1;
            return -1;
        }
        int n = this.m_lastFetched == -1 ? this.m_cdtm.getFirstChild(this.m_context) : this.m_cdtm.getNextSibling(this.m_lastFetched);
        this.m_lastFetched = n;
        if (n != -1) {
            if (this.m_cachedNodes != null) {
                this.m_cachedNodes.addElement(this.m_lastFetched);
            }
            ++this.m_next;
            return n;
        }
        this.m_foundLast = true;
        return -1;
    }
}

