/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMNodeProxy;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.dtm.ref.IncrementalSAXSource;
import org.apache.xml.dtm.ref.IncrementalSAXSource_Filter;
import org.apache.xml.dtm.ref.dom2dtm.DOM2DTM;
import org.apache.xml.dtm.ref.sax2dtm.SAX2DTM;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLStringFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DTMManagerDefault
extends DTMManager {
    protected DTM[] m_dtms = new DTM[1024];
    private ExpandedNameTable m_expandedNameTable = new ExpandedNameTable();
    private static final boolean DUMPTREE = false;
    private static final boolean DEBUG = false;

    public void addDTM(DTM dTM, int n) {
        this.m_dtms[n] = dTM;
        dTM.documentRegistration();
    }

    public DTMIterator createDTMIterator(int n) {
        return null;
    }

    public DTMIterator createDTMIterator(int n, DTMFilter dTMFilter, boolean bl) {
        return null;
    }

    public DTMIterator createDTMIterator(Object object, int n) {
        return null;
    }

    public DTMIterator createDTMIterator(String string, PrefixResolver prefixResolver) {
        return null;
    }

    public DTM createDocumentFragment() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            DocumentFragment documentFragment = document.createDocumentFragment();
            return this.getDTM(new DOMSource(documentFragment), true, null, false, false);
        }
        catch (Exception exception) {
            throw new DTMException(exception);
        }
    }

    public DTM getDTM(int n) {
        return this.m_dtms[n >>> 22];
    }

    public DTM getDTM(Source source, boolean bl, DTMWSFilter dTMWSFilter, boolean bl2, boolean bl3) {
        boolean bl4;
        XMLStringFactory xMLStringFactory = this.m_xsf;
        int n = this.getFirstFreeDTMID();
        int n2 = n << 22;
        if (source != null && source instanceof DOMSource) {
            DOM2DTM dOM2DTM = new DOM2DTM((DTMManager)this, (DOMSource)source, n2, dTMWSFilter, xMLStringFactory, bl3);
            this.addDTM(dOM2DTM, n);
            return dOM2DTM;
        }
        boolean bl5 = source != null ? source instanceof SAXSource : true;
        boolean bl6 = bl4 = source != null ? source instanceof StreamSource : false;
        if (bl5 || bl4) {
            boolean bl7;
            Object object;
            XMLReader xMLReader;
            InputSource inputSource;
            if (source == null) {
                inputSource = null;
                xMLReader = null;
            } else {
                xMLReader = this.getXMLReader(source);
                inputSource = SAXSource.sourceToInputSource(source);
                object = inputSource.getSystemId();
                if (object != null) {
                    try {
                        object = SystemIDResolver.getAbsoluteURI((String)object);
                    }
                    catch (Exception exception) {
                        System.err.println("Can not absolutize URL: " + (String)object);
                    }
                    inputSource.setSystemId((String)object);
                }
            }
            object = new SAX2DTM(this, source, n2, dTMWSFilter, xMLStringFactory, bl3);
            this.addDTM((DTM)object, n);
            boolean bl8 = bl7 = xMLReader != null && xMLReader.getClass().getName().equals("org.apache.xerces.parsers.SAXParser");
            if (bl7) {
                bl2 = true;
            }
            if (DTMManager.m_incremental && bl2) {
                Object object2;
                Object object3 = null;
                if (bl7) {
                    try {
                        object2 = Class.forName("org.apache.xml.dtm.ref.IncrementalSAXSource_Xerces");
                        object3 = (IncrementalSAXSource)((Class)object2).newInstance();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        object3 = null;
                    }
                }
                if (object3 == null) {
                    if (xMLReader == null) {
                        object3 = new IncrementalSAXSource_Filter();
                    } else {
                        object2 = new IncrementalSAXSource_Filter();
                        ((IncrementalSAXSource_Filter)object2).setXMLReader(xMLReader);
                        object3 = object2;
                    }
                }
                ((SAX2DTM)object).setIncrementalSAXSource((IncrementalSAXSource)object3);
                if (inputSource == null) {
                    return object;
                }
                xMLReader.setDTDHandler((DTDHandler)object);
                xMLReader.setErrorHandler((ErrorHandler)object);
                try {
                    object3.startParse(inputSource);
                }
                catch (RuntimeException runtimeException) {
                    ((SAX2DTM)object).clearCoRoutine();
                    throw runtimeException;
                }
                catch (Exception exception) {
                    ((SAX2DTM)object).clearCoRoutine();
                    throw new WrappedRuntimeException(exception);
                }
            }
            if (xMLReader == null) {
                return object;
            }
            xMLReader.setContentHandler((ContentHandler)object);
            xMLReader.setDTDHandler((DTDHandler)object);
            xMLReader.setErrorHandler((ErrorHandler)object);
            try {
                xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", object);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {}
            try {
                xMLReader.parse(inputSource);
            }
            catch (RuntimeException runtimeException) {
                ((SAX2DTM)object).clearCoRoutine();
                throw runtimeException;
            }
            catch (Exception exception) {
                ((SAX2DTM)object).clearCoRoutine();
                throw new WrappedRuntimeException(exception);
            }
            return object;
        }
        throw new DTMException(XSLMessages.createMessage(171, new Object[]{source}));
    }

    public int getDTMHandleFromNode(Node node) {
        Object object;
        if (node == null) {
            throw new IllegalArgumentException(XSLMessages.createMessage(172, null));
        }
        if (node instanceof DTMNodeProxy) {
            return ((DTMNodeProxy)node).getDTMNodeNumber();
        }
        int n = this.m_dtms.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            object = this.m_dtms[n2];
            if (object != null && object instanceof DOM2DTM && (n3 = ((DOM2DTM)object).getHandleOfNode(node)) != -1) {
                return n3;
            }
            ++n2;
        }
        object = node;
        Node node2 = object.getParentNode();
        while (node2 != null) {
            object = node2;
            node2 = node2.getParentNode();
        }
        DTM dTM = this.getDTM(new DOMSource((Node)object), false, null, true, true);
        int n4 = ((DOM2DTM)dTM).getHandleOfNode(node);
        if (n4 == -1) {
            throw new RuntimeException(XSLMessages.createMessage(173, null));
        }
        return n4;
    }

    public int getDTMIdentity(DTM dTM) {
        int n = this.m_dtms.length;
        int n2 = 0;
        while (n2 < n) {
            DTM dTM2 = this.m_dtms[n2];
            if (dTM2 == dTM) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public ExpandedNameTable getExpandedNameTable(DTM dTM) {
        return this.m_expandedNameTable;
    }

    public int getFirstFreeDTMID() {
        int n = this.m_dtms.length;
        int n2 = 1;
        while (n2 < n) {
            if (this.m_dtms[n2] == null) {
                return n2;
            }
            ++n2;
        }
        throw new DTMException(XSLMessages.createMessage(170, null));
    }

    public XMLReader getXMLReader(Source source) {
        try {
            boolean bl;
            XMLReader xMLReader = source instanceof SAXSource ? ((SAXSource)source).getXMLReader() : null;
            boolean bl2 = bl = xMLReader != null;
            if (xMLReader == null) {
                try {
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    sAXParserFactory.setNamespaceAware(true);
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    xMLReader = sAXParser.getXMLReader();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new SAXException(parserConfigurationException);
                }
                catch (FactoryConfigurationError factoryConfigurationError) {
                    throw new SAXException(factoryConfigurationError.toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {}
                if (xMLReader == null) {
                    xMLReader = XMLReaderFactory.createXMLReader();
                }
            }
            try {
                xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXException sAXException) {}
            return xMLReader;
        }
        catch (SAXException sAXException) {
            throw new DTMException(sAXException.getMessage(), sAXException);
        }
    }

    public boolean release(DTM dTM, boolean bl) {
        int n;
        if (dTM instanceof SAX2DTM) {
            ((SAX2DTM)dTM).clearCoRoutine();
        }
        if ((n = this.getDTMIdentity(dTM)) >= 0) {
            this.m_dtms[n] = null;
        }
        dTM.documentRelease();
        return true;
    }
}

