/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.txlock;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.txlock.QueuedTxLock;
import org.jboss.logging.Logger;

public class TxLockInterceptor
implements Interceptor {
    protected Logger log = Logger.getLogger(this.getClass());
    private final TransactionManager tm;
    private final QueuedTxLock lock;

    public TxLockInterceptor(TransactionManager tm, QueuedTxLock lock) {
        this.tm = tm;
        this.lock = lock;
    }

    public String getName() {
        return "TxLockInterceptor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        Transaction tx = this.tm.getTransaction();
        if (tx == null) {
            return invocation.invokeNext();
        }
        this.lock.schedule(tx, invocation);
        try {
            Object object = invocation.invokeNext();
            return object;
        }
        finally {
            this.lock.endInvocation(tx);
        }
    }
}

