/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.jacorb.notification.AnyMessage;
import org.jacorb.notification.StructuredEventMessage;
import org.jacorb.notification.TypedEventMessage;
import org.jacorb.notification.interfaces.AbstractPoolable;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.servant.AbstractProxyConsumerI;
import org.jacorb.notification.util.AbstractObjectPool;
import org.omg.CORBA.Any;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotification.StructuredEventHelper;

public class MessageFactory
implements Disposable,
Configurable {
    private AbstractObjectPool typedEventMessagePool_ = new AbstractObjectPool("TypedEventMessagePool"){

        public Object newInstance() {
            return new TypedEventMessage();
        }

        public void activateObject(Object object) {
            AbstractPoolable abstractPoolable = (AbstractPoolable)object;
            abstractPoolable.reset();
            abstractPoolable.setObjectPool(this);
        }
    };
    private AbstractObjectPool anyMessagePool_ = new AbstractObjectPool("AnyMessagePool"){

        public Object newInstance() {
            return new AnyMessage();
        }

        public void activateObject(Object object) {
            AbstractPoolable abstractPoolable = (AbstractPoolable)object;
            abstractPoolable.reset();
            abstractPoolable.setObjectPool(this);
        }
    };
    private AbstractObjectPool structuredEventMessagePool_ = new AbstractObjectPool("StructuredEventMessagePool"){

        public Object newInstance() {
            return new StructuredEventMessage();
        }

        public void activateObject(Object object) {
            AbstractPoolable abstractPoolable = (AbstractPoolable)object;
            abstractPoolable.reset();
            abstractPoolable.setObjectPool(this);
        }
    };

    public void configure(Configuration configuration) {
        this.anyMessagePool_.configure(configuration);
        this.structuredEventMessagePool_.configure(configuration);
        this.typedEventMessagePool_.configure(configuration);
    }

    public void dispose() {
        this.structuredEventMessagePool_.dispose();
        this.anyMessagePool_.dispose();
        this.typedEventMessagePool_.dispose();
    }

    public Message newMessage(Any any, AbstractProxyConsumerI abstractProxyConsumerI) {
        if (StructuredEventHelper.type().equals(any.type())) {
            return this.newMessage(StructuredEventHelper.extract(any), abstractProxyConsumerI);
        }
        Message message = this.newMessage(any);
        message.setInitialFilterStage(abstractProxyConsumerI.getFirstStage());
        return message;
    }

    public Message newMessage(StructuredEvent structuredEvent, AbstractProxyConsumerI abstractProxyConsumerI) {
        String string = structuredEvent.header.fixed_header.event_type.type_name;
        if ("%ANY".equals(string)) {
            return this.newMessage(structuredEvent.remainder_of_body, abstractProxyConsumerI);
        }
        StructuredEventMessage structuredEventMessage = (StructuredEventMessage)this.structuredEventMessagePool_.lendObject();
        structuredEventMessage.setFilterStage(abstractProxyConsumerI.getFirstStage());
        structuredEventMessage.setStructuredEvent(structuredEvent, abstractProxyConsumerI.isStartTimeSupported(), abstractProxyConsumerI.isTimeOutSupported());
        return structuredEventMessage.getHandle();
    }

    public Message newMessage(String string, String string2, NVList nVList, AbstractProxyConsumerI abstractProxyConsumerI) {
        try {
            TypedEventMessage typedEventMessage = (TypedEventMessage)this.typedEventMessagePool_.lendObject();
            Property[] propertyArray = new Property[nVList.count()];
            for (int i = 0; i < propertyArray.length; ++i) {
                NamedValue namedValue = nVList.item(i);
                propertyArray[i] = new Property(namedValue.name(), namedValue.value());
            }
            typedEventMessage.setTypedEvent(string, string2, propertyArray);
            Message message = typedEventMessage.getHandle();
            message.setInitialFilterStage(abstractProxyConsumerI.getFirstStage());
            return message;
        }
        catch (Bounds bounds) {
            throw new RuntimeException(bounds.getMessage());
        }
    }

    public Message newMessage(Property[] propertyArray) {
        TypedEventMessage typedEventMessage = (TypedEventMessage)this.typedEventMessagePool_.lendObject();
        typedEventMessage.setTypedEvent(propertyArray);
        return typedEventMessage.getHandle();
    }

    public Message newMessage(Any any) {
        if (StructuredEventHelper.type().equals(any.type())) {
            return this.newMessage(StructuredEventHelper.extract(any));
        }
        AnyMessage anyMessage = (AnyMessage)this.anyMessagePool_.lendObject();
        anyMessage.setAny(any);
        return anyMessage.getHandle();
    }

    public Message newMessage(StructuredEvent structuredEvent) {
        String string = structuredEvent.header.fixed_header.event_type.type_name;
        if ("%ANY".equals(string)) {
            return this.newMessage(structuredEvent.remainder_of_body);
        }
        StructuredEventMessage structuredEventMessage = (StructuredEventMessage)this.structuredEventMessagePool_.lendObject();
        structuredEventMessage.setStructuredEvent(structuredEvent, false, false);
        return structuredEventMessage.getHandle();
    }
}

