/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.tc5.session;

import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jboss.web.tomcat.tc5.session.AbstractJBossManager;
import org.jboss.web.tomcat.tc5.session.ClusteredSession;
import org.jboss.web.tomcat.tc5.session.JBossCacheManager;
import org.jboss.web.tomcat.tc5.session.JBossCacheService;

class SessionBasedClusteredSession
extends ClusteredSession
implements Serializable {
    static final long serialVersionUID = 3200976125245487256L;
    protected static final String info = "SessionBasedClusteredSession/1.0";
    private transient boolean isSessionModifiedSinceLastSave;
    private transient JBossCacheService proxy_;

    public SessionBasedClusteredSession(AbstractJBossManager manager) {
        super(manager);
        this.initAfterLoad(manager);
    }

    public void initAfterLoad(AbstractJBossManager manager) {
        if (this.proxy_ == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"initAfterLoad(): initialize the transient variables ...");
            }
            this.setManager(manager);
            this.listeners = new ArrayList();
            this.notes = new HashMap();
            this.support = new PropertyChangeSupport(this);
            this.expiring = false;
            this.isSessionModifiedSinceLastSave = false;
            this.isOutdated = false;
            this.proxy_ = ((JBossCacheManager)manager).getCacheService();
            if (this.proxy_ == null) {
                throw new RuntimeException("SessionBasedClusteredSession: Cache service is null.");
            }
            this.activate();
        }
    }

    public void setCreationTime(long time) {
        super.setCreationTime(time);
        this.sessionIsDirty();
    }

    public void setPrincipal(Principal principal) {
        Principal oldPrincipal = this.principal;
        this.principal = principal;
        this.support.firePropertyChange("principal", oldPrincipal, this.principal);
        if (oldPrincipal != null && !((Object)oldPrincipal).equals(principal) || oldPrincipal == null && principal != null) {
            this.sessionIsDirty();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SessionBasedClusteredSession[");
        sb.append(this.id);
        sb.append("]");
        return sb.toString();
    }

    public synchronized void processSessionRepl() {
        if (!this.isSessionDirty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"processSessionRepl(): session is not dirty. No need to replicate.");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("processSessionRepl(): session is dirty. Will increment version from: " + this.getVersion() + " and replicate."));
        }
        this.incrementVersion();
        this.proxy_.putSession(this.id, this);
        this.isSessionModifiedSinceLastSave = false;
    }

    public void removeMyself() {
        this.proxy_.removeSession(this.id);
    }

    public void removeMyselfLocal() {
        this.proxy_.removeSessionLocal(this.id);
    }

    public void access() {
        super.access();
        if (this.invalidationPolicy == 0) {
            this.sessionIsDirty();
        }
    }

    protected Object getJBossInternalAttribute(String name) {
        Object result = this.attributes.get(name);
        if (result != null) {
            if (this.invalidationPolicy == 1) {
                this.sessionIsDirty();
            } else if (!(this.invalidationPolicy != 2 || result instanceof String || result instanceof Integer || result instanceof Long || result instanceof Byte || result instanceof Short || result instanceof Float || result instanceof Double || result instanceof Character || result instanceof Boolean)) {
                this.sessionIsDirty();
            }
        }
        return result;
    }

    protected Object removeJBossInternalAttribute(String name) {
        this.sessionIsDirty();
        return this.attributes.remove(name);
    }

    protected Map getJBossInternalAttributes() {
        this.sessionIsDirty();
        return this.attributes;
    }

    protected Object setJBossInternalAttribute(String name, Object value) {
        this.sessionIsDirty();
        return this.attributes.put(name, value);
    }

    protected void sessionIsDirty() {
        this.isSessionModifiedSinceLastSave = true;
    }

    public boolean isSessionDirty() {
        return this.isSessionModifiedSinceLastSave;
    }
}

