/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Timestamp {
    protected Element element = null;
    protected Element elementCreated = null;
    protected Element elementExpires = null;
    protected Vector customElements = new Vector();
    protected Calendar created;
    protected Calendar expires;

    public Timestamp(Element element) throws WSSecurityException {
        String strCreated = "";
        String strExpires = "";
        this.created = Calendar.getInstance();
        this.expires = Calendar.getInstance();
        for (Node currentChild = element.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if ("Created".equals(currentChild.getLocalName()) && WSConstants.WSU_NS.equals(currentChild.getNamespaceURI())) {
                strCreated = ((Text)((Element)currentChild).getFirstChild()).getData();
                continue;
            }
            if ("Expires".equals(currentChild.getLocalName()) && WSConstants.WSU_NS.equals(currentChild.getNamespaceURI())) {
                strExpires = ((Text)((Element)currentChild).getFirstChild()).getData();
                continue;
            }
            this.customElements.add((Element)currentChild);
        }
        SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        zulu.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            this.created.setTime(zulu.parse(strCreated));
            this.expires.setTime(zulu.parse(strExpires));
        }
        catch (ParseException e) {
            throw new WSSecurityException(3, "invalidTimestamp", null, e);
        }
    }

    public Timestamp(Document doc, int ttl) {
        this.element = doc.createElementNS(WSConstants.WSU_NS, "wsu:Timestamp");
        WSSecurityUtil.setNamespace(this.element, WSConstants.WSU_NS, "wsu");
        SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        zulu.setTimeZone(TimeZone.getTimeZone("GMT"));
        Calendar rightNow = Calendar.getInstance();
        this.elementCreated = doc.createElementNS(WSConstants.WSU_NS, "wsu:Created");
        WSSecurityUtil.setNamespace(this.elementCreated, WSConstants.WSU_NS, "wsu");
        this.elementCreated.appendChild(doc.createTextNode(zulu.format(rightNow.getTime())));
        this.element.appendChild(this.elementCreated);
        long currentTime = rightNow.getTimeInMillis();
        rightNow.setTimeInMillis(currentTime += (long)(ttl * 1000));
        this.elementExpires = doc.createElementNS(WSConstants.WSU_NS, "wsu:Expires");
        WSSecurityUtil.setNamespace(this.elementExpires, WSConstants.WSU_NS, "wsu");
        this.elementExpires.appendChild(doc.createTextNode(zulu.format(rightNow.getTime())));
        this.element.appendChild(this.elementExpires);
    }

    public Element getElement() {
        return this.element;
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    public Calendar getCreated() {
        return this.created;
    }

    public Calendar getExpires() {
        return this.expires;
    }

    public void addCustomElement(Document doc, Element customElement) {
        this.customElements.add(customElement);
        this.element.appendChild(customElement);
    }

    public Vector getCustomElements() {
        return this.customElements;
    }
}

