/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.conversation.message.token;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.message.token.RequestedProofToken;
import org.apache.ws.security.conversation.message.token.RequestedSecurityToken;
import org.apache.ws.security.conversation.message.token.SecurityContextToken;
import org.apache.ws.security.message.WSBaseMessage;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RequestSecurityTokenResponse
extends WSBaseMessage {
    private Element element = null;
    private Element tokenTypeEle;
    private Element keyTypeEle;
    private Element keySizeEle;
    private Element LifeTime = null;
    private Element Created = null;
    private Element Expires = null;
    private String tokenType;
    private String keyType;
    private String keySize;
    private RequestedProofToken requestedProofToken;
    private RequestedSecurityToken requestedSecurityToken;
    private KeyInfo keyInfo;
    public static final QName TOKEN = new QName(WSConstants.WSSE_NS, "SecurityContextTokenResponse");

    public RequestSecurityTokenResponse(Document doc) throws Exception {
        this.element = doc.createElementNS(WSConstants.WSSE_NS, "wsse:SecurityContextTokenResponse");
        this.tokenTypeEle = doc.createElementNS(WSConstants.WSSE_NS, "wsse:TokenType");
        this.keyTypeEle = doc.createElementNS(WSConstants.WSSE_NS, "wsse:KeyType");
        this.keySizeEle = doc.createElementNS(WSConstants.WSSE_NS, "wsse:KeySize");
        WSSecurityUtil.setNamespace(this.keySizeEle, WSConstants.WSSE_NS, "wsse");
        this.tokenTypeEle.appendChild(doc.createTextNode(""));
        this.keyTypeEle.appendChild(doc.createTextNode(""));
        this.keySizeEle.appendChild(doc.createTextNode(""));
        SecurityContextToken cntxtToken = new SecurityContextToken(doc);
        this.requestedSecurityToken = new RequestedSecurityToken(doc, cntxtToken);
        this.element.appendChild(this.tokenTypeEle);
        this.element.appendChild(this.keyTypeEle);
        this.element.appendChild(this.keySizeEle);
        this.element.appendChild(this.createLifeTimeElement(doc));
        this.element.appendChild(this.requestedSecurityToken.getElement());
        this.element.appendChild(this.createRequestedProofToken(doc));
    }

    public RequestSecurityTokenResponse(Element elem) throws WSSecurityException {
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN)) {
            throw new WSSecurityException(4, "badTokenType00", new Object[]{el});
        }
        this.tokenTypeEle = (Element)WSSecurityUtil.getDirectChild(this.element, "TokenType", WSConstants.WSSE_NS);
        this.keyTypeEle = (Element)WSSecurityUtil.getDirectChild(this.element, "KeyType", WSConstants.WSSE_NS);
        this.keySizeEle = (Element)WSSecurityUtil.getDirectChild(this.element, "KeySize", WSConstants.WSSE_NS);
        this.LifeTime = (Element)WSSecurityUtil.getDirectChild(this.element, "Lifetime", WSConstants.WSU_NS);
        this.Created = (Element)WSSecurityUtil.getDirectChild(this.element, "Created", WSConstants.WSSE_NS);
        this.Expires = (Element)WSSecurityUtil.getDirectChild(this.element, "Expires", WSConstants.WSU_NS);
        this.requestedSecurityToken = new RequestedSecurityToken((Element)WSSecurityUtil.getDirectChild(this.element, "RequestedSecurityToken", WSConstants.WSSE_NS));
        this.requestedProofToken = new RequestedProofToken((Element)WSSecurityUtil.getDirectChild(this.element, "RequestedProofToken", WSConstants.WSSE_NS));
    }

    private Element createRequestedProofToken(Document doc) throws WSSecurityException {
        this.requestedProofToken = new RequestedProofToken(doc);
        return this.requestedProofToken.getElement();
    }

    public void setRequestedSecurityToken(RequestedSecurityToken requestedSecurityToken) {
        this.requestedSecurityToken = requestedSecurityToken;
    }

    public void setRequestedProofToken(RequestedProofToken requestedProofToken) {
        this.requestedProofToken = requestedProofToken;
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    private Element createLifeTimeElement(Document doc) {
        SimpleDateFormat sdtf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdtf.setTimeZone(TimeZone.getTimeZone("GMT"));
        Calendar rightNow = Calendar.getInstance();
        this.LifeTime = doc.createElementNS(WSConstants.WSU_NS, "wsu:Lifetime");
        WSSecurityUtil.setNamespace(this.LifeTime, WSConstants.WSU_NS, "wsu");
        this.Created = doc.createElementNS(WSConstants.WSU_NS, "wsu:Created");
        WSSecurityUtil.setNamespace(this.Created, WSConstants.WSU_NS, "wsu");
        this.Expires = doc.createElementNS(WSConstants.WSU_NS, "wsu:Expires");
        this.Created.appendChild(doc.createTextNode(sdtf.format(rightNow.getTime())));
        this.Expires.appendChild(doc.createTextNode(sdtf.format(rightNow.getTime())));
        this.LifeTime.appendChild(this.Created);
        this.LifeTime.appendChild(this.Expires);
        return this.LifeTime;
    }

    public RequestedProofToken getRequestedProfToken() {
        return this.requestedProofToken;
    }

    public RequestedProofToken getRequestedProofToken() {
        return this.requestedProofToken;
    }

    public RequestedSecurityToken getRequestedSecurityToken() {
        return this.requestedSecurityToken;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public void build(Document doc) {
        Element securityHeader = this.insertSecurityHeader(doc);
        WSSecurityUtil.appendChildElement(doc, securityHeader, this.element);
        WSSecurityUtil.setNamespace(securityHeader, WSConstants.WSU_NS, "wsu");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XMLUtils.outputDOM((Node)doc, (OutputStream)os, (boolean)true);
        String osStr = os.toString();
        System.out.println(osStr);
    }
}

