/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.components.crypto;

import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.ws.security.WSSecurityException;

public interface Crypto {
    public X509Certificate loadCertificate(InputStream var1) throws WSSecurityException;

    public X509Certificate[] getX509Certificates(byte[] var1, boolean var2) throws WSSecurityException;

    public byte[] getCertificateData(boolean var1, X509Certificate[] var2) throws WSSecurityException;

    public PrivateKey getPrivateKey(String var1, String var2) throws Exception;

    public X509Certificate[] getCertificates(String var1) throws WSSecurityException;

    public String getAliasForX509Cert(Certificate var1) throws WSSecurityException;

    public String getAliasForX509Cert(String var1, BigInteger var2) throws WSSecurityException;

    public String getAliasForX509Cert(byte[] var1) throws WSSecurityException;

    public String getDefaultX509Alias();

    public byte[] getSKIBytesFromCert(X509Certificate var1) throws WSSecurityException;

    public KeyStore getKeyStore();

    public CertificateFactory getCertificateFactory() throws WSSecurityException;

    public boolean validateCertPath(X509Certificate[] var1) throws WSSecurityException;

    public String[] getAliasesForDN(String var1) throws WSSecurityException;
}

