/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.util.NestedRuntimeException;

public class CachedMap
extends AbstractMap
implements Map {
    protected TreeCacheAop cache;
    protected Fqn fqn;

    protected Node getNode() {
        try {
            return this.cache.get(this.fqn);
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    protected CachedMap(TreeCacheAop cache, Fqn fqn) {
        this.cache = cache;
        this.fqn = fqn;
    }

    public Object get(Object key) {
        try {
            return this.cache.getObject(new Fqn(this.fqn, key));
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public Object put(Object key, Object value) {
        try {
            return this.cache.putObject(new Fqn(this.fqn, key), value);
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public void putAll(Map map) {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        try {
            return this.cache.removeObject(new Fqn(this.fqn, key));
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public void clear() {
        Iterator i = this.keySet().iterator();
        while (i.hasNext()) {
            this.remove(i.next());
        }
    }

    public int size() {
        Map children = this.getNode().getChildren();
        return children == null ? 0 : children.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object object) {
        Map children = this.getNode().getChildren();
        return children == null ? false : children.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return false;
    }

    public Set entrySet() {
        final CachedMap map = this;
        return new AbstractSet(){

            public int size() {
                Map children = CachedMap.this.getNode().getChildren();
                return children == null ? 0 : children.size();
            }

            public Iterator iterator() {
                Map children = CachedMap.this.getNode().getChildren();
                final Iterator<Object> i = children == null ? Collections.EMPTY_LIST.iterator() : children.keySet().iterator();
                return new Iterator(){
                    Object lastKey;

                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    public Object next() {
                        this.lastKey = i.next();
                        return new Entry(this.lastKey);
                    }

                    public void remove() {
                        map.remove(this.lastKey);
                    }
                };
            }
        };
    }

    public Collection values() {
        return null;
    }

    public Set keySet() {
        Map children = this.getNode().getChildren();
        return children == null ? Collections.EMPTY_SET : children.keySet();
    }

    public int hashCode() {
        int result = 0;
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            result += i.next().hashCode();
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.size() != map.size()) {
            return false;
        }
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            Object value = entry.getValue();
            if (!(value != null ? map.get(entry.getKey()) != null || !map.containsKey(entry.getKey()) : !value.equals(map.get(entry.getKey())))) continue;
            return false;
        }
        return true;
    }

    protected class Entry
    implements Map.Entry {
        Object key;

        public Entry(Object key) {
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            try {
                return CachedMap.this.cache.getObject(new Fqn(CachedMap.this.fqn, this.key));
            }
            catch (Exception e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }

        public Object setValue(Object value) {
            try {
                return CachedMap.this.cache.putObject(new Fqn(CachedMap.this.fqn, this.key), value);
            }
            catch (Exception e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }

        public int hashCode() {
            Object value = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Object value = this.getValue();
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (value == null ? entry.getValue() == null : value.equals(entry.getValue()));
        }
    }
}

