/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.acl.Group;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.jboss.security.auth.spi.Util;

public class DatabaseServerLoginModule
extends UsernamePasswordLoginModule {
    protected String dsJndiName;
    protected String principalsQuery = "select Password from Principals where PrincipalID=?";
    protected String rolesQuery = "select Role, RoleGroup from Roles where PrincipalID=?";

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        Object tmp;
        super.initialize(subject, callbackHandler, sharedState, options);
        this.dsJndiName = (String)options.get("dsJndiName");
        if (this.dsJndiName == null) {
            this.dsJndiName = "java:/DefaultDS";
        }
        if ((tmp = options.get("principalsQuery")) != null) {
            this.principalsQuery = tmp.toString();
        }
        if ((tmp = options.get("rolesQuery")) != null) {
            this.rolesQuery = tmp.toString();
        }
        this.log.trace((Object)("DatabaseServerLoginModule, dsJndiName=" + this.dsJndiName));
        this.log.trace((Object)("principalsQuery=" + this.principalsQuery));
        this.log.trace((Object)("rolesQuery=" + this.rolesQuery));
    }

    protected String getUsersPassword() throws LoginException {
        String username = this.getUsername();
        String password = null;
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(this.dsJndiName);
            conn = ds.getConnection();
            ps = conn.prepareStatement(this.principalsQuery);
            ps.setString(1, username);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new FailedLoginException("No matching username found in Principals");
            }
            password = rs.getString(1);
            password = this.convertRawPassword(password);
        }
        catch (NamingException ex) {
            throw new LoginException(ex.toString(true));
        }
        catch (SQLException ex) {
            this.log.error((Object)"Query failed", (Throwable)ex);
            throw new LoginException(ex.toString());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {}
            }
        }
        return password;
    }

    protected Group[] getRoleSets() throws LoginException {
        String username = this.getUsername();
        Group[] roleSets = Util.getRoleSets(username, this.dsJndiName, this.rolesQuery, (AbstractServerLoginModule)this);
        return roleSets;
    }

    protected String convertRawPassword(String rawPassword) {
        return rawPassword;
    }
}

