/*
 * Decompiled with CFR 0.152.
 */
package org.jnp.test;

import java.io.IOException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Properties;
import javax.naming.InitialContext;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;
import org.jnp.server.Main;

public class TestJNPSockets
extends TestCase {
    static Main server;
    static int serverPort;
    static /* synthetic */ Class class$org$jnp$test$TestJNPSockets$ClientSocketFactory;
    static /* synthetic */ Class class$org$jnp$test$TestJNPSockets$ServerSocketFactory;
    static /* synthetic */ Class class$org$jnp$test$TestJNPSockets;

    public TestJNPSockets(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        if (server != null) {
            return;
        }
        server = new Main();
        server.setPort(0);
        server.setBindAddress("localhost");
        server.setClientSocketFactory((class$org$jnp$test$TestJNPSockets$ClientSocketFactory == null ? (class$org$jnp$test$TestJNPSockets$ClientSocketFactory = TestJNPSockets.class$("org.jnp.test.TestJNPSockets$ClientSocketFactory")) : class$org$jnp$test$TestJNPSockets$ClientSocketFactory).getName());
        server.setServerSocketFactory((class$org$jnp$test$TestJNPSockets$ServerSocketFactory == null ? (class$org$jnp$test$TestJNPSockets$ServerSocketFactory = TestJNPSockets.class$("org.jnp.test.TestJNPSockets$ServerSocketFactory")) : class$org$jnp$test$TestJNPSockets$ServerSocketFactory).getName());
        server.start();
        serverPort = server.getPort();
    }

    public void testAccess() throws Exception {
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        env.setProperty("java.naming.provider.url", "localhost:" + serverPort);
        env.setProperty("java.naming.factory.url.pkgs", "org.jnp.interfaces");
        InitialContext ctx = new InitialContext(env);
        System.out.println("Connected to jnp service");
        ctx.list("");
        ctx.close();
        if (!ClientSocketFactory.created) {
            TestJNPSockets.fail((String)"No ClientSocketFactory was created");
        }
        if (!ServerSocketFactory.created) {
            TestJNPSockets.fail((String)"No ServerSocketFactory was created");
        }
        server.stop();
    }

    public static void main(String[] args) throws Exception {
        System.setErr(System.out);
        BasicConfigurator.configure();
        TestSuite suite = new TestSuite(class$org$jnp$test$TestJNPSockets == null ? (class$org$jnp$test$TestJNPSockets = TestJNPSockets.class$("org.jnp.test.TestJNPSockets")) : class$org$jnp$test$TestJNPSockets);
        TestRunner.run((Test)suite);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ServerSocketFactory
    implements RMIServerSocketFactory,
    Serializable {
        static final long serialVersionUID = -2632886892871952872L;
        static boolean created;

        public ServerSocket createServerSocket(int port) throws IOException {
            ServerSocket serverSocket = new ServerSocket(port);
            System.out.println("createServerSocket -> " + serverSocket);
            created = true;
            return serverSocket;
        }
    }

    public static class ClientSocketFactory
    implements RMIClientSocketFactory,
    Serializable {
        static final long serialVersionUID = -3951228824124738736L;
        static boolean created;

        public Socket createSocket(String host, int port) throws IOException {
            Socket clientSocket = new Socket(host, port);
            System.out.println("createSocket -> " + clientSocket);
            created = true;
            return clientSocket;
        }
    }
}

