/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.attachments;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.jboss.logging.Logger;

public class ManagedMemoryDataSource
implements DataSource {
    private static Logger log = Logger.getLogger((Class)ManagedMemoryDataSource.class);
    protected String contentType = "application/octet-stream";
    private byte[] contentData;
    private File cacheFile;
    public static final int READ_CHUNK_SZ = 32768;
    public static final int MAX_MEMORY_SZ = 65536;

    public ManagedMemoryDataSource(InputStream inputStream, String contentType) throws IOException {
        if (contentType != null) {
            this.contentType = contentType;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(32768);
        OutputStream os = baos;
        byte[] bytes = new byte[32768];
        int read = inputStream.read(bytes);
        while (read > 0) {
            os.write(bytes, 0, read);
            if (baos != null && baos.size() > 65536) {
                this.cacheFile = File.createTempFile("attachment", ".dat");
                this.cacheFile.deleteOnExit();
                log.debug((Object)("Created cache file: " + this.cacheFile.toURL()));
                os = new FileOutputStream(this.cacheFile);
                os.write(baos.toByteArray());
                baos = null;
            }
            read = inputStream.read(bytes);
        }
        os.flush();
        os.close();
        if (baos != null) {
            log.debug((Object)("Using in memory cache: " + baos.size()));
            this.contentData = baos.toByteArray();
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        if (this.contentData != null) {
            return new ByteArrayInputStream(this.contentData);
        }
        if (this.cacheFile != null) {
            return new TempFileInputStream(this.cacheFile);
        }
        throw new IllegalStateException("No cache available");
    }

    public String getName() {
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    class TempFileInputStream
    extends FileInputStream {
        public TempFileInputStream(File file) throws FileNotFoundException {
            super(file);
        }

        public void close() throws IOException {
            super.close();
            if (ManagedMemoryDataSource.this.cacheFile != null) {
                ManagedMemoryDataSource.this.cacheFile.delete();
                ManagedMemoryDataSource.this.cacheFile = null;
            }
        }
    }
}

