/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jaxr.juddi.axis;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.Admin;
import org.apache.juddi.datatype.request.Inquiry;
import org.apache.juddi.datatype.request.Publish;
import org.apache.juddi.datatype.request.SecurityPolicy;
import org.apache.juddi.datatype.response.DispositionReport;
import org.apache.juddi.error.BusyException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnsupportedException;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.registry.RegistryServlet;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.xml.XMLUtils;
import org.jboss.axis.AxisFault;
import org.jboss.axis.Message;
import org.jboss.axis.MessageContext;
import org.jboss.axis.message.SOAPBodyElementAxisImpl;
import org.jboss.axis.message.SOAPEnvelopeAxisImpl;
import org.jboss.jaxr.juddi.axis.JBossJuddiAdminServlet;
import org.jboss.jaxr.juddi.axis.JBossJuddiInquiryServlet;
import org.jboss.jaxr.juddi.axis.JBossJuddiPublishServlet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JBossJuddiAxisProcessor {
    private static Log log = LogFactory.getLog((Class)(class$org$jboss$jaxr$juddi$axis$JBossJuddiAxisProcessor == null ? (class$org$jboss$jaxr$juddi$axis$JBossJuddiAxisProcessor = JBossJuddiAxisProcessor.class$("org.jboss.jaxr.juddi.axis.JBossJuddiAxisProcessor")) : class$org$jboss$jaxr$juddi$axis$JBossJuddiAxisProcessor));
    private static HandlerMaker maker = HandlerMaker.getInstance();
    static /* synthetic */ Class class$org$jboss$jaxr$juddi$axis$JBossJuddiAxisProcessor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JBossJuddiAxisProcessor(Message soapResponse, MessageContext messageContext) {
        String fCode;
        Message soapRequest = messageContext.getRequestMessage();
        try {
            log.debug((Object)soapRequest.getSOAPPartAsString());
        }
        catch (AxisFault af) {
            af.printStackTrace();
        }
        Element request = null;
        Element response = null;
        String function = null;
        String generic = null;
        try {
            AbstractHandler requestHandler;
            SOAPEnvelopeAxisImpl env = soapRequest.getSOAPEnvelope();
            SOAPBodyElementAxisImpl requestBody = env.getFirstBody();
            request = requestBody.getAsDOM();
            function = request.getLocalName();
            generic = request.getAttribute("generic");
            if (generic == null) {
                generic = "2.0";
            }
            if ((requestHandler = maker.lookup(function)) == null) {
                throw new UnsupportedException("The request type is unknown: " + function);
            }
            RegistryObject uddiRequest = requestHandler.unmarshal(request);
            Object juddiServlet = messageContext.getProperty("transport.http.servlet");
            if (juddiServlet instanceof JBossJuddiInquiryServlet && !(uddiRequest instanceof Inquiry)) {
                throw new RegistryException("Inquiry API does not support function: " + function);
            }
            if (juddiServlet instanceof JBossJuddiPublishServlet && !(uddiRequest instanceof Publish) && !(uddiRequest instanceof SecurityPolicy)) {
                throw new RegistryException("Publish API does not support function: " + function);
            }
            if (juddiServlet instanceof JBossJuddiAdminServlet && !(uddiRequest instanceof Admin)) {
                throw new RegistryException("Admin API does not support function: " + function);
            }
            RegistryObject uddiResponse = null;
            RegistryEngine registry = RegistryServlet.getRegistry();
            if (registry == null || !registry.isAvailable()) {
                throw new BusyException("The Registry is unavailable");
            }
            uddiResponse = registry.execute(uddiRequest);
            Document document = XMLUtils.createDocument();
            Element element = document.createElement("temp");
            AbstractHandler responseHandler = maker.lookup(uddiResponse.getClass().getName());
            responseHandler.marshal(uddiResponse, element);
            response = (Element)element.getFirstChild();
        }
        catch (RegistryException rex) {
            log.error((Object)rex.getMessage(), (Throwable)rex);
            fCode = rex.getFaultCode();
            String fString = rex.getFaultString();
            String fActor = rex.getFaultActor();
            DispositionReport dispRpt = rex.getDispositionReport();
            if (dispRpt != null) {
                dispRpt.setGeneric(generic);
                dispRpt.setOperator(Config.getOperator());
            }
            response = JBossJuddiAxisProcessor.createFault(fCode, fString, fActor, dispRpt);
        }
        catch (AxisFault axf) {
            log.error((Object)axf.getMessage(), (Throwable)axf);
            fCode = String.valueOf(axf.getFaultCode());
            String fString = axf.getFaultString();
            String fActor = axf.getFaultActor();
            response = JBossJuddiAxisProcessor.createFault(fCode, fString, fActor, null);
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            fCode = null;
            String fString = ex.getMessage();
            String fActor = null;
            response = JBossJuddiAxisProcessor.createFault(fCode, fString, fActor, null);
        }
        try {
            SOAPBodyElementAxisImpl soapRespBody = new SOAPBodyElementAxisImpl(response);
            SOAPEnvelopeAxisImpl soapRespEnv = soapResponse.getSOAPEnvelope();
            soapRespEnv.addBodyElement(soapRespBody);
        }
        catch (AxisFault af) {
            af.printStackTrace();
        }
        try {
            log.debug((Object)soapResponse.getSOAPPartAsString());
        }
        catch (AxisFault af) {
            af.printStackTrace();
        }
    }

    private static Element createFault(String fCode, String fString, String fActor, DispositionReport dispRpt) {
        Document document = XMLUtils.createDocument();
        Element fault = document.createElement("Fault");
        if (fCode != null) {
            Element fCodeElement = document.createElement("faultcode");
            fCodeElement.appendChild(document.createTextNode(fCode));
            fault.appendChild(fCodeElement);
        }
        if (fString == null) {
            fString = "";
        }
        Element fStringElement = document.createElement("faultstring");
        fStringElement.appendChild(document.createTextNode(fString));
        fault.appendChild(fStringElement);
        if (fActor != null) {
            Element fActorElement = document.createElement("faultactor");
            fActorElement.appendChild(document.createTextNode(fActor));
            fault.appendChild(fActorElement);
        }
        if (dispRpt != null) {
            Element fDetailElement = document.createElement("detail");
            AbstractHandler handler = maker.lookup("dispositionReport");
            handler.marshal((RegistryObject)dispRpt, fDetailElement);
            fault.appendChild(fDetailElement);
        }
        return fault;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

