/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.stats;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.varia.stats.AbstractStatisticalItem;
import org.jboss.varia.stats.StatisticalItem;

public class TxReport
implements Serializable {
    static final long serialVersionUID = 1144384523072827681L;
    private static final String DEFAULT_NAME = "UNKNOWN";
    private String name = "UNKNOWN";
    private final Map stats = new HashMap();
    private int count = 1;

    public String getName() {
        return this.name;
    }

    public int getCount() {
        return this.count;
    }

    public Map getStats() {
        return this.stats;
    }

    public boolean addItem(StatisticalItem item) {
        StatisticalItem curItem;
        if (this.name == DEFAULT_NAME) {
            this.name = item.getValue();
        }
        boolean addedNew = false;
        HashMap<String, StatisticalItem> itemMap = (HashMap<String, StatisticalItem>)this.stats.get(item.getName());
        if (itemMap == null) {
            itemMap = new HashMap<String, StatisticalItem>();
            this.stats.put(item.getName(), itemMap);
            addedNew = true;
        }
        if ((curItem = (StatisticalItem)itemMap.get(item.getValue())) == null) {
            itemMap.put(item.getValue(), item);
        } else {
            curItem.add(item);
        }
        return addedNew;
    }

    public void merge(TxReport txReport) {
        Iterator iter = txReport.stats.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String itemName = (String)entry.getKey();
            Map myMap = (Map)this.stats.get(itemName);
            Map itemMap = (Map)entry.getValue();
            if (myMap == null) {
                this.stats.put(itemName, itemMap);
                continue;
            }
            Iterator myItems = myMap.values().iterator();
            while (myItems.hasNext()) {
                StatisticalItem myItem = (StatisticalItem)myItems.next();
                StatisticalItem newItem = (StatisticalItem)itemMap.remove(myItem.getValue());
                if (newItem == null) {
                    myItem.mergeNull();
                    continue;
                }
                myItem.merge(newItem);
            }
            if (itemMap.isEmpty()) continue;
            Iterator newItems = itemMap.values().iterator();
            while (newItems.hasNext()) {
                StatisticalItem newItem = (StatisticalItem)newItems.next();
                myMap.put(newItem.getValue(), newItem);
            }
        }
        this.count += txReport.count;
    }

    public static class SqlStats
    extends AbstractStatisticalItem {
        public static final String NAME = "SQL Statistics Per Transaction";

        public SqlStats(String sql) {
            super(NAME);
            this.value = sql;
        }
    }

    public static class MethodStats
    extends AbstractStatisticalItem {
        public static final String NAME = "Method Statistics Per Transaction";

        public MethodStats(String method) {
            super(NAME);
            this.value = method;
        }
    }
}

