/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.stats;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.varia.stats.StatisticalItem;
import org.jboss.varia.stats.StatisticsCollectorMBean;
import org.jboss.varia.stats.TxStatistics;
import org.jboss.varia.stats.report.ReportGenerator;

public class StatisticsCollector
extends ServiceMBeanSupport
implements StatisticsCollectorMBean {
    private final TxStatistics stats = new TxStatistics();
    private final Set reportGenerators = new HashSet();

    public void registerReportGenerator(ReportGenerator reportGenerator) {
        this.reportGenerators.add(reportGenerator);
    }

    public void unregisterReportGenerator(ReportGenerator reportGenerator) {
        this.reportGenerators.remove(reportGenerator);
    }

    public void clearStatistics() {
        this.stats.clear();
    }

    public void addStatisticalItem(StatisticalItem item) {
        this.stats.addStatisticalItem(item);
    }

    public Iterator reportsIterator() {
        return this.stats.getReports();
    }

    public TxStatistics txStatistics() {
        return this.stats;
    }

    public synchronized String reports() {
        StringBuffer buf = new StringBuffer();
        buf.append("<table><tr><th>Report</th><th>Description</th></tr>");
        Iterator generators = this.reportGenerators.iterator();
        while (generators.hasNext()) {
            ReportGenerator generator = (ReportGenerator)generators.next();
            buf.append("<tr><td>").append("<a href='HtmlAdaptor?").append("action=invokeOpByName&name=").append(generator.getServiceName()).append("&methodName=generate&").append("argType=java.lang.String&arg0=").append("'>").append(generator.getName()).append("</a></td><td>").append(generator.getDescription()).append("</td></tr>");
        }
        buf.append("</table>");
        return buf.toString();
    }
}

