/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.X509KeyManager;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.X500Name;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;

final class X509KeyManagerImpl
implements X509KeyManager {
    private HashMap a = new HashMap();
    private HashMap b = new HashMap();
    private static final Debug c = Debug.getInstance("ssl");
    private HashMap d = new HashMap();

    X509KeyManagerImpl(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (keyStore == null) {
            return;
        }
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Object object;
            Certificate[] certificateArray;
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string) || (certificateArray = keyStore.getCertificateChain(string)) == null || certificateArray.length <= 0 || !(certificateArray[0] instanceof X509Certificate)) continue;
            if (!(certificateArray instanceof X509Certificate[])) {
                object = new X509Certificate[certificateArray.length];
                System.arraycopy(certificateArray, 0, object, 0, certificateArray.length);
                certificateArray = object;
            }
            object = keyStore.getKey(string, cArray);
            this.b.put(string, certificateArray);
            this.a.put(string, object);
            if (c == null || !Debug.isOn("keymanager")) continue;
            System.out.println("***");
            System.out.println("found key for : " + string);
            int n = 0;
            while (n < certificateArray.length) {
                System.out.println("chain [" + n + "] = " + certificateArray[n]);
                ++n;
            }
            System.out.println("***");
        }
    }

    public String chooseClientAlias(String string, Principal[] principalArray) {
        String[] stringArray = this.getClientAliases(string, principalArray);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray[0];
    }

    public synchronized String chooseServerAlias(String string, Principal[] principalArray) {
        String[] stringArray;
        if (string == null) {
            return null;
        }
        if (principalArray == null || principalArray.length == 0) {
            stringArray = (String[])this.d.get(string);
            if (stringArray == null) {
                stringArray = this.getServerAliases(string, principalArray);
                this.d.put(string, stringArray);
            }
        } else {
            stringArray = this.getServerAliases(string, principalArray);
        }
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray[0];
    }

    public X509Certificate[] getCertificateChain(String string) {
        Object v = this.b.get(string);
        if (!(v instanceof X509Certificate[])) {
            return null;
        }
        return (X509Certificate[])((X509Certificate[])v).clone();
    }

    public String[] getClientAliases(String string, Principal[] principalArray) {
        String[] stringArray;
        if (string == null) {
            return null;
        }
        Iterator iterator = this.b.keySet().iterator();
        HashMap<String[], String[]> hashMap = new HashMap<String[], String[]>();
        int n = principalArray != null ? principalArray.length : 0;
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            X509Certificate[] x509CertificateArray = (X509Certificate[])this.b.get(stringArray);
            if (!string.equals(x509CertificateArray[0].getPublicKey().getAlgorithm())) continue;
            int n2 = 0;
            while (n2 < n) {
                int n3 = 0;
                while (n3 < x509CertificateArray.length) {
                    block7: {
                        X500Name x500Name = null;
                        try {
                            x500Name = X500Name.a(x509CertificateArray[n3].getIssuerDN());
                        }
                        catch (IOException iOException) {
                            if (c == null || !Debug.isOn("keymanager")) break block7;
                            System.out.println("X500Name threw: " + iOException);
                            break block7;
                        }
                        if (x500Name.equals(principalArray[n2])) {
                            hashMap.put(stringArray, stringArray);
                            if (c == null || !Debug.isOn("keymanager")) break;
                            System.out.println("matching client alias : " + (String)stringArray);
                            break;
                        }
                    }
                    ++n3;
                }
                ++n2;
            }
            if (n != 0) continue;
            hashMap.put(stringArray, stringArray);
            if (c == null || !Debug.isOn("keymanager")) continue;
            System.out.println("matching client alias : " + (String)stringArray);
        }
        stringArray = hashMap.values().toArray(new String[hashMap.size()]);
        return stringArray;
    }

    public PrivateKey getPrivateKey(String string) {
        Object v = this.a.get(string);
        if (!(v instanceof PrivateKey)) {
            return null;
        }
        return (PrivateKey)v;
    }

    public String[] getServerAliases(String string, Principal[] principalArray) {
        String[] stringArray;
        if (string == null) {
            return null;
        }
        Iterator iterator = this.b.keySet().iterator();
        HashMap<String[], String[]> hashMap = new HashMap<String[], String[]>();
        int n = principalArray != null ? principalArray.length : 0;
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            X509Certificate[] x509CertificateArray = (X509Certificate[])this.b.get(stringArray);
            if (!string.equals(x509CertificateArray[0].getPublicKey().getAlgorithm())) continue;
            int n2 = 0;
            while (n2 < n) {
                int n3 = 0;
                while (n3 < x509CertificateArray.length) {
                    block7: {
                        X500Name x500Name = null;
                        try {
                            x500Name = X500Name.a(x509CertificateArray[n3].getIssuerDN());
                        }
                        catch (IOException iOException) {
                            if (c == null || !Debug.isOn("keymanager")) break block7;
                            System.out.println("X500Name threw: " + iOException);
                            break block7;
                        }
                        if (x500Name.equals(principalArray[n2])) {
                            hashMap.put(stringArray, stringArray);
                            if (c == null || !Debug.isOn("keymanager")) break;
                            System.out.println("matching server alias : " + (String)stringArray);
                            break;
                        }
                    }
                    ++n3;
                }
                ++n2;
            }
            if (n != 0) continue;
            hashMap.put(stringArray, stringArray);
            if (c == null || !Debug.isOn("keymanager")) continue;
            System.out.println("matching server alias : " + (String)stringArray);
        }
        stringArray = hashMap.values().toArray(new String[hashMap.size()]);
        return stringArray;
    }
}

