/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import jcifs.smb.DosError;
import jcifs.smb.NtStatus;
import jcifs.smb.WinError;
import jcifs.util.Hexdump;

public class SmbException
extends IOException
implements NtStatus,
DosError,
WinError {
    private int status;
    private Throwable rootCause;

    static String getMessageByCode(int errcode) {
        if ((errcode & 0xC0000000) == -1073741824) {
            int min = 0;
            int max = NtStatus.NT_STATUS_CODES.length;
            while (max >= min) {
                int mid = (min + max) / 2;
                if (errcode > NtStatus.NT_STATUS_CODES[mid]) {
                    min = mid + 1;
                    continue;
                }
                if (errcode < NtStatus.NT_STATUS_CODES[mid]) {
                    max = mid - 1;
                    continue;
                }
                return NtStatus.NT_STATUS_MESSAGES[mid];
            }
        } else {
            int min = 0;
            int max = DosError.DOS_ERROR_CODES.length;
            while (max >= min) {
                int mid = (min + max) / 2;
                if (errcode > DosError.DOS_ERROR_CODES[mid][0]) {
                    min = mid + 1;
                    continue;
                }
                if (errcode < DosError.DOS_ERROR_CODES[mid][0]) {
                    max = mid - 1;
                    continue;
                }
                return DosError.DOS_ERROR_MESSAGES[mid];
            }
        }
        return "0x" + Hexdump.toHexString(errcode, 8);
    }

    static int getStatusByCode(int errcode) {
        if ((errcode & 0xC0000000) == -1073741824) {
            return errcode;
        }
        int min = 0;
        int max = DosError.DOS_ERROR_CODES.length;
        while (max >= min) {
            int mid = (min + max) / 2;
            if (errcode > DosError.DOS_ERROR_CODES[mid][0]) {
                min = mid + 1;
                continue;
            }
            if (errcode < DosError.DOS_ERROR_CODES[mid][0]) {
                max = mid - 1;
                continue;
            }
            return DosError.DOS_ERROR_CODES[mid][1];
        }
        return -1073741823;
    }

    static String getMessageByWinerrCode(int errcode) {
        int min = 0;
        int max = WinError.WINERR_CODES.length;
        while (max >= min) {
            int mid = (min + max) / 2;
            if (errcode > WinError.WINERR_CODES[mid]) {
                min = mid + 1;
                continue;
            }
            if (errcode < WinError.WINERR_CODES[mid]) {
                max = mid - 1;
                continue;
            }
            return WinError.WINERR_MESSAGES[mid];
        }
        return errcode + "";
    }

    SmbException() {
    }

    SmbException(int errcode, Throwable rootCause) {
        super(SmbException.getMessageByCode(errcode));
        this.status = SmbException.getStatusByCode(errcode);
        this.rootCause = rootCause;
    }

    SmbException(String msg) {
        super(msg);
        this.status = -1073741823;
    }

    SmbException(String msg, Throwable rootCause) {
        super(msg);
        this.rootCause = rootCause;
        this.status = -1073741823;
    }

    SmbException(int errcode, boolean winerr) {
        super(winerr ? SmbException.getMessageByWinerrCode(errcode) : SmbException.getMessageByCode(errcode));
        this.status = winerr ? errcode : SmbException.getStatusByCode(errcode);
    }

    public int getNtStatus() {
        return this.status;
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public String toString() {
        if (this.rootCause != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.rootCause.printStackTrace(pw);
            return super.toString() + "\n" + sw;
        }
        return super.toString();
    }
}

