/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.InputStream;
import jcifs.smb.ServerMessageBlock;

class SmbComWrite
extends ServerMessageBlock {
    private int fid;
    private int count;
    private int offset;
    private int remaining;
    private int off;
    private byte[] b;

    SmbComWrite() {
        this.command = (byte)11;
    }

    SmbComWrite(int fid, int offset, int remaining, byte[] b, int off, int len) {
        this.fid = fid;
        this.count = len;
        this.offset = offset;
        this.remaining = remaining;
        this.b = b;
        this.off = off;
        this.command = (byte)11;
    }

    void setParam(int fid, long offset, int remaining, byte[] b, int off, int len) {
        this.fid = fid;
        this.offset = (int)(offset & 0xFFFFFFFFL);
        this.remaining = remaining;
        this.b = b;
        this.off = off;
        this.count = len;
    }

    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SmbComWrite.writeInt2(this.fid, dst, dstIndex);
        SmbComWrite.writeInt2(this.count, dst, dstIndex += 2);
        SmbComWrite.writeInt4(this.offset, dst, dstIndex += 2);
        SmbComWrite.writeInt2(this.remaining, dst, dstIndex += 4);
        return (dstIndex += 2) - start;
    }

    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        dst[dstIndex++] = 1;
        SmbComWrite.writeInt2(this.count, dst, dstIndex);
        System.arraycopy(this.b, this.off, dst, dstIndex += 2, this.count);
        return (dstIndex += this.count) - start;
    }

    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    int readBytesDirectWireFormat(InputStream in, int byteCount) throws IOException {
        return 0;
    }

    public String toString() {
        return new String("SmbComWrite[" + super.toString() + ",fid=" + this.fid + ",count=" + this.count + ",offset=" + this.offset + ",remaining=" + this.remaining + "]");
    }
}

