/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.Config;

class BufferCache {
    private static final int MAX_BUFFERS = Config.getInt("jcifs.smb.maxBuffers", 16);
    private static Object[] cache = new Object[MAX_BUFFERS];
    private static int numBuffers = 0;
    private static int freeBuffers = 0;

    BufferCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] getBuffer() {
        Object[] objectArray = cache;
        synchronized (cache) {
            while (freeBuffers == 0 && numBuffers == MAX_BUFFERS) {
                try {
                    cache.wait();
                }
                catch (InterruptedException ie) {
                    // ** MonitorExit[var1] (shouldn't be in output)
                    return null;
                }
            }
            if (freeBuffers > 0) {
                for (int i = 0; i < MAX_BUFFERS; ++i) {
                    if (cache[i] == null) continue;
                    byte[] buf = (byte[])cache[i];
                    BufferCache.cache[i] = null;
                    --freeBuffers;
                    // ** MonitorExit[var1] (shouldn't be in output)
                    return buf;
                }
            }
            byte[] buf = new byte[65535];
            ++numBuffers;
            // ** MonitorExit[var1] (shouldn't be in output)
            return buf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseBuffer(byte[] buf) {
        Object[] objectArray = cache;
        synchronized (cache) {
            for (int i = 0; i < MAX_BUFFERS; ++i) {
                if (cache[i] != null) continue;
                BufferCache.cache[i] = buf;
                ++freeBuffers;
                cache.notify();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

