/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.BigInt;
import com.sun.net.ssl.internal.ssl.BitArray;
import com.sun.net.ssl.internal.ssl.DerInputBuffer;
import com.sun.net.ssl.internal.ssl.DerValue;
import com.sun.net.ssl.internal.ssl.ObjectIdentifier;
import com.sun.net.ssl.internal.ssl.SunJSSE_g;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class DerInputStream {
    DerInputBuffer a;

    DerInputStream(DerInputBuffer derInputBuffer) {
        this.a = derInputBuffer;
        this.a.mark(Integer.MAX_VALUE);
    }

    public DerInputStream(byte[] byArray) {
        this.a(byArray, 0, byArray.length);
    }

    public DerInputStream(byte[] byArray, int n, int n2) {
        this.a(byArray, n, n2);
    }

    public int available() {
        return this.a.available();
    }

    public byte[] getBitString() throws IOException {
        byte[] byArray;
        if (this.a.read() != 3) {
            throw new IOException("DER input not an bit string");
        }
        int n = DerInputStream.a(this.a);
        if (this.a.read() != 0) {
            throw new IOException("unaligned bit string");
        }
        if (this.a.read(byArray = new byte[--n]) != n) {
            throw new IOException("short read of DER bit string");
        }
        return byArray;
    }

    int a() throws IOException {
        return 0xFF & this.a.read();
    }

    public void getBytes(byte[] byArray) throws IOException {
        if (this.a.read(byArray) != byArray.length) {
            throw new IOException("short read of DER octet string");
        }
    }

    public DerValue getDerValue() throws IOException {
        return new DerValue(this.a);
    }

    public BigInt getEnumerated() throws IOException {
        if (this.a.read() != 10) {
            throw new IOException("DER input, Enumerated tag error");
        }
        return this.a.a(DerInputStream.a(this.a));
    }

    public Date getGeneralizedTime() throws IOException {
        int n;
        if (this.a.read() != 24) {
            throw new IOException("DER input, GeneralizedTime tag invalid ");
        }
        if (this.a.available() < 13) {
            throw new IOException("DER input, GeneralizedTime short input");
        }
        int n2 = DerInputStream.a(this.a);
        int n3 = 1000 * Character.digit((char)this.a.read(), 10);
        n3 += 100 * Character.digit((char)this.a.read(), 10);
        n3 += 10 * Character.digit((char)this.a.read(), 10);
        n3 += Character.digit((char)this.a.read(), 10);
        int n4 = 10 * Character.digit((char)this.a.read(), 10);
        n4 += Character.digit((char)this.a.read(), 10);
        --n4;
        int n5 = 10 * Character.digit((char)this.a.read(), 10);
        n5 += Character.digit((char)this.a.read(), 10);
        int n6 = 10 * Character.digit((char)this.a.read(), 10);
        n6 += Character.digit((char)this.a.read(), 10);
        int n7 = 10 * Character.digit((char)this.a.read(), 10);
        n7 += Character.digit((char)this.a.read(), 10);
        if ((n2 -= 12) == 3 || n2 == 7) {
            n = 10 * Character.digit((char)this.a.read(), 10);
            n += Character.digit((char)this.a.read(), 10);
            n2 -= 2;
        } else {
            n = 0;
        }
        if (n4 < 0 || n5 <= 0 || n4 > 11 || n5 > 31 || n6 >= 24 || n7 >= 60 || n >= 60) {
            throw new IOException("Parse Generalized time, invalid format");
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.set(n3, n4, n5, n6, n7, n);
        calendar.set(0, 1);
        Date date = calendar.getTime();
        long l = date.getTime();
        if (n2 != 1 && n2 != 5) {
            throw new IOException("Parse Generalized time, invalid offset");
        }
        switch (this.a.read()) {
            case 43: {
                int n8 = 10 * Character.digit((char)this.a.read(), 10);
                int n9 = 10 * Character.digit((char)this.a.read(), 10);
                if ((n8 += Character.digit((char)this.a.read(), 10)) >= 24 || (n9 += Character.digit((char)this.a.read(), 10)) >= 60) {
                    throw new IOException("Parse GeneralizedTime, +hhmm");
                }
                l += (long)((n8 * 60 + n9) * 60 * 1000);
                break;
            }
            case 45: {
                int n10 = 10 * Character.digit((char)this.a.read(), 10);
                int n11 = 10 * Character.digit((char)this.a.read(), 10);
                if ((n10 += Character.digit((char)this.a.read(), 10)) >= 24 || (n11 += Character.digit((char)this.a.read(), 10)) >= 60) {
                    throw new IOException("Parse GeneralizedTime, -hhmm");
                }
                l -= (long)((n10 * 60 + n11) * 60 * 1000);
                break;
            }
            default: {
                throw new IOException("Parse GeneralizedTime, garbage offset");
            }
            case 90: 
        }
        date.setTime(l);
        return date;
    }

    public BigInt getInteger() throws IOException {
        if (this.a.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.a.a(DerInputStream.a(this.a));
    }

    int b() throws IOException {
        return DerInputStream.a(this.a);
    }

    static int a(int n, InputStream inputStream) throws IOException {
        int n2;
        int n3 = n;
        if ((n3 & 0x80) == 0) {
            n2 = n3;
        } else {
            if ((n3 &= 0x7F) == 0) {
                return -1;
            }
            if (n3 < 0 || n3 > 4) {
                throw new IOException("DerInputStream.getLength(): lengthTag=" + n3 + ", " + (n3 < 0 ? "incorrect DER encoding." : "too big."));
            }
            n2 = 0;
            while (n3 > 0) {
                n2 <<= 8;
                n2 += 0xFF & inputStream.read();
                --n3;
            }
        }
        return n2;
    }

    static int a(InputStream inputStream) throws IOException {
        return DerInputStream.a(inputStream.read(), inputStream);
    }

    public void getNull() throws IOException {
        if (this.a.read() != 5 || this.a.read() != 0) {
            throw new IOException("getNull, bad data");
        }
    }

    public ObjectIdentifier getOID() throws IOException {
        return new ObjectIdentifier(this);
    }

    public byte[] getOctetString() throws IOException {
        if (this.a.read() != 4) {
            throw new IOException("DER input not an octet string");
        }
        int n = DerInputStream.a(this.a);
        byte[] byArray = new byte[n];
        if (this.a.read(byArray) != n) {
            throw new IOException("short read of DER octet string");
        }
        return byArray;
    }

    public DerValue[] getSequence(int n) throws IOException {
        if (this.a.read() != 48) {
            throw new IOException("Sequence tag error");
        }
        return this.readVector(n);
    }

    public DerValue[] getSet(int n) throws IOException {
        if (this.a.read() != 49) {
            throw new IOException("Set tag error");
        }
        return this.readVector(n);
    }

    public DerValue[] getSet(int n, boolean bl) throws IOException {
        int n2 = this.a.read();
        if (!bl && n2 != 49) {
            throw new IOException("Set tag error");
        }
        return this.readVector(n);
    }

    public Date getUTCTime() throws IOException {
        int n;
        if (this.a.read() != 23) {
            throw new IOException("DER input, UTCtime tag invalid ");
        }
        if (this.a.available() < 11) {
            throw new IOException("DER input, UTCtime short input");
        }
        int n2 = DerInputStream.a(this.a);
        if (n2 < 11 || n2 > 17) {
            throw new IOException("DER getUTCTime length error");
        }
        int n3 = 10 * Character.digit((char)this.a.read(), 10);
        n3 = (n3 += Character.digit((char)this.a.read(), 10)) <= 50 ? (n3 += 2000) : (n3 += 1900);
        int n4 = 10 * Character.digit((char)this.a.read(), 10);
        n4 += Character.digit((char)this.a.read(), 10);
        --n4;
        int n5 = 10 * Character.digit((char)this.a.read(), 10);
        n5 += Character.digit((char)this.a.read(), 10);
        int n6 = 10 * Character.digit((char)this.a.read(), 10);
        n6 += Character.digit((char)this.a.read(), 10);
        int n7 = 10 * Character.digit((char)this.a.read(), 10);
        n7 += Character.digit((char)this.a.read(), 10);
        if ((n2 -= 10) == 3 || n2 == 7) {
            n = 10 * Character.digit((char)this.a.read(), 10);
            n += Character.digit((char)this.a.read(), 10);
            n2 -= 2;
        } else {
            n = 0;
        }
        if (n4 < 0 || n5 <= 0 || n4 > 11 || n5 > 31 || n6 >= 24 || n7 >= 60 || n >= 60) {
            throw new IOException("Parse UTC time, invalid format");
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.set(n3, n4, n5, n6, n7, n);
        calendar.set(0, 1);
        Date date = calendar.getTime();
        long l = date.getTime() / 1000L * 1000L;
        if (n2 != 1 && n2 != 5) {
            throw new IOException("Parse UTC time, invalid offset");
        }
        switch (this.a.read()) {
            case 43: {
                int n8 = 10 * Character.digit((char)this.a.read(), 10);
                int n9 = 10 * Character.digit((char)this.a.read(), 10);
                if ((n8 += Character.digit((char)this.a.read(), 10)) >= 24 || (n9 += Character.digit((char)this.a.read(), 10)) >= 60) {
                    throw new IOException("Parse UTCtime, +hhmm");
                }
                l += (long)((n8 * 60 + n9) * 60 * 1000);
                break;
            }
            case 45: {
                int n10 = 10 * Character.digit((char)this.a.read(), 10);
                int n11 = 10 * Character.digit((char)this.a.read(), 10);
                if ((n10 += Character.digit((char)this.a.read(), 10)) >= 24 || (n11 += Character.digit((char)this.a.read(), 10)) >= 60) {
                    throw new IOException("Parse UTCtime, -hhmm");
                }
                l -= (long)((n10 * 60 + n11) * 60 * 1000);
                break;
            }
            default: {
                throw new IOException("Parse UTCtime, garbage offset");
            }
            case 90: 
        }
        date.setTime(l);
        return date;
    }

    public BitArray getUnalignedBitString() throws IOException {
        if (this.a.read() != 3) {
            throw new IOException("DER input not a bit string");
        }
        int n = DerInputStream.a(this.a) - 1;
        int n2 = n * 8 - this.a.read();
        byte[] byArray = new byte[n];
        if (this.a.read(byArray) != n) {
            throw new IOException("short read of DER bit string");
        }
        return new BitArray(n2, byArray);
    }

    private void a(byte[] byArray, int n, int n2) {
        if (SunJSSE_g.a(byArray[n + 1])) {
            try {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
                SunJSSE_g sunJSSE_g = new SunJSSE_g();
                this.a = new DerInputBuffer(sunJSSE_g.a(byArray2));
            }
            catch (IOException iOException) {}
        } else {
            this.a = new DerInputBuffer(byArray, n, n2);
        }
        this.a.mark(Integer.MAX_VALUE);
    }

    public void mark(int n) {
        this.a.mark(n);
    }

    public int peekByte() throws IOException {
        return this.a.d();
    }

    protected DerValue[] readVector(int n) throws IOException {
        int n2 = DerInputStream.a(this.a);
        if (n2 == 0) {
            return new DerValue[0];
        }
        DerInputStream derInputStream = this.a.available() == n2 ? this : this.subStream(n2, true);
        Vector<DerValue> vector = new Vector<DerValue>(n, 5);
        do {
            DerValue derValue = new DerValue(derInputStream.a);
            vector.addElement(derValue);
        } while (derInputStream.available() > 0);
        if (derInputStream.available() != 0) {
            throw new IOException("extra data at end of vector");
        }
        int n3 = vector.size();
        DerValue[] derValueArray = new DerValue[n3];
        int n4 = 0;
        while (n4 < n3) {
            derValueArray[n4] = (DerValue)vector.elementAt(n4);
            ++n4;
        }
        return derValueArray;
    }

    public void reset() {
        this.a.reset();
    }

    public DerInputStream subStream(int n, boolean bl) throws IOException {
        DerInputBuffer derInputBuffer = this.a.a();
        derInputBuffer.b(n);
        if (bl) {
            this.a.skip(n);
        }
        return new DerInputStream(derInputBuffer);
    }

    public byte[] toByteArray() {
        return this.a.e();
    }
}

