/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SigningDigest;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbComLogoffAndX;
import jcifs.smb.SmbComSessionSetupAndX;
import jcifs.smb.SmbComSessionSetupAndXResponse;
import jcifs.smb.SmbComTransaction;
import jcifs.smb.SmbComTransactionResponse;
import jcifs.smb.SmbException;
import jcifs.smb.SmbTransport;
import jcifs.smb.SmbTree;
import jcifs.util.LogStream;

public final class SmbSession {
    private static final String LOGON_SHARE = Config.getProperty("jcifs.smb.client.logonShare", "IPC$");
    private int uid;
    private Vector trees;
    private boolean sessionSetup;
    private UniAddress address;
    private int port;
    private int localPort;
    private InetAddress localAddr;
    SmbTransport transport = SmbTransport.NULL_TRANSPORT;
    NtlmPasswordAuthentication auth;

    public static byte[] getChallenge(UniAddress dc) throws SmbException, UnknownHostException {
        return SmbSession.getChallenge(dc, 0);
    }

    public static byte[] getChallenge(UniAddress dc, int port) throws SmbException, UnknownHostException {
        SmbTransport trans = SmbTransport.getSmbTransport(dc, port);
        trans.negotiate();
        return trans.server.encryptionKey;
    }

    public static void logon(UniAddress dc, NtlmPasswordAuthentication auth) throws SmbException {
        SmbSession.logon(dc, 0, auth);
    }

    public static void logon(UniAddress dc, int port, NtlmPasswordAuthentication auth) throws SmbException {
        SmbTransport.getSmbTransport(dc, port).getSmbSession(auth).getSmbTree(LOGON_SHARE, null).treeConnect(null, null);
    }

    SmbSession(UniAddress address, int port, InetAddress localAddr, int localPort, NtlmPasswordAuthentication auth) {
        this.address = address;
        this.port = port;
        this.localAddr = localAddr;
        this.localPort = localPort;
        this.auth = auth;
        this.trees = new Vector();
    }

    synchronized SmbTree getSmbTree(String share, String service) {
        SmbTree t;
        if (share == null) {
            share = "IPC$";
        }
        Enumeration e = this.trees.elements();
        while (e.hasMoreElements()) {
            t = (SmbTree)e.nextElement();
            if (!t.matches(share, service)) continue;
            return t;
        }
        t = new SmbTree(this, share, service);
        this.trees.addElement(t);
        return t;
    }

    boolean matches(NtlmPasswordAuthentication auth) {
        return this.auth == auth || this.auth.equals(auth);
    }

    synchronized SmbTransport transport() throws SmbException {
        if (this.transport == SmbTransport.NULL_TRANSPORT) {
            this.transport = SmbTransport.getSmbTransport(this.address, this.port, this.localAddr, this.localPort);
        }
        return this.transport;
    }

    void sendTransaction(SmbComTransaction request, SmbComTransactionResponse response) throws SmbException {
        this.sessionSetup(null, null);
        request.uid = this.uid;
        request.auth = this.auth;
        this.transport().sendTransaction(request, response);
    }

    void send(ServerMessageBlock request, ServerMessageBlock response) throws SmbException {
        if (response != null) {
            response.received = false;
        }
        this.sessionSetup(request, response);
        if (response != null && response.received) {
            return;
        }
        request.uid = this.uid;
        request.auth = this.auth;
        this.transport().send(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sessionSetup(ServerMessageBlock andx, ServerMessageBlock andxResponse) throws SmbException {
        SmbTransport smbTransport = this.transport();
        synchronized (smbTransport) {
            if (this.sessionSetup) {
                return;
            }
            this.transport.negotiate();
            if (LogStream.level > 2) {
                SmbTransport.log.println("sessionSetup: accountName=" + this.auth.username + ",primaryDomain=" + this.auth.domain);
            }
            SmbComSessionSetupAndX request = new SmbComSessionSetupAndX(this, andx);
            SmbComSessionSetupAndXResponse response = new SmbComSessionSetupAndXResponse(andxResponse);
            if (this.transport.isSignatureSetupRequired(this.auth)) {
                if (this.auth.hashesExternal && NtlmPasswordAuthentication.DEFAULT_PASSWORD != null) {
                    this.transport.getSmbSession(NtlmPasswordAuthentication.DEFAULT).getSmbTree(LOGON_SHARE, null).treeConnect(null, null);
                }
                request.digest = new SigningDigest(this.transport, this.auth);
            }
            request.auth = this.auth;
            this.transport.send(request, response);
            if (response.isLoggedInAsGuest && "GUEST".equals(this.auth.username)) {
                throw new SmbAuthException(-1073741715);
            }
            this.uid = response.uid;
            this.sessionSetup = true;
            if (request.digest != null) {
                this.transport.digest = request.digest;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void logoff(boolean inError) {
        SmbTransport smbTransport = this.transport;
        synchronized (smbTransport) {
            try {
                if (!this.sessionSetup) {
                    return;
                }
                Enumeration e = this.trees.elements();
                while (e.hasMoreElements()) {
                    SmbTree t = (SmbTree)e.nextElement();
                    t.treeDisconnect(inError);
                }
                if (this.transport.server.security == 0) {
                    return;
                }
                if (!inError) {
                    SmbComLogoffAndX request = new SmbComLogoffAndX(null);
                    request.uid = this.uid;
                    try {
                        this.transport.send(request, null);
                    }
                    catch (SmbException se) {
                        // empty catch block
                    }
                }
                this.sessionSetup = false;
            }
            finally {
                this.transport = SmbTransport.NULL_TRANSPORT;
            }
            return;
        }
    }

    public String toString() {
        return "SmbSession[accountName=" + this.auth.username + ",primaryDomain=" + this.auth.domain + ",uid=" + this.uid + ",sessionSetup=" + this.sessionSetup + "]";
    }
}

