/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import java.math.BigInteger;

final class BigInt {
    private byte[] a;
    private static final String b = "0123456789abcdef";

    public BigInt(int n) {
        if (n < 256) {
            this.a = new byte[1];
            this.a[0] = (byte)n;
        } else if (n < 65536) {
            this.a = new byte[2];
            this.a[0] = (byte)(n >> 8);
            this.a[1] = (byte)n;
        } else if (n < 0x1000000) {
            this.a = new byte[3];
            this.a[0] = (byte)(n >> 16);
            this.a[1] = (byte)(n >> 8);
            this.a[2] = (byte)n;
        } else {
            this.a = new byte[4];
            this.a[0] = (byte)(n >> 24);
            this.a[1] = (byte)(n >> 16);
            this.a[2] = (byte)(n >> 8);
            this.a[3] = (byte)n;
        }
    }

    public BigInt(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if ((byArray[0] & 0x80) != 0) {
            throw new IllegalArgumentException("negative BigInteger");
        }
        if (byArray[0] != 0) {
            this.a = byArray;
        } else {
            this.a = new byte[byArray.length - 1];
            int n = 1;
            while (n < byArray.length) {
                this.a[n - 1] = byArray[n];
                ++n;
            }
        }
    }

    public BigInt(byte[] byArray) {
        this.a = (byte[])byArray.clone();
    }

    public boolean equals(BigInt bigInt) {
        if (this == bigInt) {
            return true;
        }
        byte[] byArray = bigInt.toByteArray();
        if (this.a.length != byArray.length) {
            return false;
        }
        int n = 0;
        while (n < this.a.length) {
            if (this.a[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof BigInt) {
            return this.equals((BigInt)object);
        }
        return false;
    }

    private String a() {
        StringBuffer stringBuffer = new StringBuffer(this.a.length * 2);
        stringBuffer.append("    ");
        int n = 0;
        while (n < this.a.length) {
            stringBuffer.append(b.charAt(this.a[n] >> 4 & 0xF));
            stringBuffer.append(b.charAt(this.a[n] & 0xF));
            if ((n + 1) % 32 == 0) {
                if (n + 1 != this.a.length) {
                    stringBuffer.append("\n    ");
                }
            } else if ((n + 1) % 4 == 0) {
                stringBuffer.append(' ');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public BigInteger toBigInteger() {
        return new BigInteger(1, this.a);
    }

    public byte[] toByteArray() {
        return (byte[])this.a.clone();
    }

    public int toInt() {
        if (this.a.length > 4) {
            throw new NumberFormatException("BigInt.toLong, too big");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.a.length) {
            n = (n << 8) + (this.a[n2] & 0xFF);
            ++n2;
        }
        return n;
    }

    public String toString() {
        return this.a();
    }
}

